<?php
/**
 * Description of StringUtils
 *
 * @author renatopeterman
 */

namespace Commons\Util;

class StringUtils {
    
    public static function cleanFilename($string){    
        $string = static::stripAccents($string);
        $string = str_replace(' ', '_', $string);
        $string = str_replace('.', '_', $string);
        return preg_replace('/[^A-Za-z0-9\_]/', '', $string);
    }
    
    public static function stripAccents($stripAccents){
        return strtr($stripAccents,'àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ','aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
    }

    public static function formatMoney($string){
        return number_format($string, 2, ",", ".");
    }
    
    public static function formatMoneyBRL($string){
        return "R$ " . number_format($string, 2, ",", ".");
    }
    
    public static function moneyStrToDouble($string){
        return (double) str_replace(',', '.', str_replace('.', '', $string));
    }

    /**
     * Convert string from camelCase to underscore_case
     * @param $input
     * @return string
     */
    public static function decamelize($input, $separator = '_') {
        preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $input, $matches);
        $ret = $matches[0];
        foreach ($ret as &$match) {
            $match = $match == strtoupper($match) ? strtolower($match) : lcfirst($match);
        }
        return implode($separator, $ret);
    }
    
}

?>
