<?php

/**
 * Description of ImageUtil
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

namespace Commons\Util;

class ImageUtil
{

    public static function resize($src, $dest, $format, $maxW, $maxH, $quality)
    {

        $image = null;
        switch ($format) {

            case 'jpg':
                $image = imagecreatefromjpeg($src);
                break;
            case 'jpeg':
                $image = imagecreatefromjpeg($src);
                break;
            case 'png':
                $image = imagecreatefrompng($src);
                break;
            case 'gif':
                $image = imagecreatefromgif($src);
                break;
            default:
                throw new \Exception('Invalid format');

        }

        // Target dimensions
        $max_width = $maxW;
        $max_height = $maxH;

        // Get current dimensions
        $old_width = imagesx($image);
        $old_height = imagesy($image);

        // Calculate the scaling we need to do to fit the image inside our frame
        $scale = min($max_width / $old_width, $max_height / $old_height);

        // Get the new dimensions
        $new_width = ceil($scale * $old_width);
        $new_height = ceil($scale * $old_height);

        // Create new empty image
        $new = imagecreatetruecolor($new_width, $new_height);

        // Resize old image into new
        imagecopyresampled($new, $image, 0, 0, 0, 0, $new_width, $new_height, $old_width, $old_height);

        // Catch the imagedata
        switch ($format) {

            case 'jpg':
            case 'jpeg':
                $retImage = imagejpeg($new, $dest, $quality);
                break;
            case 'png':
                $retImage = imagepng($new, $dest);
                break;
            case 'gif':
                $image = imagegif($new, $dest);
                break;
            default:
                throw new \Exception('Invalid format');

        }

        // Destroy resources
        imagedestroy($image);
        imagedestroy($new);

        return $retImage;

    }

}

?>
