<?php

namespace Commons\Util;

/**
 * Class FileUtil
 *
 * @author Renato Peterman <renato.pet@gmail.com>
 */
class FileUtil
{

    public static function isValid($file)
    {
        $validTypes = array(
            "image/jpg",
            "image/jpeg",
            "image/png",
            "image/gif"
        );

        return in_array($file['type'], $validTypes);

    }

    public static function getMimeTypeForExtension($ext){
        switch($ext){
            case 'pdf':
                $filetype = "application/pdf";
                break;
            case 'jpeg':
            case 'jpg':
                $filetype = "image/jpg";
                break;
            case 'png':
                $filetype = "image/png";
                break;
            case 'gif':
                $filetype = "image/gif";
                break;
            default:
                $filetype = null;
        }
        return $filetype;
    }

}