<?php

namespace Commons\Service;

class CepService {
    
    public static function getAddress($cep){
        
        $cep = preg_replace('/\D/', '', $cep);
        //$url = "https://viacep.com.br/ws/{$cep}/json/";
        $url = "http://apps.widenet.com.br/busca-cep/api/cep.json?code=".$cep;
        /*
        var url = "https://viacep.com.br/ws/"+cep.replace(/\D/g,'')+"/json/";
         {
             "cep": "86990-000",
             "logradouro": "",
             "complemento": "",
             "bairro": "",
             "localidade": "Marialva",
             "uf": "PR",
             "unidade": "",
             "ibge": "4114807",
             "gia": ""
         }
        return $http.get(url);
        */
        $client = new \Zend\Http\Client($url);
        $content = $client->send()->getBody();
        $json = json_decode($content,true);
        $json = array(
            'cep' => $json['code'],
            'logradouro' => $json['address'],
            'complemento' => $json[''],
            'bairro' => $json['district'],
            'localidade' => $json['city'],
            'uf' => $json['state'],
            'unidade' => '',
            'ibge' => '',
            'gia' => ''
        );
        if(json_last_error() != 0){
            $msg = '';
            if(function_exists('json_last_error_msg')){
                $msg = json_last_error_msg();
            }
            throw new \Exception('Invalid JSON format returned from CEP webservice. ' . $msg, json_last_error());
        }
        return $json;
        
    }
    
}