<?php

namespace Commons\Hydrator\Strategy;

use Zend\Stdlib\Hydrator\Strategy\StrategyInterface;
use DoctrineModule\Stdlib\Hydrator\Strategy\AbstractCollectionStrategy;
use ZF\Hal\Collection;

/**
 * A field-specific hydrator for collections.
 * @returns HalCollection
 */
class CustomCollectionExtract extends AbstractCollectionStrategy implements StrategyInterface
{
    public function extract($value)
    {

        $value->initialize();
        $user_ids = $value->map(function($entity)  {

            if (!function_exists('recursiveCollectionExtract')) {
                $recursiveCollectionExtract = function($entity, &$return, $level) use ( &$recursiveCollectionExtract ) {
                    //echo "\r\n $level: recursiveCollectionExtract";
                    foreach (get_class_methods($entity) as $method) {
                        if (substr($method, 0, 3) == 'get' && strstr(strtolower($method), 'arraycopy') == false) {
                            $value = $entity->$method();
                            $keyResult = strtolower(substr($method, 3, 1)).substr($method, 4);
                            if (is_object($value) && strstr(get_class($value), '\Entity') !== false) {
                                $level++;
                                if ($level < 1)
                                    $recursiveCollectionExtract($value, $return[$keyResult], $level);
                            } elseif (is_object($value) === false || strstr(get_class($value), 'PersistentCollection') === false) {
                                if (is_object($value) === true) {
                                    if (strstr(get_class($value), 'DateTime') !== false)
                                        $value->setTimezone(new \DateTimeZone('America/Sao_Paulo'));
                                }
                                $return[$keyResult] = $value;
                            }
                        }
                    }
                };
            }

            $return = array();
            $recursiveCollectionExtract($entity, $return, 0);

            return $return;
        })->toArray();

        return $user_ids;
    }

    public function hydrate($value)
    {
        // Hydration is not supported for collections.
        // A call to PATCH will use hydration to extract then hydrate
        // an entity. In this process a collection will be included
        // so no error is thrown here.

        return $value;
    }
}

/*
namespace Commons\Hydrator\Strategy;

use Zend\Stdlib\Hydrator\Strategy\StrategyInterface;
use DoctrineModule\Stdlib\Hydrator\Strategy\AbstractCollectionStrategy;
use ZF\Hal\Collection;

class CustomCollectionExtract extends AbstractCollectionStrategy
    implements StrategyInterface
{
    public function extract($value)
    {
        //Conex
        $value->initialize();
        $user_ids = $value->map(function($entity)  {

            if (!function_exists('recursiveCollectionExtract')) {
                $recursiveCollectionExtract = function($entity, &$return, $level) use ( &$recursiveCollectionExtract ) {
                    //echo "\r\n $level: recursiveCollectionExtract";
                    foreach (get_class_methods($entity) as $method) {
                        if (substr($method, 0, 3) == 'get') {
                            $value = $entity->$method();
                            $keyResult = strtolower(substr($method, 3, 1)).substr($method, 4);
                            if (is_object($value) && strstr(get_class($value), 'Db\Entity') !== false) {
                                $level++;
                                if ($level < 4)
                                    $recursiveCollectionExtract($value, $return[$keyResult], $level);
                            } elseif (is_object($value) === false || strstr(get_class($value), 'PersistentCollection') === false) {
                                if (is_object($value) === true) {
                                    if (strstr(get_class($value), 'DateTime') !== false)
                                        $value->setTimezone(new \DateTimeZone('America/Sao_Paulo'));
                                }
                                $return[$keyResult] = $value;
                            }
                        }
                    }
                };
            }

            $return = array();
            $recursiveCollectionExtract($entity, $return, 0);

            return $return;
        })->toArray();

        return $user_ids;
    }

    public function hydrate($value)
    {
        // Hydration is not supported for collections.
        // A call to PATCH will use hydration to extract then hydrate
        // an entity. In this process a collection will be included
        // so no error is thrown here.

        return $value;
    }
}
*/