<?php
/**
 * @license   http://opensource.org/licenses/BSD-3-Clause BSD-3-Clause
 * @copyright Copyright (c) 2013 Zend Technologies USA Inc. (http://www.zend.com)
 */

namespace Commons\Controller\Console;

use Commons\Util\StringUtils;
use Zend\Console\ColorInterface;
use Zend\Console\Request as ConsoleRequest;
use Zend\Mvc\Controller\AbstractActionController;
use Zend\Console\Adapter\AdapterInterface as Console;
use Zend\Console\Prompt;

class ApigilityController extends AbstractActionController
{
    const MODULE_NAME = 'APIClient';

    private $em;

    public function apiModuleAction()
    {
        try{

            // Make sure that we are running in a console and the user has not tricked our
            // application into running this action from a public web server.
            $request = $this->getRequest();
            if (!$request instanceof ConsoleRequest) {
                throw new RuntimeException('You can only use this action from a console!');
            }

            $moduleName = ApigilityController::MODULE_NAME;
            $objectManagerAlias = 'doctrine.entitymanager.orm_default';
            $routePrefix = 'api';
            $useEntityNamespacesForRoute = true;

            if($this->getServiceLocator()->get('Zend\ModuleManager\ModuleManager')->getModule($moduleName)){
                $this->getConsole()->writeLine(sprintf(
                    'The %s is already loaded. If you want to build it again, delete the contents of /modules/%s',
                    $moduleName,
                    $moduleName
                ), ColorInterface::YELLOW);
                return;
            }

            // Build Module
            $moduleResource = $this->getServiceLocator()->get('ZF\Apigility\Admin\Model\ModuleResource');
            //$moduleResource->setModulePath(realpath(__DIR__ . '/../../../../../'));
            $moduleResource->setModulePath(realpath(__DIR__ . '/../../../../../../'));

            $metadata = $moduleResource->create(array(
                'name' =>  $moduleName,
            ));

            return "$moduleName module has been created.\n";

        }catch(\Exception $ex){
            echo $ex->getMessage() . PHP_EOL;
        }
    }

    public function apiAction()
    {
        try{

            $apiFormat = $this->getRequest()->getParam('format');
            if(!$apiFormat){
                throw new \Exception("Invalid API format - accepted formats: json, rpc");
            }

            // Make sure that we are running in a console and the user has not tricked our
            // application into running this action from a public web server.
            $request = $this->getRequest();
            if (!$request instanceof ConsoleRequest) {
                throw new RuntimeException('You can only use this action from a console!');
            }

            $moduleName = ApigilityController::MODULE_NAME;

            if(!$this->getServiceLocator()->get('Zend\ModuleManager\ModuleManager')->getModule($moduleName)){
                $this->getConsole()->writeLine(sprintf(
                    'Module %s is not loaded. Did you forget to run "./app build api module" ?',
                    $moduleName
                ), ColorInterface::YELLOW);
                return;
            }

            $serviceResource = $this->getServiceLocator()->get('ZF\Apigility\Doctrine\Admin\Model\DoctrineRestServiceResource');
            $entityMetadata = $this->getEntityManager()->getMetadataFactory();

            // Create for all entities from MetadataFactory
            $entities = array();
            foreach($entityMetadata->getAllMetadata() as $class){
                //$class->getMappedSuperclass()
                //$class->getIdentifier();
                //echo $class->getName() . '<br/>';
                if(!$class->isMappedSuperclass){
                    $className = $class->getName();
                    $parts = explode("\\", $className);
                    $name = $parts[count($parts)-1];
                    $underscoreName = StringUtils::decamelize($name);
                    $dashedName = StringUtils::decamelize($name,'-');
                    $entities[strtolower($name)] = array(
                        'object_manager' => 'doctrine.entitymanager.orm_default',
                        //'service_name' => 'apigility-resource-'.$dashedName,
                        'service_name' => $name,
                        'entity_class' => $className,
                        'page_size_param' => 'limit',
                        'route_identifier_name' => strtolower($underscoreName).'_id',
                        //'entity_identifier_name' => $class->getIdentifier(),
                        'entity_identifier_name' => 'id',
                        'route_match' => '/api/v1/' . strtolower($dashedName),
                        'by_value' => true,
                        'use_generated_hydrator' => true,
                    );
                }
            }

            // Create services
            foreach ($entities as $name => $apiConfig) {
                $serviceResource->setModuleName($moduleName);
                $serviceResource->create($apiConfig);
            }

            /*
            foreach ($entityMetadata->associationMappings as $mapping) {
                switch ($mapping['type']) {
                    case 4:
                        $rpcServiceResource = $this->getServiceLocator()->get('ZF\Apigility\Doctrine\Admin\Model\DoctrineRpcServiceResource');
                        $rpcServiceResource->setModuleName($moduleName);
                        $rpcServiceResource->create(array(
                            'service_name' => $resourceName . '' . $mapping['fieldName'],
                            'route' => $mappingRoute = $route . '[/:parent_id]/' . $filter($mapping['fieldName']) . '[/:child_id]',
                            'http_methods' => array(
                                'GET',
                            ),
                            'options' => array(
                                'target_entity' => $mapping['targetEntity'],
                                'source_entity' => $mapping['sourceEntity'],
                                'field_name' => $mapping['fieldName'],
                            ),
                        ));

                        $results[$entityMetadata->name . $mapping['fieldName']] = $mappingRoute;

                        break;
                    default:
                        break;
                }
            }
            */

            /*
            foreach ($entityMetadata->associationMappings as $mapping) {
                switch ($mapping['type']) {
                    case 4:
                        $rpcServiceResource = $this->getServiceLocator()->get('ZF\Apigility\Doctrine\Admin\Model\DoctrineRpcServiceResource');
                        $rpcServiceResource->setModuleName($moduleName);
                        $rpcServiceResource->create(array(
                            'service_name' => $resourceName . '' . $mapping['fieldName'],
                            'route' => $mappingRoute = $route . '[/:parent_id]/' . $filter($mapping['fieldName']) . '[/:child_id]',
                            'http_methods' => array(
                                'GET',
                            ),
                            'options' => array(
                                'target_entity' => $mapping['targetEntity'],
                                'source_entity' => $mapping['sourceEntity'],
                                'field_name' => $mapping['fieldName'],
                            ),
                        ));

                        $results[$entityMetadata->name . $mapping['fieldName']] = $mappingRoute;

                        break;
                    default:
                        break;
                }
            }
            */

            return ("\nResources have been created.\n");

        }catch(\Exception $ex){
            echo $ex->getMessage() . PHP_EOL;
            echo $ex->getTraceAsString() . PHP_EOL;
        }
    }

    /**
     * @return Console
     */
    protected function getConsole()
    {
        return $this->getServiceLocator()->get('Console');
    }

    /**
     * Return a Doctrine Entity Manager instance
     * @return Doctrine\ORM\EntityManager
     */
    public function getEntityManager()
    {
        if (null === $this->em) {
            $this->em = $this->getServiceLocator()->get('Doctrine\ORM\EntityManager');
        }
        return $this->em;
    }
}
