<?php
namespace Commons;

use Zend\Mvc\ModuleRouteListener;
use Zend\Mvc\MvcEvent;
use Commons\Listener\DoctrineResourceListener;

class Module
{
    public function onBootstrap(MvcEvent $e)
    {
        $listener = new DoctrineResourceListener();
        $listener->setupDoctrineResourceListeners($e);

        $eventManager = $e->getApplication()->getEventManager();
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);
    }

    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\ClassMapAutoloader' => array(
                __DIR__ . '/autoload_classmap.php',
            ),
        );
    }
}
