<?php

/**
 * Description of ClienteForm
 *
 * @author renatopeterman
 */

namespace Application\Form;

use Doctrine\ORM\EntityManager;
use Zend\Form\Form;

class CustomerForm extends Form {

    public function __construct($type, $em = null) {

        parent::__construct('cliente');

        // $this->setInputFilter(new ClienteFilter());

        $this->setAttributes(array(
            'method' => 'post',
            'class' => 'form-horizontal form-validate',
        ));

        $this->add(array(
            'name' => 'id',
            'type' => 'hidden',
        ));

        $this->add(array(
            'name' => 'customerType',
            'type' => 'hidden',
            'attributes' => array(
                'class' => 'form-control',
                'value' => $type,
            ),
        ));
        
        //$docNacClass = $type == 'pj' ? 'cnpj' : 'cpf';

        $this->add(array(
            'name' => 'documentNumber',
            'type' => 'text',
            'options' => array(
                'label' => $type == 'pj' ? 'CNPJ' : 'CPF'
            ),
            'attributes' => array(
                //'class' => 'form-control mask-' . $docNacClass,
                'class' => 'form-control',
                //'required' => 'true',
                'placeholder' => $type == 'pj' ? 'CNPJ' : 'CPF',
            )
        ));

        $this->add(array(
            'name' => 'name',
            'type' => 'text',
            'options' => array(
                'label' => $type == 'pj' ? 'Nome Fantasia' : 'Nome'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'required' => 'true',
                'placeholder' => ($type == 'pj' ? 'Nome Fantasia' : 'Nome') . ' (Campo Obrigatório)'
            )
        ));
        
        if($type == 'pj'){
            
            $this->add(array(
                'name' => 'companyName',
                'type' => 'text',
                'options' => array(
                    'label' => 'Razão Social'
                ),
                'attributes' => array(
                    'class' => 'form-control',
                    'required' => true,
                    'placeholder' => 'Razão Social (Campo Obrigatório)'
                )
            ));

            $this->add(array(
                'name' => 'contact',
                'type' => 'text',
                'options' => array(
                    'label' => 'Contato'
                ),
                'attributes' => array(
                    'class' => 'form-control',
                    'required' => 'true',
                    'placeholder' => 'Nome do Contato'
                )
            ));
            
        }
        
        $this->add(array(
            'name' => 'secondaryDocumentNumber',
            'type' => 'text',
            'options' => array(
                'label' => $type == 'pj' ? 'Inscrição Estadual' : 'RG'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => $type == 'pj' ? 'Inscrição Estadual' : 'RG'
            )
        ));
        
        $this->add(array(
            'name' => 'zip',
            'type' => 'text',
            'options' => array(
                'label' => 'Cep'
            ),
            'attributes' => array(
                'class' => 'form-control mask-cep',
                'placeholder' => 'CEP',
                'id' => 'zip'
            )
        ));

        $this->add(array(
            'name' => 'address',
            'type' => 'text',
            'options' => array(
                'label' => 'Logradouro'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Logradouro. Ex.: Rua, Av...',
                'id' => 'address'
            )
        ));
        
        $this->add(array(
            'name' => 'addressNumber',
            'type' => 'text',
            'options' => array(
                'label' => 'Número'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Número',
                'id' => 'addressNumber'
            )
        ));
        
        $this->add(array(
            'name' => 'neighbourhood',
            'type' => 'text',
            'options' => array(
                'label' => 'Bairro'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Bairro',
                'id' => 'neighbourhood'
            )
        ));
        
        $this->add(array(
            'name' => 'addressComplement',
            'type' => 'text',
            'options' => array(
                'label' => 'Complemento'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Complemento'
            )
        ));
        
        $estados = array("AC"=>"Acre", "AL"=>"Alagoas", "AM"=>"Amazonas", "AP"=>"Amapá","BA"=>"Bahia","CE"=>"Ceará","DF"=>"Distrito Federal","ES"=>"Espírito Santo","GO"=>"Goiás","MA"=>"Maranhão","MT"=>"Mato Grosso","MS"=>"Mato Grosso do Sul","MG"=>"Minas Gerais","PA"=>"Pará","PB"=>"Paraíba","PR"=>"Paraná","PE"=>"Pernambuco","PI"=>"Piauí","RJ"=>"Rio de Janeiro","RN"=>"Rio Grande do Norte","RO"=>"Rondônia","RS"=>"Rio Grande do Sul","RR"=>"Roraima","SC"=>"Santa Catarina","SE"=>"Sergipe","SP"=>"São Paulo","TO"=>"Tocantins");
        
        $this->add(array(
            'name' => 'state',
            'type' => 'Commons\Form\Element\OptionalSelect',
            'options' => array(
                'label' => 'Estado',
                'empty_option' => '---',
                'value_options' => $estados
            ),
            'attributes' => array(
                'class' => 'form-control select2',
                'id' => 'state'
            )
        ));
        
        $this->add(array(
            'name' => 'city',
            'type' => 'text',
            'options' => array(
                'label' => 'Cidade'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Cidade',
                'id' => 'city'
            )
        ));
        
        $this->add(array(
            'name' => 'phonePrimary',
            'type' => 'text',
            'options' => array(
                'label' => 'Telefone Principal'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Telefone Principal'
            )
        ));
        
        $this->add(array(
            'name' => 'phoneSecondary',
            'type' => 'text',
            'options' => array(
                'label' => 'Telefone Secundário'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Telefone Secundário'
            )
        ));
        
        $this->add(array(
            'name' => 'email',
            'type' => 'text',
            'options' => array(
                'label' => 'E-mail'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'E-mail'
            )
        ));
        
        $this->add(array(
            'name' => 'website',
            'type' => 'text',
            'options' => array(
                'label' => 'Website'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Website'
            )
        ));
        
        $this->add(array(
            'name' => 'latitude',
            'type' => 'text',
            'options' => array(
                'label' => 'Latitude'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Latitude'
            )
        ));
        
        $this->add(array(
            'name' => 'longitude',
            'type' => 'text',
            'options' => array(
                'label' => 'Longitude'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Longitude'
            )
        ));
        
        $this->add(array(
            'name' => 'info',
            'type' => 'Zend\Form\Element\Textarea',
            'options' => array(
                'label' => 'Informações Adicionais'
            ),
            'attributes' => array(
                'class' => 'form-control'
            )
        ));
        
        $this->add(array(
            'name' => 'active',
            'type' => 'Zend\Form\Element\Checkbox',
            'options' => array(
                'label' => 'Ativo?'
            ),
            'attributes' => array(
                'class' => ''
            )
        ));

        $this->add(array(
            'name' => 'blocked',
            'type' => 'Zend\Form\Element\Checkbox',
            'options' => array(
                'label' => 'Bloqueado?'
            ),
            'attributes' => array(
                'class' => ''
            )
        ));

        $this->add(array(
            'name' => 'representedCompanies',
            'required' => 'false',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Representadas',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\RepresentedCompany',
                'display_empty_item' => true,
                'empty_item_label' => '---',
                'empty_option' => '---'
            ),
            'attributes' => array(
                'class' => 'form-control select2',
                'multiple' => true
            )
        ));

    }

}

?>
