<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class WarehouseTransactionController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        return new ViewModel(array('data' => $data));
    }
    
    public function addAction()
    {
        
        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $form->bind($entity);
            $form->setData($request->getPost());
            
            if($form->isValid()){
                
                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($request->getPost()->toArray(), $entity);
                
                $entity->setUser($this->identity());
                
                $this->getEntityManager()->persist($entity);
                
                
                if($this->identity()->getAdmin()){
                    
                    $entity->setStatus(true);
                    
                    if($entity->getTransactionType() == \Model\Entity\WarehouseTransaction::TYPE_ENTRADA){
                        
                        $pw = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findOneBy(array('product' => $entity->getProduct(), 'warehouse' => $entity->getWarehouseTo()));
                        $pw->setAmount( $pw->getAmount()+$entity->getAmount() );
                        $this->getEntityManager()->merge($pw);
                        
                    }else if($entity->getTransactionType() == \Model\Entity\WarehouseTransaction::TYPE_TRANSFERENCIA){
                        
                        // TODO: Tratar negativos
                        // TODO: Mostrar quantidade via ajax antes do lançamento
                        $pw = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findOneBy(array('product' => $entity->getProduct(), 'warehouse' => $entity->getWarehouseFrom()));
                        $pw->setAmount( $pw->getAmount() - $entity->getAmount() );
                        $this->getEntityManager()->merge($pw);
                        
                        $pw = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findOneBy(array('product' => $entity->getProduct(), 'warehouse' => $entity->getWarehouseTo()));
                        $pw->setAmount( $pw->getAmount()+$entity->getAmount() );
                        $this->getEntityManager()->merge($pw);
                        
                    }
                    
                    
                    
                }else{
                    $entity->setStatus(false);
                }
                
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Transação realizada com sucesso!');
                
                return $this->redirectToDefaultRoute();
            }
            
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));

        if ($request->isPost()){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);
            //$usuario->populate($form->getData());

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function removeAction()
    {
        $id = $this->params()->fromRoute('id', false);
        
        if($id){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if($entity){
                $this->getEntityManager()->remove($entity);
                $this->getEntityManager()->flush();
                $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
                return $this->redirectToDefaultRoute();
            }else{
                $this->flashMessenger()->addErrorMessage('Erro ao remover registro. Código não encontrado.');
            }
            
        }else{
            $this->flashMessenger()->addErrorMessage('Erro ao remover registro. Código não encontrado.');
        }
        
        return $this->redirectToDefaultRoute();
    }
}
