<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class WarehouseManagerController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $warehouseList = $this->getEntityManager()->getRepository('Model\Entity\Warehouse')->findAll();
        $warehouse = $this->params()->fromQuery('warehouse', false);
        $data = null;

        if($warehouse){
            $data = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findByWarehouse($warehouse);
        }
        
        return new ViewModel(array('data' => $data, 'warehouseList' => $warehouseList, 'warehouse' => $warehouse));
    }
    
    public function viewAction()
    {
        $id = $this->params()->fromRoute('id',false);
        $warehouse = $this->getEntityManager()->find('Model\Entity\Warehouse',$id);
        if($warehouse->getMain()){
            $data = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findByWarehouse($warehouse);
        }else{
            
            $data = $this->getEntityManager()->createQueryBuilder()
                    ->select('obj')
                    ->from('Model\Entity\ProductWarehouse', 'obj')
                    ->where('obj.warehouse = :wh AND obj.amount > 0.0')
                    ->setParameter('wh', $warehouse)
                    ->getQuery()->getResult();
        }
        
        return new ViewModel(array('data' => $data, 'entity' => $warehouse));
    }

    public function saveAction(){

        $responseData = array(
            'success' => false
        );

        try{

            if(!$this->getRequest()->isPost()){
                throw new \Exception("Requisição inválida");
            }

            $warehouse = $this->params()->fromQuery('warehouse', false);
            $products = $this->params()->fromPost('product',false);

            foreach($products as $key => $val){
                $pw = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $key, 'warehouse' => $warehouse));
                $pw->setAmount($val);
                $this->getEntityManager()->merge($pw);
            }

            $this->getEntityManager()->flush();

            $responseData['success'] = true;

        }catch (\Exception $ex){
            $responseData['message'] = $ex->getMessage();
        }

        return new JsonModel($responseData);

    }
    
}
