<?php

/**
 * 
 * Login controller
 * 
 * @author Renato Peterman (renato.pet at gmail.com)
 */

namespace Application\Controller;

use Application\Form\LoginForm;
use Model\Entity\User;
use Model\Entity\Warehouse;
use Zend\View\Model\ViewModel;

class LoginController extends AbstractApplicationController
{
    /**
     * Index action 
     * User Authentication method
     * @return \Zend\View\Model\ViewModel
     * @throws \Exception
     */
    public function indexAction()
    {

        // Create automatic admin
        $countUsers = $this->getEntityManager()->createQuery("SELECT COUNT(obj.id) FROM Model\\Entity\\User obj")->getSingleScalarResult();
        if($countUsers <= 0){
            $u = new User();
            $u->setName("Administrador");
            $u->setEmail("admin@localhost");
            $u->setUsername("admin");
            $u->setPassword("123mudar");
            $u->setActive(true);
            $u->setAdmin(true);
            $this->getEntityManager()->persist($u);
            $this->getEntityManager()->flush();
        }

        // Create automatic config
        $countConfig = $this->getEntityManager()->createQuery("SELECT COUNT(obj.id) FROM Model\\Entity\\Config obj")->getSingleScalarResult();
        if($countConfig <= 0){
            $c = new \Model\Entity\Config();
            $c->setMaxDiscount(0.0);
            $this->getEntityManager()->persist($c);
            $this->getEntityManager()->flush();
        }

        // Count warehouses
        $countWarehouse = $this->getEntityManager()->createQuery("SELECT COUNT(obj.id) FROM Model\\Entity\\Warehouse obj")->getSingleScalarResult();
        if($countWarehouse <= 0){
            $w = new Warehouse();
            $w->setDescription("Padrão");
            $w->setMain(true);
            $w->setActive(true);
            $this->getEntityManager()->persist($w);
            $this->getEntityManager()->flush();
        }
        
        $form = new LoginForm();
        $this->layout('layout/login');
        $request = $this->getRequest();
        $error = null;
        
        try{
            
            if($request->isPost()){
                
                # Get Post Params
                $username = $this->params()->fromPost('username');
                $password = $this->params()->fromPost('password');
                $remember = $this->params()->fromPost('remember');
                
                # Set Post Params to Form
                $form->setData($request->getPost());

                # Check if params was setted
                if(!$username || !$password){
                    throw new \Exception('Usuário ou Senha inválidos (1)');
                }
                
                # Query user by username
                $entity = $this->getEntityManager()->createQueryBuilder('Model\Entity\User')
                                                            ->add('select','obj')
                                                            ->add('from','Model\Entity\User obj')
                                                            ->add('where','obj.username=:param')
                                                            ->setParameter('param', $username)
                                                            ->getQuery()->getOneOrNullResult();
                # Check if returned value is valid
                if(!$entity){
                    throw new \Exception('Usuário ou Senha inválidos (2)');
                }
                
                # Check for password
                if(!User::hashPassword($entity, $password)){
                    throw new \Exception('Usuário ou Senha inválidos (3)');
                }
                
                # Check if user is enabled
                if(!$entity->getActive()){
                    throw new \Exception('Usuário desativado. Entre em contato com o suporte técnico para maiores informações.');
                }
                
                # Authenticate
                $auth = $this->getAuthManager();
                $auth->getAdapter()->setIdentityValue($username);
                $auth->getAdapter()->setCredentialValue($password);
                $result = $auth->authenticate();

                # Check if return is valid
                if(!$result->isValid()){
                    throw new \Exception('Usuário ou Senha inválidos');
                }
                
                # Remember me
                if($remember){
                    $time = 1209600; // 14 days (1209600/3600 = 336 hours => 336/24 = 14 days)
                    $sessionManager = new \Zend\Session\SessionManager();
                    $sessionManager->rememberMe($time);
                }
                
                # Redirect to home route if ok
                return $this->redirect()->toRoute('home');
                
            }
            
        // Database Error
        }catch(\Doctrine\DBAL\DBALException $ex){ 
            
            $error = "Ocorreu um erro ao autenticar o usuário. Erro " . $ex->getCode();
            
        // Others
        }catch(\Exception $ex){

            $error = $ex->getMessage();
            
        }
        
        return new ViewModel(array(
            'form' => $form,
            'error' => $error
        ));
    }
    
    public function authAction(){
        
        $response = array(
            'success' => false,
            'message' => ''
        );
        
        try{
            
            $request = $this->getRequest();
            
            if (!$request->isPost()){
                throw new \Exception('Método não autorizado');
            }
            
            # Get Post Params
            $username = $this->params()->fromPost('username');
            $password = $this->params()->fromPost('password');

            # Check if params was setted
            if(!$username || !$password){
                throw new \Exception('Usuário ou Senha inválidos (1)');
            }

            # Query user by username
            $entity = $this->getEntityManager()->createQueryBuilder('Model\Entity\User')
                                                        ->add('select','obj')
                                                        ->add('from','Model\Entity\User obj')
                                                        ->add('where','obj.username=:param')
                                                        ->setParameter('param', $username)
                                                        ->getQuery()->getOneOrNullResult();
            # Check if returned value is valid
            if(!$entity){
                throw new \Exception('Usuário ou Senha inválidos (2)');
            }

            # Check for password
            if(!User::hashPassword($entity, $password)){
                throw new \Exception('Usuário ou Senha inválidos (3)');
            }

            # Check if user is enabled
            if(!$entity->getActive()){
                throw new \Exception('Usuário desativado. Entre em contato com o suporte técnico para maiores informações.');
            }

            # Authenticate
            $auth = $this->getAuthManager();
            $auth->getAdapter()->setIdentityValue($username);
            $auth->getAdapter()->setCredentialValue($password);
            $result = $auth->authenticate();

            # Check if return is valid
            if(!$result->isValid()){
                throw new \Exception('Usuário ou Senha inválidos');
            }
            
            # Remember me
            if(isset($remember) && $remember){
                $time = 1209600; // 14 days (1209600/3600 = 336 hours => 336/24 = 14 days)
                $sessionManager = new \Zend\Session\SessionManager();
                $sessionManager->rememberMe($time);
            }

            $response['success'] = true;
            
        }catch(\Exception $ex){
            $response['message'] = $ex->getMessage();
        }
        
        return new \Zend\View\Model\JsonModel($response);
        
    }
    
    /**
     * Passwor recovery action
     * @return \Zend\View\Model\ViewModel
     */
    public function passwordRecoverAction(){
        return new ViewModel();
    }
    
    /**
     * Do user logout and redirect to login route
     * 
     * @return redirect
     */
    public function logoutAction()
    {
        if($this->getAuthManager()->hasIdentity()){
            $this->getAuthManager()->clearIdentity();
            $sessionManager = new \Zend\Session\SessionManager();
            $sessionManager->forgetMe();
        }
        return $this->redirect()->toRoute('login');
    }
    
    /**
     * Set default layout for controller
     * 
     * @param \Zend\Stdlib\RequestInterface $request
     * @param \Zend\Stdlib\ResponseInterface $response
     */
    public function dispatch(\Zend\Stdlib\RequestInterface $request, \Zend\Stdlib\ResponseInterface $response = null) {
        $this->getEvent()->getViewModel()->setTemplate('layout/login');
        parent::dispatch($request, $response);
        
    }
   
}
