<?php
/**
 * SalesTool - OAuth2 Client Controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Application\Controller;

use Zend\View\Model\ViewModel;

class ClientController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $view = new ViewModel();
        return $view;
    }

    public function updateSecretAction(){

        try{

            $id = $this->params()->fromRoute("id",false);
            if(!$id){
                throw new \Exception("Invalid id");
            }

            $entity = $this->getEntityManager()->find('Model\Entity\OAuth2\Client', $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }

            $entity->updateSecret();
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            return $this->createJsonResponse(array(
                'success' => true,
                'secret' => $entity->getSecretPlain()
            ));

        }catch(\Exception $ex){
            return $this->createJsonResponse(array(
                'success' => false,
                'error' => $ex->getMessage()
            ));
        }

    }
}
