<?php

namespace Application\Controller;

use Commons\Util\DateTimeBr;
use Commons\Util\StringUtils;
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;

/**
 * Class AgreementController
 *
 * @author Renato Peterman <renato.pet@gmail.com>
 * @package Application\Controller
 */
class AgreementController extends AbstractApplicationController
{
    /**
     * Index action
     * @return ViewModel
     */
    public function indexAction()
    {
        $config = $this->getDefaultConfig();
        if($config->getAdminHasAgreedTerms())
        {
            return $this->redirect()->toRoute('home');
        }

        $message = null;
        try{
            if($this->getRequest()->isPost())
            {
                $agreed = $this->params()->fromPost('agreed', false);
                if(!$agreed)
                {
                    throw new \Exception("Por favor, é necessário aceitar os termos para continuar.");
                }

                $config->setAdminHasAgreedTermsDate(new \DateTime());
                $config->setAdminHasAgreedTerms(true);
                $this->getEntityManager()->merge($config);
                $this->getEntityManager()->flush();

                // Save and redirect
                return $this->redirect()->toRoute('home');
            }
        }catch(\Exception $ex){
            $message = $ex->getMessage();
        }

        $this->layout('layout/terms');
        $view = new ViewModel(array(
            'message' => $message
        ));
        return $view;
    }

    /**
     * Warning action
     *
     */
    public function warningAction()
    {
        if($this->getDefaultConfig()->getAdminHasAgreedTerms())
        {
            return $this->redirect()->toRoute('home');
        }
        $this->layout('layout/terms');
        return new ViewModel();
    }

}
