<?php

return array(
    'router' => array(
        'routes' => array(

            'home' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/',
                    'defaults' => array(
                        'controller' => 'Application\Controller\Index',
                        'action' => 'index',
                    ),
                ),
            ),
            
            'application' => array(
                'type' => 'Literal',
                'options' => array(
                    'route' => '/app',
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Index',
                        'action' => 'index',
                    ),
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type' => 'Segment',
                        'options' => array(
                            'route' => '/[:controller][/][:action][/][:id]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'id' => '(.*)',
                            ),
                            'defaults' => array(
                                'action' => 'index'
                            ),
                        ),
                    ),
                ),
            ),

            'customer' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/customer[/][:action][/][:type][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'type' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '(.*)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Customer',
                        'action' => 'index',
                    ),
                ),
            ),

            'seller-map' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/seller-map[/][:action][/][:type][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'type' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '(.*)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'SellerMap',
                        'action' => 'index',
                    ),
                ),
            ),

            'product-import' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/product[/][:action][/][:type][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'type' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '(.*)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Product',
                        'action' => 'index',
                    ),
                ),
            ),
            
            'warehouse-transaction-group' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/warehouse-transaction-group[/][:action][/:id]',
                    'constraints' => array(
                        'action'    => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id'        => '(.*)'
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'WarehouseTransactionGroup',
                        'action' => 'index',
                    ),
                ),
            ),

            'cashier' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/cashier[/][:action][/:id]',
                    'constraints' => array(
                        'action'    => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id'        => '(.*)'
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Cashier',
                        'action' => 'index',
                    ),
                ),
            ),

            'warehouse-manager' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/app/warehouse-manager[/][:action][/:id]',
                    'constraints' => array(
                        'action'    => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id'        => '(.*)'
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'WarehouseManager',
                        'action' => 'index',
                    ),
                ),
            ),
            
            'login' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/login[/][:action]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Login',
                        'action' => 'index',
                    ),
                ),
            ),

            'download' => array(
                'type' => 'segment',
                'options' => array(
                    'route' => '/download[/][:action]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'Application\Controller',
                        'controller' => 'Download',
                        'action' => 'index',
                    ),
                ),
            ),

        ),
    ),

    'service_manager' => array(
        'factories' => array(
            'Navigation' => 'Zend\Navigation\Service\DefaultNavigationFactory',
        ),
        'abstract_factories' => array(
            'Zend\Cache\Service\StorageCacheAbstractServiceFactory',
            'Zend\Log\LoggerAbstractServiceFactory',
        ),
        'aliases' => array(
            'translator' => 'MvcTranslator',
        ),
    ),

    'translator' => array(
        'locale' => 'en_US',
        'translation_file_patterns' => array(
            array(
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../language',
                'pattern' => '%s.mo',
            ),
        ),
    ),

    'controllers' => array(
        'invokables' => array(
            'Application\Controller\Index' => 'Application\Controller\IndexController',
            'Application\Controller\Login' => 'Application\Controller\LoginController',
            'Application\Controller\Unit' => 'Application\Controller\UnitController',
            'Application\Controller\Group' => 'Application\Controller\GroupController',
            'Application\Controller\User' => 'Application\Controller\UserController',
            'Application\Controller\Warehouse' => 'Application\Controller\WarehouseController',
            'Application\Controller\Product' => 'Application\Controller\ProductController',
            'Application\Controller\Customer' => 'Application\Controller\CustomerController',
            'Application\Controller\WarehouseTransaction' => 'Application\Controller\WarehouseTransactionController',
            'Application\Controller\Device' => 'Application\Controller\DeviceController',
            'Application\Controller\FinancialPending' => 'Application\Controller\FinancialPendingController',
            'Application\Controller\Order' => 'Application\Controller\OrderController',
            'Application\Controller\WarehouseTransactionGroup' => 'Application\Controller\WarehouseTransactionGroupController',
            'Application\Controller\Cashier' => 'Application\Controller\CashierController',
            'Application\Controller\WarehouseManager' => 'Application\Controller\WarehouseManagerController',
            'Application\Controller\Config' => 'Application\Controller\ConfigController',
            'Application\Controller\Company' => 'Application\Controller\CompanyController',
            'Application\Controller\RepresentedCompany' => 'Application\Controller\RepresentedCompanyController',
            'Application\Controller\PaymentMethod' => 'Application\Controller\PaymentMethodController',
            'Application\Controller\PaymentCondition' => 'Application\Controller\PaymentConditionController',
            'Application\Controller\Catalog' => 'Application\Controller\CatalogController',
            'Application\Controller\Client' => 'Application\Controller\ClientController',
            'Application\Controller\Download' => 'Application\Controller\DownloadController',
            'Application\Controller\SellerMap' => 'Application\Controller\SellerMapController',
            'Application\Controller\ServicesLocation' => 'Application\Controller\ServicesLocationController',
            'Application\Controller\Color' => 'Application\Controller\ColorController',
            'Application\Controller\Size' => 'Application\Controller\SizeController',
            'Application\Controller\Agreement' => 'Application\Controller\AgreementController'
        ),
    ),

    'view_manager' => array(
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => array(
            'layout/layout'             => __DIR__ . '/../view/layout/layout.phtml',
            'layout/login'              => __DIR__ . '/../view/layout/login.phtml',
            'layout/api-documentation'  => __DIR__ . '/../view/layout/api-documentation.phtml',
            'application/index/index'   => __DIR__ . '/../view/application/index/index.phtml',
            'error/404'                 => __DIR__ . '/../view/error/404.phtml',
            'error/index'               => __DIR__ . '/../view/error/index.phtml',
        ),
        'template_path_stack' => array(
            __DIR__ . '/../view',
        ),
        'strategies' => array(
            'ViewJsonStrategy',
        ),
    ),

    'console' => array(
        'router' => array(
            'routes' => array(
            ),
        ),
    ),

    // Doctrine
    'doctrine' => array(
        'driver' => array(
            'api_driver' => array(
                'class' => 'Doctrine\ORM\Mapping\Driver\AnnotationDriver',
                'cache' => 'array',
                'paths' => array(__DIR__ . '/../../Model/src/Model/Entity')
            ),
            'orm_default' => array(
                'drivers' => array(
                    'Model\Entity' => 'api_driver'
                ),
            ),
        ),
        'authentication' => array(
            'orm_default' => array(
                'object_manager' => 'Doctrine\ORM\EntityManager',
                'identity_class' => 'Model\Entity\User',
                'identity_property' => 'username',
                'credential_property' => 'password',
                'credential_callable' => 'Model\Entity\User::hashPassword',
            ),
        ),
    ),

    'navigation' => array(
         'default' => array(
             array(
                 'label' => 'Início',
                 'route' => 'home',
             ),
             array(
                 'label' => 'Cadastros',
                 'uri' => '#',
                 'pages' => array(
                     array(
                            'label' => 'Clientes',
                            'route'         => 'application/default',
                            'controller'    => 'customer',
                            'action'        => 'index'
                        ),
                     array(
                            'label' => 'Produtos',
                            'route'         => 'application/default',
                            'controller'    => 'product',
                            'action'        => 'index'
                        ),
                     array(
                            'label' => 'Unidade de Medida',
                            'route'         => 'application/default',
                            'controller'    => 'unit',
                            'action'        => 'index'
                        ),
                     array(
                            'label' => 'Grupos',
                            'route'         => 'application/default',
                            'controller'    => 'group',
                            'action'        => 'index'
                        )
                 ),
             ),
             array(
                 'label' => 'Estoque',
                 'uri' => '#',
                 'pages' => array(
                     array(
                            'label' => 'Estoques',
                            'route'         => 'application/default',
                            'controller'    => 'warehouse',
                            'action'        => 'index'
                        ),
                     array(
                            'label' => 'Movimentação',
                            'route'         => 'warehouse-transaction-group',
                            'action'        => 'index'
                        ),
                     array(
                            'label' => 'Transações',
                            'route'         => 'application/default',
                            'controller'    => 'warehouse-transaction',
                            'action'        => 'index'
                        )
                 ),
             ),
             array(
                'label'         => 'Pedidos',
                'route'         => 'application/default',
                'controller'    => 'order',
                'action'        => 'index'
             ),
         )
     ),
);
