<?php

namespace Application;

use Zend\Mvc\ModuleRouteListener;
use Zend\Mvc\MvcEvent;

class Module
{
    public function onBootstrap(MvcEvent $e)
    {
        $eventManager = $e->getApplication()->getEventManager();
        
        // Auto Update DB
        /*
        $entityManager = $e->getApplication()->getServiceManager()->get('doctrine.entitymanager.orm_default');
        $schemaTool = new \Doctrine\ORM\Tools\SchemaTool($entityManager);
        $classes = $entityManager->getMetadataFactory()->getAllMetadata();
        $schemaTool->updateSchema($classes);
        */
        // $schemaTool->createSchema($classes);
        
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);

        $e->getApplication()->getEventManager()->attach(
            MvcEvent::EVENT_ROUTE, function(MvcEvent $e) {

                $route_name = $e->getRouteMatch()->getMatchedRouteName();
                if($route_name == 'zf-apigility/documentation'){
                    $e->getViewModel()->setTemplate('layout/api-documentation');
                }
            }
        );

    }

    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }
    
    public function getServiceConfig() {
        return array(
            'factories' => array(
                'Zend\Authentication\AuthenticationService' => function($serviceManager) {
                    return $serviceManager->get('doctrine.authenticationservice.orm_default');
                }
            )
        );
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\ClassMapAutoloader' => array(
                __DIR__ . '/autoload_classmap.php',
            ),
        );
    }

    public function getViewHelperConfig() {
        return array(
            'factories' => array(
                'applicationConfig' => function($serviceManager) {
                    $helper = new \Application\Helper\ApplicationConfig($serviceManager);
                    return $helper;
                }
            )
        );
    }

}
