<?php
return array(
    'router' => array(
        'routes' => array(
            'api-client.rest.doctrine.cashier' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/cashier[/:cashier_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Cashier\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.cashier-expense' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/cashier-expense[/:cashier_expense_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\CashierExpense\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.catalog' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/catalog[/:catalog_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Catalog\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.catalog-image' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/catalog-image[/:catalog_image_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\CatalogImage\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.color' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/color[/:color_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Color\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.company' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/company[/:company_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Company\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.config' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/config[/:config_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Config\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.customer' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/customer[/:customer_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Customer\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.device' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/device[/:device_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Device\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.financial-pending' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/financial-pending[/:financial_pending_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\FinancialPending\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.grid-color' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/grid-color[/:grid_color_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\GridColor\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.grid-color-item' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/grid-color-item[/:grid_color_item_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\GridColorItem\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.grid-size' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/grid-size[/:grid_size_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\GridSize\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.grid-size-item' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/grid-size-item[/:grid_size_item_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\GridSizeItem\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.group' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/group[/:group_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Group\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.log' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/log[/:log_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Log\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.access-token' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/access-token[/:access_token_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\AccessToken\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.authorization-code' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/authorization-code[/:authorization_code_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\AuthorizationCode\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.client' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/client[/:client_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Client\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.jti' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/jti[/:jti_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Jti\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.jwt' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/jwt[/:jwt_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Jwt\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.public-key' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public-key[/:public_key_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\PublicKey\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.refresh-token' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/refresh-token[/:refresh_token_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\RefreshToken\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.scope' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/scope[/:scope_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Scope\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order[/:order_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Order\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order-classification' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order-classification[/:order_classification_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\OrderClassification\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order-customer-type' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order-customer-type[/:order_customer_type_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\OrderCustomerType\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order-product' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order-product[/:order_product_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\OrderProduct\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order-product-variant' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order-product-variant[/:order_product_variant_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\OrderProductVariant\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.order-type' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/order-type[/:order_type_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\OrderType\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.payment-condition' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/payment-condition[/:payment_condition_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\PaymentCondition\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.payment-method' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/payment-method[/:payment_method_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\PaymentMethod\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.price-list' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/price-list[/:price_list_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\PriceList\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.price-list-product' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/price-list-product[/:price_list_product_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\PriceListProduct\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product[/:product_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Product\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-barcode' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-barcode[/:product_barcode_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductBarcode\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-color' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-color[/:product_color_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductColor\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-image' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-image[/:product_image_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductImage\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-size' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-size[/:product_size_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductSize\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-warehouse' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-warehouse[/:product_warehouse_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductWarehouse\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.product-warehouse-variant' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/product-warehouse-variant[/:product_warehouse_variant_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\ProductWarehouseVariant\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.represented-company' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/represented-company[/:represented_company_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\RepresentedCompany\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.size' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/size[/:size_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Size\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.unit' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/unit[/:unit_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Unit\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user[/:user_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\User\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user-access-token' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user-access-token[/:user_access_token_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\UserAccessToken\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user-customer' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user-customer[/:user_customer_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\UserCustomer\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user-location' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user-location[/:user_location_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\UserLocation\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user-price-list' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user-price-list[/:user_price_list_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\UserPriceList\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.user-represented-company' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/user-represented-company[/:user_represented_company_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\UserRepresentedCompany\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.warehouse' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/warehouse[/:warehouse_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\Warehouse\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.warehouse-transaction' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/warehouse-transaction[/:warehouse_transaction_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\WarehouseTransaction\\Controller',
                    ),
                ),
            ),
            'api-client.rest.doctrine.warehouse-transaction-group' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/warehouse-transaction-group[/:warehouse_transaction_group_id]',
                    'defaults' => array(
                        'controller' => 'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\Controller',
                    ),
                ),
            ),
        ),
    ),
    'zf-versioning' => array(
        'uri' => array(
            0 => 'api-client.rest.doctrine.cashier',
            1 => 'api-client.rest.doctrine.cashier-expense',
            2 => 'api-client.rest.doctrine.catalog',
            3 => 'api-client.rest.doctrine.catalog-image',
            4 => 'api-client.rest.doctrine.color',
            5 => 'api-client.rest.doctrine.company',
            6 => 'api-client.rest.doctrine.config',
            7 => 'api-client.rest.doctrine.customer',
            8 => 'api-client.rest.doctrine.device',
            9 => 'api-client.rest.doctrine.financial-pending',
            10 => 'api-client.rest.doctrine.grid-color',
            11 => 'api-client.rest.doctrine.grid-color-item',
            12 => 'api-client.rest.doctrine.grid-size',
            13 => 'api-client.rest.doctrine.grid-size-item',
            14 => 'api-client.rest.doctrine.group',
            15 => 'api-client.rest.doctrine.log',
            16 => 'api-client.rest.doctrine.access-token',
            17 => 'api-client.rest.doctrine.authorization-code',
            18 => 'api-client.rest.doctrine.client',
            19 => 'api-client.rest.doctrine.jti',
            20 => 'api-client.rest.doctrine.jwt',
            21 => 'api-client.rest.doctrine.public-key',
            22 => 'api-client.rest.doctrine.refresh-token',
            23 => 'api-client.rest.doctrine.scope',
            24 => 'api-client.rest.doctrine.order',
            25 => 'api-client.rest.doctrine.order-classification',
            26 => 'api-client.rest.doctrine.order-customer-type',
            27 => 'api-client.rest.doctrine.order-product',
            28 => 'api-client.rest.doctrine.order-product-variant',
            29 => 'api-client.rest.doctrine.order-type',
            30 => 'api-client.rest.doctrine.payment-condition',
            31 => 'api-client.rest.doctrine.payment-method',
            32 => 'api-client.rest.doctrine.price-list',
            33 => 'api-client.rest.doctrine.price-list-product',
            34 => 'api-client.rest.doctrine.product',
            35 => 'api-client.rest.doctrine.product-barcode',
            36 => 'api-client.rest.doctrine.product-color',
            37 => 'api-client.rest.doctrine.product-image',
            38 => 'api-client.rest.doctrine.product-size',
            39 => 'api-client.rest.doctrine.product-warehouse',
            40 => 'api-client.rest.doctrine.product-warehouse-variant',
            41 => 'api-client.rest.doctrine.represented-company',
            42 => 'api-client.rest.doctrine.size',
            43 => 'api-client.rest.doctrine.unit',
            44 => 'api-client.rest.doctrine.user',
            45 => 'api-client.rest.doctrine.user-access-token',
            46 => 'api-client.rest.doctrine.user-customer',
            47 => 'api-client.rest.doctrine.user-location',
            48 => 'api-client.rest.doctrine.user-price-list',
            49 => 'api-client.rest.doctrine.user-represented-company',
            50 => 'api-client.rest.doctrine.warehouse',
            51 => 'api-client.rest.doctrine.warehouse-transaction',
            52 => 'api-client.rest.doctrine.warehouse-transaction-group',
        ),
    ),
    'zf-rest' => array(
        'APIClient\\V1\\Rest\\Cashier\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Cashier\\CashierResource',
            'route_name' => 'api-client.rest.doctrine.cashier',
            'route_identifier_name' => 'cashier_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'cashier',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Cashier',
            'collection_class' => 'APIClient\\V1\\Rest\\Cashier\\CashierCollection',
            'service_name' => 'Cashier',
        ),
        'APIClient\\V1\\Rest\\CashierExpense\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseResource',
            'route_name' => 'api-client.rest.doctrine.cashier-expense',
            'route_identifier_name' => 'cashier_expense_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'cashier_expense',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\CashierExpense',
            'collection_class' => 'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseCollection',
            'service_name' => 'CashierExpense',
        ),
        'APIClient\\V1\\Rest\\Catalog\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Catalog\\CatalogResource',
            'route_name' => 'api-client.rest.doctrine.catalog',
            'route_identifier_name' => 'catalog_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'catalog',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Catalog',
            'collection_class' => 'APIClient\\V1\\Rest\\Catalog\\CatalogCollection',
            'service_name' => 'Catalog',
        ),
        'APIClient\\V1\\Rest\\CatalogImage\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageResource',
            'route_name' => 'api-client.rest.doctrine.catalog-image',
            'route_identifier_name' => 'catalog_image_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'catalog_image',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\CatalogImage',
            'collection_class' => 'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageCollection',
            'service_name' => 'CatalogImage',
        ),
        'APIClient\\V1\\Rest\\Color\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Color\\ColorResource',
            'route_name' => 'api-client.rest.doctrine.color',
            'route_identifier_name' => 'color_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'color',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Color',
            'collection_class' => 'APIClient\\V1\\Rest\\Color\\ColorCollection',
            'service_name' => 'Color',
        ),
        'APIClient\\V1\\Rest\\Company\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Company\\CompanyResource',
            'route_name' => 'api-client.rest.doctrine.company',
            'route_identifier_name' => 'company_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'company',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Company',
            'collection_class' => 'APIClient\\V1\\Rest\\Company\\CompanyCollection',
            'service_name' => 'Company',
        ),
        'APIClient\\V1\\Rest\\Config\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Config\\ConfigResource',
            'route_name' => 'api-client.rest.doctrine.config',
            'route_identifier_name' => 'config_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'config',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Config',
            'collection_class' => 'APIClient\\V1\\Rest\\Config\\ConfigCollection',
            'service_name' => 'Config',
        ),
        'APIClient\\V1\\Rest\\Customer\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Customer\\CustomerResource',
            'route_name' => 'api-client.rest.doctrine.customer',
            'route_identifier_name' => 'customer_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'customer',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Customer',
            'collection_class' => 'APIClient\\V1\\Rest\\Customer\\CustomerCollection',
            'service_name' => 'Customer',
        ),
        'APIClient\\V1\\Rest\\Device\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Device\\DeviceResource',
            'route_name' => 'api-client.rest.doctrine.device',
            'route_identifier_name' => 'device_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'device',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Device',
            'collection_class' => 'APIClient\\V1\\Rest\\Device\\DeviceCollection',
            'service_name' => 'Device',
        ),
        'APIClient\\V1\\Rest\\FinancialPending\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingResource',
            'route_name' => 'api-client.rest.doctrine.financial-pending',
            'route_identifier_name' => 'financial_pending_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'financial_pending',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\FinancialPending',
            'collection_class' => 'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingCollection',
            'service_name' => 'FinancialPending',
        ),
        'APIClient\\V1\\Rest\\GridColor\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\GridColor\\GridColorResource',
            'route_name' => 'api-client.rest.doctrine.grid-color',
            'route_identifier_name' => 'grid_color_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'grid_color',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\GridColor',
            'collection_class' => 'APIClient\\V1\\Rest\\GridColor\\GridColorCollection',
            'service_name' => 'GridColor',
        ),
        'APIClient\\V1\\Rest\\GridColorItem\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemResource',
            'route_name' => 'api-client.rest.doctrine.grid-color-item',
            'route_identifier_name' => 'grid_color_item_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'grid_color_item',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\GridColorItem',
            'collection_class' => 'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemCollection',
            'service_name' => 'GridColorItem',
        ),
        'APIClient\\V1\\Rest\\GridSize\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\GridSize\\GridSizeResource',
            'route_name' => 'api-client.rest.doctrine.grid-size',
            'route_identifier_name' => 'grid_size_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'grid_size',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\GridSize',
            'collection_class' => 'APIClient\\V1\\Rest\\GridSize\\GridSizeCollection',
            'service_name' => 'GridSize',
        ),
        'APIClient\\V1\\Rest\\GridSizeItem\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemResource',
            'route_name' => 'api-client.rest.doctrine.grid-size-item',
            'route_identifier_name' => 'grid_size_item_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'grid_size_item',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\GridSizeItem',
            'collection_class' => 'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemCollection',
            'service_name' => 'GridSizeItem',
        ),
        'APIClient\\V1\\Rest\\Group\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Group\\GroupResource',
            'route_name' => 'api-client.rest.doctrine.group',
            'route_identifier_name' => 'group_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'group',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Group',
            'collection_class' => 'APIClient\\V1\\Rest\\Group\\GroupCollection',
            'service_name' => 'Group',
        ),
        'APIClient\\V1\\Rest\\Log\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Log\\LogResource',
            'route_name' => 'api-client.rest.doctrine.log',
            'route_identifier_name' => 'log_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'log',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Log',
            'collection_class' => 'APIClient\\V1\\Rest\\Log\\LogCollection',
            'service_name' => 'Log',
        ),
        'APIClient\\V1\\Rest\\AccessToken\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\AccessToken\\AccessTokenResource',
            'route_name' => 'api-client.rest.doctrine.access-token',
            'route_identifier_name' => 'access_token_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'access_token',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\AccessToken',
            'collection_class' => 'APIClient\\V1\\Rest\\AccessToken\\AccessTokenCollection',
            'service_name' => 'AccessToken',
        ),
        'APIClient\\V1\\Rest\\AuthorizationCode\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeResource',
            'route_name' => 'api-client.rest.doctrine.authorization-code',
            'route_identifier_name' => 'authorization_code_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'authorization_code',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\AuthorizationCode',
            'collection_class' => 'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeCollection',
            'service_name' => 'AuthorizationCode',
        ),
        'APIClient\\V1\\Rest\\Client\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Client\\ClientResource',
            'route_name' => 'api-client.rest.doctrine.client',
            'route_identifier_name' => 'client_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'client',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\Client',
            'collection_class' => 'APIClient\\V1\\Rest\\Client\\ClientCollection',
            'service_name' => 'Client',
        ),
        'APIClient\\V1\\Rest\\Jti\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Jti\\JtiResource',
            'route_name' => 'api-client.rest.doctrine.jti',
            'route_identifier_name' => 'jti_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'jti',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\Jti',
            'collection_class' => 'APIClient\\V1\\Rest\\Jti\\JtiCollection',
            'service_name' => 'Jti',
        ),
        'APIClient\\V1\\Rest\\Jwt\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Jwt\\JwtResource',
            'route_name' => 'api-client.rest.doctrine.jwt',
            'route_identifier_name' => 'jwt_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'jwt',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\Jwt',
            'collection_class' => 'APIClient\\V1\\Rest\\Jwt\\JwtCollection',
            'service_name' => 'Jwt',
        ),
        'APIClient\\V1\\Rest\\PublicKey\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\PublicKey\\PublicKeyResource',
            'route_name' => 'api-client.rest.doctrine.public-key',
            'route_identifier_name' => 'public_key_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'public_key',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\PublicKey',
            'collection_class' => 'APIClient\\V1\\Rest\\PublicKey\\PublicKeyCollection',
            'service_name' => 'PublicKey',
        ),
        'APIClient\\V1\\Rest\\RefreshToken\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenResource',
            'route_name' => 'api-client.rest.doctrine.refresh-token',
            'route_identifier_name' => 'refresh_token_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'refresh_token',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\RefreshToken',
            'collection_class' => 'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenCollection',
            'service_name' => 'RefreshToken',
        ),
        'APIClient\\V1\\Rest\\Scope\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Scope\\ScopeResource',
            'route_name' => 'api-client.rest.doctrine.scope',
            'route_identifier_name' => 'scope_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'scope',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OAuth2\\Scope',
            'collection_class' => 'APIClient\\V1\\Rest\\Scope\\ScopeCollection',
            'service_name' => 'Scope',
        ),
        'APIClient\\V1\\Rest\\Order\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Order\\OrderResource',
            'route_name' => 'api-client.rest.doctrine.order',
            'route_identifier_name' => 'order_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Order',
            'collection_class' => 'APIClient\\V1\\Rest\\Order\\OrderCollection',
            'service_name' => 'Order',
        ),
        'APIClient\\V1\\Rest\\OrderClassification\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationResource',
            'route_name' => 'api-client.rest.doctrine.order-classification',
            'route_identifier_name' => 'order_classification_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order_classification',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OrderClassification',
            'collection_class' => 'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationCollection',
            'service_name' => 'OrderClassification',
        ),
        'APIClient\\V1\\Rest\\OrderCustomerType\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeResource',
            'route_name' => 'api-client.rest.doctrine.order-customer-type',
            'route_identifier_name' => 'order_customer_type_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order_customer_type',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OrderCustomerType',
            'collection_class' => 'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeCollection',
            'service_name' => 'OrderCustomerType',
        ),
        'APIClient\\V1\\Rest\\OrderProduct\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\OrderProduct\\OrderProductResource',
            'route_name' => 'api-client.rest.doctrine.order-product',
            'route_identifier_name' => 'order_product_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order_product',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OrderProduct',
            'collection_class' => 'APIClient\\V1\\Rest\\OrderProduct\\OrderProductCollection',
            'service_name' => 'OrderProduct',
        ),
        'APIClient\\V1\\Rest\\OrderProductVariant\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantResource',
            'route_name' => 'api-client.rest.doctrine.order-product-variant',
            'route_identifier_name' => 'order_product_variant_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order_product_variant',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OrderProductVariant',
            'collection_class' => 'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantCollection',
            'service_name' => 'OrderProductVariant',
        ),
        'APIClient\\V1\\Rest\\OrderType\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\OrderType\\OrderTypeResource',
            'route_name' => 'api-client.rest.doctrine.order-type',
            'route_identifier_name' => 'order_type_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'order_type',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\OrderType',
            'collection_class' => 'APIClient\\V1\\Rest\\OrderType\\OrderTypeCollection',
            'service_name' => 'OrderType',
        ),
        'APIClient\\V1\\Rest\\PaymentCondition\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionResource',
            'route_name' => 'api-client.rest.doctrine.payment-condition',
            'route_identifier_name' => 'payment_condition_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'payment_condition',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\PaymentCondition',
            'collection_class' => 'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionCollection',
            'service_name' => 'PaymentCondition',
        ),
        'APIClient\\V1\\Rest\\PaymentMethod\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodResource',
            'route_name' => 'api-client.rest.doctrine.payment-method',
            'route_identifier_name' => 'payment_method_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'payment_method',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\PaymentMethod',
            'collection_class' => 'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodCollection',
            'service_name' => 'PaymentMethod',
        ),
        'APIClient\\V1\\Rest\\PriceList\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\PriceList\\PriceListResource',
            'route_name' => 'api-client.rest.doctrine.price-list',
            'route_identifier_name' => 'price_list_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'price_list',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\PriceList',
            'collection_class' => 'APIClient\\V1\\Rest\\PriceList\\PriceListCollection',
            'service_name' => 'PriceList',
        ),
        'APIClient\\V1\\Rest\\PriceListProduct\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductResource',
            'route_name' => 'api-client.rest.doctrine.price-list-product',
            'route_identifier_name' => 'price_list_product_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'price_list_product',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\PriceListProduct',
            'collection_class' => 'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductCollection',
            'service_name' => 'PriceListProduct',
        ),
        'APIClient\\V1\\Rest\\Product\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Product\\ProductResource',
            'route_name' => 'api-client.rest.doctrine.product',
            'route_identifier_name' => 'product_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Product',
            'collection_class' => 'APIClient\\V1\\Rest\\Product\\ProductCollection',
            'service_name' => 'Product',
        ),
        'APIClient\\V1\\Rest\\ProductBarcode\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeResource',
            'route_name' => 'api-client.rest.doctrine.product-barcode',
            'route_identifier_name' => 'product_barcode_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_barcode',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductBarcode',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeCollection',
            'service_name' => 'ProductBarcode',
        ),
        'APIClient\\V1\\Rest\\ProductColor\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductColor\\ProductColorResource',
            'route_name' => 'api-client.rest.doctrine.product-color',
            'route_identifier_name' => 'product_color_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_color',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductColor',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductColor\\ProductColorCollection',
            'service_name' => 'ProductColor',
        ),
        'APIClient\\V1\\Rest\\ProductImage\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductImage\\ProductImageResource',
            'route_name' => 'api-client.rest.doctrine.product-image',
            'route_identifier_name' => 'product_image_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_image',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductImage',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductImage\\ProductImageCollection',
            'service_name' => 'ProductImage',
        ),
        'APIClient\\V1\\Rest\\ProductSize\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductSize\\ProductSizeResource',
            'route_name' => 'api-client.rest.doctrine.product-size',
            'route_identifier_name' => 'product_size_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_size',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductSize',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductSize\\ProductSizeCollection',
            'service_name' => 'ProductSize',
        ),
        'APIClient\\V1\\Rest\\ProductWarehouse\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseResource',
            'route_name' => 'api-client.rest.doctrine.product-warehouse',
            'route_identifier_name' => 'product_warehouse_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_warehouse',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductWarehouse',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseCollection',
            'service_name' => 'ProductWarehouse',
        ),
        'APIClient\\V1\\Rest\\ProductWarehouseVariant\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantResource',
            'route_name' => 'api-client.rest.doctrine.product-warehouse-variant',
            'route_identifier_name' => 'product_warehouse_variant_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'product_warehouse_variant',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\ProductWarehouseVariant',
            'collection_class' => 'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantCollection',
            'service_name' => 'ProductWarehouseVariant',
        ),
        'APIClient\\V1\\Rest\\RepresentedCompany\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyResource',
            'route_name' => 'api-client.rest.doctrine.represented-company',
            'route_identifier_name' => 'represented_company_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'represented_company',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\RepresentedCompany',
            'collection_class' => 'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyCollection',
            'service_name' => 'RepresentedCompany',
        ),
        'APIClient\\V1\\Rest\\Size\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Size\\SizeResource',
            'route_name' => 'api-client.rest.doctrine.size',
            'route_identifier_name' => 'size_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'size',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Size',
            'collection_class' => 'APIClient\\V1\\Rest\\Size\\SizeCollection',
            'service_name' => 'Size',
        ),
        'APIClient\\V1\\Rest\\Unit\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Unit\\UnitResource',
            'route_name' => 'api-client.rest.doctrine.unit',
            'route_identifier_name' => 'unit_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'unit',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Unit',
            'collection_class' => 'APIClient\\V1\\Rest\\Unit\\UnitCollection',
            'service_name' => 'Unit',
        ),
        'APIClient\\V1\\Rest\\User\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\User\\UserResource',
            'route_name' => 'api-client.rest.doctrine.user',
            'route_identifier_name' => 'user_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\User',
            'collection_class' => 'APIClient\\V1\\Rest\\User\\UserCollection',
            'service_name' => 'User',
        ),
        'APIClient\\V1\\Rest\\UserAccessToken\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenResource',
            'route_name' => 'api-client.rest.doctrine.user-access-token',
            'route_identifier_name' => 'user_access_token_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user_access_token',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\UserAccessToken',
            'collection_class' => 'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenCollection',
            'service_name' => 'UserAccessToken',
        ),
        'APIClient\\V1\\Rest\\UserCustomer\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerResource',
            'route_name' => 'api-client.rest.doctrine.user-customer',
            'route_identifier_name' => 'user_customer_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user_customer',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\UserCustomer',
            'collection_class' => 'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerCollection',
            'service_name' => 'UserCustomer',
        ),
        'APIClient\\V1\\Rest\\UserLocation\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\UserLocation\\UserLocationResource',
            'route_name' => 'api-client.rest.doctrine.user-location',
            'route_identifier_name' => 'user_location_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user_location',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\UserLocation',
            'collection_class' => 'APIClient\\V1\\Rest\\UserLocation\\UserLocationCollection',
            'service_name' => 'UserLocation',
        ),
        'APIClient\\V1\\Rest\\UserPriceList\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListResource',
            'route_name' => 'api-client.rest.doctrine.user-price-list',
            'route_identifier_name' => 'user_price_list_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user_price_list',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\UserPriceList',
            'collection_class' => 'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListCollection',
            'service_name' => 'UserPriceList',
        ),
        'APIClient\\V1\\Rest\\UserRepresentedCompany\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyResource',
            'route_name' => 'api-client.rest.doctrine.user-represented-company',
            'route_identifier_name' => 'user_represented_company_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'user_represented_company',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\UserRepresentedCompany',
            'collection_class' => 'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyCollection',
            'service_name' => 'UserRepresentedCompany',
        ),
        'APIClient\\V1\\Rest\\Warehouse\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\Warehouse\\WarehouseResource',
            'route_name' => 'api-client.rest.doctrine.warehouse',
            'route_identifier_name' => 'warehouse_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'warehouse',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\Warehouse',
            'collection_class' => 'APIClient\\V1\\Rest\\Warehouse\\WarehouseCollection',
            'service_name' => 'Warehouse',
        ),
        'APIClient\\V1\\Rest\\WarehouseTransaction\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionResource',
            'route_name' => 'api-client.rest.doctrine.warehouse-transaction',
            'route_identifier_name' => 'warehouse_transaction_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'warehouse_transaction',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\WarehouseTransaction',
            'collection_class' => 'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionCollection',
            'service_name' => 'WarehouseTransaction',
        ),
        'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\Controller' => array(
            'listener' => 'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupResource',
            'route_name' => 'api-client.rest.doctrine.warehouse-transaction-group',
            'route_identifier_name' => 'warehouse_transaction_group_id',
            'entity_identifier_name' => 'id',
            'collection_name' => 'warehouse_transaction_group',
            'entity_http_methods' => array(
                0 => 'GET',
                1 => 'PATCH',
                2 => 'PUT',
                3 => 'DELETE',
            ),
            'collection_http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => 'limit',
            'entity_class' => 'Model\\Entity\\WarehouseTransactionGroup',
            'collection_class' => 'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupCollection',
            'service_name' => 'WarehouseTransactionGroup',
        ),
    ),
    'zf-content-negotiation' => array(
        'controllers' => array(
            'APIClient\\V1\\Rest\\Cashier\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\CashierExpense\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Catalog\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\CatalogImage\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Color\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Company\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Config\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Customer\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Device\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\FinancialPending\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\GridColor\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\GridColorItem\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\GridSize\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\GridSizeItem\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Group\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Log\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\AccessToken\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\AuthorizationCode\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Client\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Jti\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Jwt\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\PublicKey\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\RefreshToken\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Scope\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Order\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\OrderClassification\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\OrderCustomerType\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\OrderProduct\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\OrderProductVariant\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\OrderType\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\PaymentCondition\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\PaymentMethod\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\PriceList\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\PriceListProduct\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Product\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductBarcode\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductColor\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductImage\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductSize\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductWarehouse\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\ProductWarehouseVariant\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\RepresentedCompany\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Size\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Unit\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\User\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\UserAccessToken\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\UserCustomer\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\UserLocation\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\UserPriceList\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\UserRepresentedCompany\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\Warehouse\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\WarehouseTransaction\\Controller' => 'HalJson',
            'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\Controller' => 'HalJson',
        ),
        'accept-whitelist' => array(
            'APIClient\\V1\\Rest\\Cashier\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\CashierExpense\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Catalog\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\CatalogImage\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Color\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Company\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Config\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Customer\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Device\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\FinancialPending\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridColor\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridColorItem\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridSize\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridSizeItem\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Group\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Log\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\AccessToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\AuthorizationCode\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Client\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Jti\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Jwt\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PublicKey\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\RefreshToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Scope\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Order\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderClassification\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderCustomerType\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderProduct\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderProductVariant\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderType\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PaymentCondition\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PaymentMethod\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PriceList\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PriceListProduct\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Product\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductBarcode\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductColor\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductImage\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductSize\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouse\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouseVariant\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\RepresentedCompany\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Size\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Unit\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\User\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserAccessToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserCustomer\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserLocation\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserPriceList\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserRepresentedCompany\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Warehouse\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransaction\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/hal+json',
                2 => 'application/json',
            ),
        ),
        'content-type-whitelist' => array(
            'APIClient\\V1\\Rest\\Cashier\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\CashierExpense\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Catalog\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\CatalogImage\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Color\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Company\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Config\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Customer\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Device\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\FinancialPending\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridColor\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridColorItem\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridSize\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\GridSizeItem\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Group\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Log\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\AccessToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\AuthorizationCode\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Client\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Jti\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Jwt\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PublicKey\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\RefreshToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Scope\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Order\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderClassification\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderCustomerType\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderProduct\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderProductVariant\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\OrderType\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PaymentCondition\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PaymentMethod\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PriceList\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\PriceListProduct\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Product\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductBarcode\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductColor\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductImage\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductSize\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouse\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouseVariant\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\RepresentedCompany\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Size\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Unit\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\User\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserAccessToken\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserCustomer\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserLocation\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserPriceList\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\UserRepresentedCompany\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\Warehouse\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransaction\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\Controller' => array(
                0 => 'application/vnd.api-client.v1+json',
                1 => 'application/json',
            ),
        ),
    ),
    'zf-hal' => array(
        'metadata_map' => array(
            'Model\\Entity\\Cashier' => array(
                'route_identifier_name' => 'cashier_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.cashier',
                'hydrator' => 'APIClient\\V1\\Rest\\Cashier\\CashierHydrator',
            ),
            'APIClient\\V1\\Rest\\Cashier\\CashierCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.cashier',
                'is_collection' => true,
            ),
            'Model\\Entity\\CashierExpense' => array(
                'route_identifier_name' => 'cashier_expense_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.cashier-expense',
                'hydrator' => 'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseHydrator',
            ),
            'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.cashier-expense',
                'is_collection' => true,
            ),
            'Model\\Entity\\Catalog' => array(
                'route_identifier_name' => 'catalog_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.catalog',
                'hydrator' => 'APIClient\\V1\\Rest\\Catalog\\CatalogHydrator',
            ),
            'APIClient\\V1\\Rest\\Catalog\\CatalogCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.catalog',
                'is_collection' => true,
            ),
            'Model\\Entity\\CatalogImage' => array(
                'route_identifier_name' => 'catalog_image_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.catalog-image',
                'hydrator' => 'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageHydrator',
            ),
            'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.catalog-image',
                'is_collection' => true,
            ),
            'Model\\Entity\\Color' => array(
                'route_identifier_name' => 'color_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.color',
                'hydrator' => 'APIClient\\V1\\Rest\\Color\\ColorHydrator',
            ),
            'APIClient\\V1\\Rest\\Color\\ColorCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.color',
                'is_collection' => true,
            ),
            'Model\\Entity\\Company' => array(
                'route_identifier_name' => 'company_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.company',
                'hydrator' => 'APIClient\\V1\\Rest\\Company\\CompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\Company\\CompanyCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.company',
                'is_collection' => true,
            ),
            'Model\\Entity\\Config' => array(
                'route_identifier_name' => 'config_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.config',
                'hydrator' => 'APIClient\\V1\\Rest\\Config\\ConfigHydrator',
            ),
            'APIClient\\V1\\Rest\\Config\\ConfigCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.config',
                'is_collection' => true,
            ),
            'Model\\Entity\\Customer' => array(
                'route_identifier_name' => 'customer_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.customer',
                'hydrator' => 'APIClient\\V1\\Rest\\Customer\\CustomerHydrator',
            ),
            'APIClient\\V1\\Rest\\Customer\\CustomerCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.customer',
                'is_collection' => true,
            ),
            'Model\\Entity\\Device' => array(
                'route_identifier_name' => 'device_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.device',
                'hydrator' => 'APIClient\\V1\\Rest\\Device\\DeviceHydrator',
            ),
            'APIClient\\V1\\Rest\\Device\\DeviceCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.device',
                'is_collection' => true,
            ),
            'Model\\Entity\\FinancialPending' => array(
                'route_identifier_name' => 'financial_pending_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.financial-pending',
                'hydrator' => 'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingHydrator',
            ),
            'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.financial-pending',
                'is_collection' => true,
            ),
            'Model\\Entity\\GridColor' => array(
                'route_identifier_name' => 'grid_color_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-color',
                'hydrator' => 'APIClient\\V1\\Rest\\GridColor\\GridColorHydrator',
            ),
            'APIClient\\V1\\Rest\\GridColor\\GridColorCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-color',
                'is_collection' => true,
            ),
            'Model\\Entity\\GridColorItem' => array(
                'route_identifier_name' => 'grid_color_item_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-color-item',
                'hydrator' => 'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemHydrator',
            ),
            'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-color-item',
                'is_collection' => true,
            ),
            'Model\\Entity\\GridSize' => array(
                'route_identifier_name' => 'grid_size_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-size',
                'hydrator' => 'APIClient\\V1\\Rest\\GridSize\\GridSizeHydrator',
            ),
            'APIClient\\V1\\Rest\\GridSize\\GridSizeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-size',
                'is_collection' => true,
            ),
            'Model\\Entity\\GridSizeItem' => array(
                'route_identifier_name' => 'grid_size_item_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-size-item',
                'hydrator' => 'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemHydrator',
            ),
            'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.grid-size-item',
                'is_collection' => true,
            ),
            'Model\\Entity\\Group' => array(
                'route_identifier_name' => 'group_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.group',
                'hydrator' => 'APIClient\\V1\\Rest\\Group\\GroupHydrator',
            ),
            'APIClient\\V1\\Rest\\Group\\GroupCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.group',
                'is_collection' => true,
            ),
            'Model\\Entity\\Log' => array(
                'route_identifier_name' => 'log_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.log',
                'hydrator' => 'APIClient\\V1\\Rest\\Log\\LogHydrator',
            ),
            'APIClient\\V1\\Rest\\Log\\LogCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.log',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\AccessToken' => array(
                'route_identifier_name' => 'access_token_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.access-token',
                'hydrator' => 'APIClient\\V1\\Rest\\AccessToken\\AccessTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\AccessToken\\AccessTokenCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.access-token',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\AuthorizationCode' => array(
                'route_identifier_name' => 'authorization_code_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.authorization-code',
                'hydrator' => 'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeHydrator',
            ),
            'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.authorization-code',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\Client' => array(
                'route_identifier_name' => 'client_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.client',
                'hydrator' => 'APIClient\\V1\\Rest\\Client\\ClientHydrator',
            ),
            'APIClient\\V1\\Rest\\Client\\ClientCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.client',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\Jti' => array(
                'route_identifier_name' => 'jti_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.jti',
                'hydrator' => 'APIClient\\V1\\Rest\\Jti\\JtiHydrator',
            ),
            'APIClient\\V1\\Rest\\Jti\\JtiCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.jti',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\Jwt' => array(
                'route_identifier_name' => 'jwt_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.jwt',
                'hydrator' => 'APIClient\\V1\\Rest\\Jwt\\JwtHydrator',
            ),
            'APIClient\\V1\\Rest\\Jwt\\JwtCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.jwt',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\PublicKey' => array(
                'route_identifier_name' => 'public_key_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.public-key',
                'hydrator' => 'APIClient\\V1\\Rest\\PublicKey\\PublicKeyHydrator',
            ),
            'APIClient\\V1\\Rest\\PublicKey\\PublicKeyCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.public-key',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\RefreshToken' => array(
                'route_identifier_name' => 'refresh_token_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.refresh-token',
                'hydrator' => 'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.refresh-token',
                'is_collection' => true,
            ),
            'Model\\Entity\\OAuth2\\Scope' => array(
                'route_identifier_name' => 'scope_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.scope',
                'hydrator' => 'APIClient\\V1\\Rest\\Scope\\ScopeHydrator',
            ),
            'APIClient\\V1\\Rest\\Scope\\ScopeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.scope',
                'is_collection' => true,
            ),
            'Model\\Entity\\Order' => array(
                'route_identifier_name' => 'order_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order',
                'hydrator' => 'APIClient\\V1\\Rest\\Order\\OrderHydrator',
            ),
            'APIClient\\V1\\Rest\\Order\\OrderCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order',
                'is_collection' => true,
            ),
            'Model\\Entity\\OrderClassification' => array(
                'route_identifier_name' => 'order_classification_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-classification',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-classification',
                'is_collection' => true,
            ),
            'Model\\Entity\\OrderCustomerType' => array(
                'route_identifier_name' => 'order_customer_type_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-customer-type',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-customer-type',
                'is_collection' => true,
            ),
            'Model\\Entity\\OrderProduct' => array(
                'route_identifier_name' => 'order_product_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-product',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderProduct\\OrderProductHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderProduct\\OrderProductCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-product',
                'is_collection' => true,
            ),
            'Model\\Entity\\OrderProductVariant' => array(
                'route_identifier_name' => 'order_product_variant_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-product-variant',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-product-variant',
                'is_collection' => true,
            ),
            'Model\\Entity\\OrderType' => array(
                'route_identifier_name' => 'order_type_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-type',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderType\\OrderTypeHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderType\\OrderTypeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.order-type',
                'is_collection' => true,
            ),
            'Model\\Entity\\PaymentCondition' => array(
                'route_identifier_name' => 'payment_condition_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.payment-condition',
                'hydrator' => 'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionHydrator',
            ),
            'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.payment-condition',
                'is_collection' => true,
            ),
            'Model\\Entity\\PaymentMethod' => array(
                'route_identifier_name' => 'payment_method_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.payment-method',
                'hydrator' => 'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodHydrator',
            ),
            'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.payment-method',
                'is_collection' => true,
            ),
            'Model\\Entity\\PriceList' => array(
                'route_identifier_name' => 'price_list_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.price-list',
                'hydrator' => 'APIClient\\V1\\Rest\\PriceList\\PriceListHydrator',
            ),
            'APIClient\\V1\\Rest\\PriceList\\PriceListCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.price-list',
                'is_collection' => true,
            ),
            'Model\\Entity\\PriceListProduct' => array(
                'route_identifier_name' => 'price_list_product_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.price-list-product',
                'hydrator' => 'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductHydrator',
            ),
            'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.price-list-product',
                'is_collection' => true,
            ),
            'Model\\Entity\\Product' => array(
                'route_identifier_name' => 'product_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product',
                'hydrator' => 'APIClient\\V1\\Rest\\Product\\ProductHydrator',
            ),
            'APIClient\\V1\\Rest\\Product\\ProductCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductBarcode' => array(
                'route_identifier_name' => 'product_barcode_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-barcode',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-barcode',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductColor' => array(
                'route_identifier_name' => 'product_color_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-color',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductColor\\ProductColorHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductColor\\ProductColorCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-color',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductImage' => array(
                'route_identifier_name' => 'product_image_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-image',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductImage\\ProductImageHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductImage\\ProductImageCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-image',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductSize' => array(
                'route_identifier_name' => 'product_size_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-size',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductSize\\ProductSizeHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductSize\\ProductSizeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-size',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductWarehouse' => array(
                'route_identifier_name' => 'product_warehouse_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-warehouse',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-warehouse',
                'is_collection' => true,
            ),
            'Model\\Entity\\ProductWarehouseVariant' => array(
                'route_identifier_name' => 'product_warehouse_variant_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-warehouse-variant',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.product-warehouse-variant',
                'is_collection' => true,
            ),
            'Model\\Entity\\RepresentedCompany' => array(
                'route_identifier_name' => 'represented_company_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.represented-company',
                'hydrator' => 'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.represented-company',
                'is_collection' => true,
            ),
            'Model\\Entity\\Size' => array(
                'route_identifier_name' => 'size_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.size',
                'hydrator' => 'APIClient\\V1\\Rest\\Size\\SizeHydrator',
            ),
            'APIClient\\V1\\Rest\\Size\\SizeCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.size',
                'is_collection' => true,
            ),
            'Model\\Entity\\Unit' => array(
                'route_identifier_name' => 'unit_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.unit',
                'hydrator' => 'APIClient\\V1\\Rest\\Unit\\UnitHydrator',
            ),
            'APIClient\\V1\\Rest\\Unit\\UnitCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.unit',
                'is_collection' => true,
            ),
            'Model\\Entity\\User' => array(
                'route_identifier_name' => 'user_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user',
                'hydrator' => 'APIClient\\V1\\Rest\\User\\UserHydrator',
            ),
            'APIClient\\V1\\Rest\\User\\UserCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user',
                'is_collection' => true,
            ),
            'Model\\Entity\\UserAccessToken' => array(
                'route_identifier_name' => 'user_access_token_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-access-token',
                'hydrator' => 'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-access-token',
                'is_collection' => true,
            ),
            'Model\\Entity\\UserCustomer' => array(
                'route_identifier_name' => 'user_customer_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-customer',
                'hydrator' => 'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerHydrator',
            ),
            'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-customer',
                'is_collection' => true,
            ),
            'Model\\Entity\\UserLocation' => array(
                'route_identifier_name' => 'user_location_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-location',
                'hydrator' => 'APIClient\\V1\\Rest\\UserLocation\\UserLocationHydrator',
            ),
            'APIClient\\V1\\Rest\\UserLocation\\UserLocationCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-location',
                'is_collection' => true,
            ),
            'Model\\Entity\\UserPriceList' => array(
                'route_identifier_name' => 'user_price_list_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-price-list',
                'hydrator' => 'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListHydrator',
            ),
            'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-price-list',
                'is_collection' => true,
            ),
            'Model\\Entity\\UserRepresentedCompany' => array(
                'route_identifier_name' => 'user_represented_company_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-represented-company',
                'hydrator' => 'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.user-represented-company',
                'is_collection' => true,
            ),
            'Model\\Entity\\Warehouse' => array(
                'route_identifier_name' => 'warehouse_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse',
                'hydrator' => 'APIClient\\V1\\Rest\\Warehouse\\WarehouseHydrator',
            ),
            'APIClient\\V1\\Rest\\Warehouse\\WarehouseCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse',
                'is_collection' => true,
            ),
            'Model\\Entity\\WarehouseTransaction' => array(
                'route_identifier_name' => 'warehouse_transaction_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse-transaction',
                'hydrator' => 'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionHydrator',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse-transaction',
                'is_collection' => true,
            ),
            'Model\\Entity\\WarehouseTransactionGroup' => array(
                'route_identifier_name' => 'warehouse_transaction_group_id',
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse-transaction-group',
                'hydrator' => 'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupHydrator',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'api-client.rest.doctrine.warehouse-transaction-group',
                'is_collection' => true,
            ),
        ),
    ),
    'zf-apigility' => array(
        'doctrine-connected' => array(
            'APIClient\\V1\\Rest\\Cashier\\CashierResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Cashier\\CashierHydrator',
            ),
            'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseHydrator',
            ),
            'APIClient\\V1\\Rest\\Catalog\\CatalogResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Catalog\\CatalogHydrator',
            ),
            'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageHydrator',
            ),
            'APIClient\\V1\\Rest\\Color\\ColorResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Color\\ColorHydrator',
            ),
            'APIClient\\V1\\Rest\\Company\\CompanyResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Company\\CompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\Config\\ConfigResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Config\\ConfigHydrator',
            ),
            'APIClient\\V1\\Rest\\Customer\\CustomerResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Customer\\CustomerHydrator',
            ),
            'APIClient\\V1\\Rest\\Device\\DeviceResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Device\\DeviceHydrator',
            ),
            'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingHydrator',
            ),
            'APIClient\\V1\\Rest\\GridColor\\GridColorResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\GridColor\\GridColorHydrator',
            ),
            'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemHydrator',
            ),
            'APIClient\\V1\\Rest\\GridSize\\GridSizeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\GridSize\\GridSizeHydrator',
            ),
            'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemHydrator',
            ),
            'APIClient\\V1\\Rest\\Group\\GroupResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Group\\GroupHydrator',
            ),
            'APIClient\\V1\\Rest\\Log\\LogResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Log\\LogHydrator',
            ),
            'APIClient\\V1\\Rest\\AccessToken\\AccessTokenResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\AccessToken\\AccessTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeHydrator',
            ),
            'APIClient\\V1\\Rest\\Client\\ClientResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Client\\ClientHydrator',
            ),
            'APIClient\\V1\\Rest\\Jti\\JtiResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Jti\\JtiHydrator',
            ),
            'APIClient\\V1\\Rest\\Jwt\\JwtResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Jwt\\JwtHydrator',
            ),
            'APIClient\\V1\\Rest\\PublicKey\\PublicKeyResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\PublicKey\\PublicKeyHydrator',
            ),
            'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\Scope\\ScopeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Scope\\ScopeHydrator',
            ),
            'APIClient\\V1\\Rest\\Order\\OrderResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Order\\OrderHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderProduct\\OrderProductResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderProduct\\OrderProductHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantHydrator',
            ),
            'APIClient\\V1\\Rest\\OrderType\\OrderTypeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\OrderType\\OrderTypeHydrator',
            ),
            'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionHydrator',
            ),
            'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodHydrator',
            ),
            'APIClient\\V1\\Rest\\PriceList\\PriceListResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\PriceList\\PriceListHydrator',
            ),
            'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductHydrator',
            ),
            'APIClient\\V1\\Rest\\Product\\ProductResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Product\\ProductHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductColor\\ProductColorResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductColor\\ProductColorHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductImage\\ProductImageResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductImage\\ProductImageHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductSize\\ProductSizeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductSize\\ProductSizeHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseHydrator',
            ),
            'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantHydrator',
            ),
            'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\Size\\SizeResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Size\\SizeHydrator',
            ),
            'APIClient\\V1\\Rest\\Unit\\UnitResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Unit\\UnitHydrator',
            ),
            'APIClient\\V1\\Rest\\User\\UserResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\User\\UserHydrator',
            ),
            'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenHydrator',
            ),
            'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerHydrator',
            ),
            'APIClient\\V1\\Rest\\UserLocation\\UserLocationResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\UserLocation\\UserLocationHydrator',
            ),
            'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListHydrator',
            ),
            'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyHydrator',
            ),
            'APIClient\\V1\\Rest\\Warehouse\\WarehouseResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\Warehouse\\WarehouseHydrator',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionHydrator',
            ),
            'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupResource' => array(
                'object_manager' => 'doctrine.entitymanager.orm_default',
                'hydrator' => 'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupHydrator',
            ),
        ),
    ),
    'doctrine-hydrator' => array(
        'APIClient\\V1\\Rest\\Cashier\\CashierHydrator' => array(
            'entity_class' => 'Model\\Entity\\Cashier',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\CashierExpense\\CashierExpenseHydrator' => array(
            'entity_class' => 'Model\\Entity\\CashierExpense',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Catalog\\CatalogHydrator' => array(
            'entity_class' => 'Model\\Entity\\Catalog',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\CatalogImage\\CatalogImageHydrator' => array(
            'entity_class' => 'Model\\Entity\\CatalogImage',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Color\\ColorHydrator' => array(
            'entity_class' => 'Model\\Entity\\Color',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Company\\CompanyHydrator' => array(
            'entity_class' => 'Model\\Entity\\Company',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Config\\ConfigHydrator' => array(
            'entity_class' => 'Model\\Entity\\Config',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Customer\\CustomerHydrator' => array(
            'entity_class' => 'Model\\Entity\\Customer',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Device\\DeviceHydrator' => array(
            'entity_class' => 'Model\\Entity\\Device',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\FinancialPending\\FinancialPendingHydrator' => array(
            'entity_class' => 'Model\\Entity\\FinancialPending',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\GridColor\\GridColorHydrator' => array(
            'entity_class' => 'Model\\Entity\\GridColor',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\GridColorItem\\GridColorItemHydrator' => array(
            'entity_class' => 'Model\\Entity\\GridColorItem',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\GridSize\\GridSizeHydrator' => array(
            'entity_class' => 'Model\\Entity\\GridSize',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\GridSizeItem\\GridSizeItemHydrator' => array(
            'entity_class' => 'Model\\Entity\\GridSizeItem',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Group\\GroupHydrator' => array(
            'entity_class' => 'Model\\Entity\\Group',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Log\\LogHydrator' => array(
            'entity_class' => 'Model\\Entity\\Log',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\AccessToken\\AccessTokenHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\AccessToken',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\AuthorizationCode\\AuthorizationCodeHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\AuthorizationCode',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Client\\ClientHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\Client',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Jti\\JtiHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\Jti',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Jwt\\JwtHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\Jwt',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\PublicKey\\PublicKeyHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\PublicKey',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\RefreshToken\\RefreshTokenHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\RefreshToken',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Scope\\ScopeHydrator' => array(
            'entity_class' => 'Model\\Entity\\OAuth2\\Scope',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Order\\OrderHydrator' => array(
            'entity_class' => 'Model\\Entity\\Order',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\OrderClassification\\OrderClassificationHydrator' => array(
            'entity_class' => 'Model\\Entity\\OrderClassification',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\OrderCustomerType\\OrderCustomerTypeHydrator' => array(
            'entity_class' => 'Model\\Entity\\OrderCustomerType',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\OrderProduct\\OrderProductHydrator' => array(
            'entity_class' => 'Model\\Entity\\OrderProduct',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\OrderProductVariant\\OrderProductVariantHydrator' => array(
            'entity_class' => 'Model\\Entity\\OrderProductVariant',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\OrderType\\OrderTypeHydrator' => array(
            'entity_class' => 'Model\\Entity\\OrderType',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\PaymentCondition\\PaymentConditionHydrator' => array(
            'entity_class' => 'Model\\Entity\\PaymentCondition',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\PaymentMethod\\PaymentMethodHydrator' => array(
            'entity_class' => 'Model\\Entity\\PaymentMethod',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\PriceList\\PriceListHydrator' => array(
            'entity_class' => 'Model\\Entity\\PriceList',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\PriceListProduct\\PriceListProductHydrator' => array(
            'entity_class' => 'Model\\Entity\\PriceListProduct',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Product\\ProductHydrator' => array(
            'entity_class' => 'Model\\Entity\\Product',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductBarcode\\ProductBarcodeHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductBarcode',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductColor\\ProductColorHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductColor',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductImage\\ProductImageHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductImage',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductSize\\ProductSizeHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductSize',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductWarehouse\\ProductWarehouseHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductWarehouse',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\ProductWarehouseVariant\\ProductWarehouseVariantHydrator' => array(
            'entity_class' => 'Model\\Entity\\ProductWarehouseVariant',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\RepresentedCompany\\RepresentedCompanyHydrator' => array(
            'entity_class' => 'Model\\Entity\\RepresentedCompany',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Size\\SizeHydrator' => array(
            'entity_class' => 'Model\\Entity\\Size',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Unit\\UnitHydrator' => array(
            'entity_class' => 'Model\\Entity\\Unit',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\User\\UserHydrator' => array(
            'entity_class' => 'Model\\Entity\\User',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\UserAccessToken\\UserAccessTokenHydrator' => array(
            'entity_class' => 'Model\\Entity\\UserAccessToken',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\UserCustomer\\UserCustomerHydrator' => array(
            'entity_class' => 'Model\\Entity\\UserCustomer',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\UserLocation\\UserLocationHydrator' => array(
            'entity_class' => 'Model\\Entity\\UserLocation',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\UserPriceList\\UserPriceListHydrator' => array(
            'entity_class' => 'Model\\Entity\\UserPriceList',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\UserRepresentedCompany\\UserRepresentedCompanyHydrator' => array(
            'entity_class' => 'Model\\Entity\\UserRepresentedCompany',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\Warehouse\\WarehouseHydrator' => array(
            'entity_class' => 'Model\\Entity\\Warehouse',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\WarehouseTransaction\\WarehouseTransactionHydrator' => array(
            'entity_class' => 'Model\\Entity\\WarehouseTransaction',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
        'APIClient\\V1\\Rest\\WarehouseTransactionGroup\\WarehouseTransactionGroupHydrator' => array(
            'entity_class' => 'Model\\Entity\\WarehouseTransactionGroup',
            'object_manager' => 'doctrine.entitymanager.orm_default',
            'by_value' => true,
            'strategies' => array(),
            'use_generated_hydrator' => true,
        ),
    ),
);
