<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DeviceController
 *
 * @author renatopeterman
 */

namespace API\Controller;

use API\Exceptions\ApiBadRequestException;
use Model\Entity\UserAccessToken;

class UserController extends AbstractApiActionController {

    public function authOldAction(){
        try{

            $username = $this->params()->fromPost('username', false);
            if(!$username){
                throw new \Exception('Forneça um nome de usuário valido');
            }
            
            $password = $this->params()->fromPost('password', false);
            if(!$password){
                throw new \Exception('Forneça uma senha valida');
            }
            
            $user = $this->getEntityManager()->getRepository('Model\Entity\User')->findOneByUsername($username);
            if(!$user){
                throw new \Exception('Usuário ou senha inválidos (1)');
            }
            
            if(!\Model\Entity\User::hashPassword($user, $password)){
                throw new \Exception('Usuário ou senha inválidos (2)');
            }
            
            if(!$user->getActive()){
                throw new \Exception('Usuário desativado, por favor, contate o administrador do sistema');
            }
            
            return $this->createResponse(array('success' => true, 'data' => $user->getArrayCopy()));
            
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /**
     * Auth action
     * @return mixed
     */
    public function authAction(){

        try{

            $authHeader = null;
            if (!$this->getRequest()->getHeaders('Authorization')) {
                $authRedirect = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
                if (!isset($authRedirect) || !$authRedirect) {
                    throw new ApiBadRequestException('Authorization error (1)');
                }
                $authHeader = $authRedirect;
            } else {
                $authHeader = $this->getRequest()->getHeaders('Authorization')->getFieldValue();
            }

            list($type, $hash) = explode(' ', $authHeader);
            if (!$type || !$hash) {
                throw new ApiBadRequestException('Authorization error (2)');
            }

            if($type != 'Basic'){
                throw new ApiBadRequestException('Authorization error (3)');
            }

            list($username, $hashedPassword) = explode(':', base64_decode($hash));
            if (!$username || !$hashedPassword) {
                throw new ApiBadRequestException();
            }

            $user = $this->getEntityManager()->getRepository('Model\Entity\User')->findOneByUsername($username);
            if(!$user){
                throw new ApiBadRequestException('Authorization error (4) - User not found');
            }

            if(!\Model\Entity\User::hashPassword($user, $hashedPassword, false)){
                throw new \Exception('Usuário ou senha inválidos');
            }

            $accessToken = new UserAccessToken($user);
            $this->getEntityManager()->persist($accessToken);
            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                'access_token' => $accessToken->getAccessToken(),
                'expires_in' => UserAccessToken::EXPIRATION_TIME,
                'token_type' => 'Bearer',
                'scope' => ''
            ));

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /**
     * Update user location
     * @return mixed
     */
    public function updateLocationAction(){

        try {
			
			//TEMPORARIO MAICON
			if ((int)date('i') % 5 !== 0)
				return $this->createResponse(array(
					"success" => true
				));			

            $user = $this->params()->fromPost('user', false);
            $lat  = $this->params()->fromPost('latitude', false);
            $lng  = $this->params()->fromPost('longitude', false);
            $locationList  = $this->params()->fromPost('list', false);

            if (!$user)
                throw new \Exception('Usuário inválido (1)');

            if ((!$lat || !$lng) && $locationList === false) {
                    throw new \Exception('Usuário inválido (2)');
            }

            $user = $this->getEntityManager()->find('Model\Entity\User', $user);
            if (is_object($user) === false) {
                throw new \Exception('Usuário inválido (3)');
            }

            if ($locationList === false)
                $locationList = array(
                    0 => $lat.",".$lng.",".date('Y-m-d H:i:s')
                );
            else
                $locationList = json_decode($locationList, true);

            foreach ($locationList as $item) {

                list($latitude, $longitude, $datetime) = explode(",", $item);

                $location = new \Model\Entity\UserLocation();
                $location->setUser($user);
                $location->setLatitude($latitude);
                $location->setLongitude($longitude);
                $location->setLocationDate(\Commons\Util\DateTimeBr::createFromFormat("Y-m-d H:i:s", $datetime));
                $location->setSync(false);

                $this->getEntityManager()->persist($location);
            }

            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                "success" => true
            ));

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /**
     * Get user entity
     * /user/me
     */
    public function meAction(){

        try{

            return $this->createResponse( $this->getUser()->getArrayCopy() );

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    //--------------------------------- Raphael Vizoni do Prado 29/01/2016 ----------------------
    public function registerAction() {

        try {

            $json = array();

            // recebe o id vindo do post, setando valor falso por default
            $json['codigo'] = $this->params()->fromRoute('id', false);
            $post = $this->params()->fromPost();

            if(isset($json['codigo']) === false){
                throw new \Exception("Código invalido");
            }

            $user = null;
            if(isset($json['codigo']) && $json['codigo'] > 0){

                // se estiver setado, armazena na variavel $user,
                $user = $this->getEntityManager()->find('Model\Entity\User', $json['codigo']);

                // se o usuário não existir
                if(is_object($user) === false)
                    $user = new \Model\Entity\User();

                $user->setName($post['name']);
                $user->setEmail($post['email']);
                $user->setUsername($post['username']);
                $user->setPassword($post['password']);
                $user->setSellerId($post['sellerId']); // No modal está como "Código do vendedor: (integração)"
                $user->setActive($post['active']);
                $user->setAdmin($post['admin']);
                $user->setTrackLocation($post['trackerLocation']);

                $this->getEntityManager()->persist($user);
                $this->getEntityManager()->flush();

                return $this->createResponse(array('success' => true, 'id' => $user->getId()));
            }

            return $this->createResponse(array('success' => false));

        } catch (\Exception $e) {
            return $this->createErrorResponse($e->getMessage());
        }
    }
    //--------------------------------- Raphael Vizoni do Prado 29/01/2016 ----------------------

}

?>
