<?php

namespace API\Controller;

use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;
use Commons\Service\CepService;
use Commons\Util\Geolocation;

class ServicesLocationController extends AbstractApiActionController
{
    public function indexAction()
    {
        return new ViewModel();
    }

    public function getAddressAction(){

        $returnData = array('success' => false);
        $address = null;

        try{

            $cep = $this->params()->fromPost('cep',false);
            if(!$cep){
                throw new \Exception('Invalid cep parameter');
            }

            $address = CepService::getAddress($cep);

            $returnData['data'] = $address;
            $returnData['success'] = true;

        }  catch (\Exception $ex){
            $returnData['message'] = $ex->getMessage();
        }

        return new \Zend\View\Model\JsonModel($returnData);

    }

    public function getCoordinatesAction(){


        $returnData = array('success' => false);

        try{

            $address = $this->params()->fromPost();
            if(!$address){
                throw new \Exception("Invalid address");
            }

            $geolocation = Geolocation::getCoordinates($address['address'], $address['addressNumber'], $address['city'], $address['zip'], 'Brasil');
            if(!$geolocation){
                throw new \Exception("Location not found");
            }

            $returnData['success'] = true;
            $returnData['data'] = $geolocation;

        }catch (\Exception $ex){
            $returnData['message'] = $ex->getMessage();
        }

        return new \Zend\View\Model\JsonModel($returnData);

    }

}
