<?php

namespace API\Controller;

use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;
use Commons\Service\CepService;
use Commons\Util\Geolocation;

class FinancialPendingController extends AbstractApiActionController
{
    public function indexAction()
    {
        $this->layout('layout/print');

        $customerId = $this->params()->fromQuery('customer');

        if (empty($customerId) || (int)$customerId <= 0)
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('obj')
            ->from('Model\Entity\FinancialPending', 'obj')
            ->innerJoin('obj.customer', 'cus')
            ->andWhere('obj.status = 1')
            ->andWhere('obj.active = 1')
            ->orderBy('obj.id', 'DESC');

        if ($data['customer']->getCode() != null && $data['customer']->getCode() > 0)
            $query->andWhere($query->expr()->orX(
                $query->expr()->eq('cus.id', $data['customer']->getId()),
                $query->expr()->eq('cus.code', $data['customer']->getCode())
            ));
        else
            $query->andWhere('cus.id = '.$data['customer']->getId());

        $data['list'] = $query->getQuery()->getResult();

        return new ViewModel($data);
    }
}
