<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DeviceController
 *
 * @author renatopeterman
 */

namespace API\Controller;

class DeviceController extends AbstractApiActionController {
    
    public function syncAction(){

        try{
            
            $res = array('success' => true, 'authorized' => false);

            $os     = $this->params()->fromPost('os',false);
            $model  = $this->params()->fromPost('model',false);
            $uuid   = $this->params()->fromPost('uuid', false);

            if(!$uuid){
                throw new \Exception('ID invalido');
            }

            $obj = $this->getEntityManager()->getRepository('Model\Entity\Device')->findOneByUuid($uuid);
            if($obj){
                
                $res['id'] = $obj->getId();
                $res['authorized'] = $obj->getActive();
                $res['warehouse'] = $obj->getWarehouse() ? $obj->getWarehouse()->getId() : null;
                $res['warehouseDescription'] = $obj->getWarehouse() ? $obj->getWarehouse()->getDescription() : null;
                
            }else{
                
                $count = $this->getEntityManager()->createQueryBuilder('Model\Entity\Device')
                                ->select('COUNT(obj)')
                                ->from('Model\Entity\Device','obj')
                                ->getQuery()->getSingleScalarResult();
                
                $config = $this->getServiceLocator()->get('Config');
                if($count >= $config['salestool']['deviceLimit']){
                    throw new \Exception('O limite de dispositivos cadastrados foi atingido. Por favor entre em contato com o suporte técnico.');
                }

                $entity = new \Model\Entity\Device();
                $entity->setOs($os);
                $entity->setModel($model);
                $entity->setUuid($uuid);
                $entity->setActive(false);

                $currentUser = $this->getUser();
                if (is_object($currentUser)) {
                    $entity->setUser($currentUser);
                }

                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();
                
                $res['id'] = $entity->getId();
                $res['authorized'] = $entity->getActive();
                $res['warehouse'] = $entity->getWarehouse() ? $entity->getWarehouse()->getId() : null;
                $res['warehouseDescription'] = $entity->getWarehouse() ? $entity->getWarehouse()->getDescription() : null;
                
            }
            
            return $this->createResponse($res);
            
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

    }
    
}

?>
