<?php

namespace API\Controller\Custom\Unimake;

use API\Controller\AbstractApiActionController;
use Rhumsaa\Uuid\Console\Exception;
use Zend\Mvc\MvcEvent;
use Commons\Util\DateTimeBr;
use Model\Entity\Order;

class SyncController extends AbstractApiActionController
{

    /*
    const DB_HOST = "localhost";
    const DB_PORT = "5432";
    const DB_USER = "postgres";
    const DB_PASSWORD = "123456";
    const DB_DBNAME = "unimake";
    const ID_STATUS_AFTER_UPDATE_ORDER = "";
    const SCHEME = "xemp_0001";
    */

    const DB_HOST = "conex.no-ip.biz";
    const DB_PORT = "5432";
    const DB_USER = "supervisor";
    const DB_PASSWORD = "walker2";
    const DB_DBNAME = "unico";
    const ID_STATUS_AFTER_UPDATE_ORDER = "";
    const SCHEME = "xemp_0001";

    private $entities;
    private $dbcon;

    private $codeUsed;

    public function indexAction()
    {
        return $this->createResponse(array(
            'result' => true
        ));
    }

    //--------------------------------------------//

    public function uploadAction()
    {
        try {
            $this->connect();

            $data = array();

            $this->setLog('sync:upload:unimake', 'start');

            $data['customer'] = $this->uploadCustomers();
            $data['order'] = $this->uploadOrders();

            $this->setLog('sync:upload:unimake', serialize($data));
            $this->setLog('sync:upload:unimake', 'end');

            return $this->createResponse($data);
        } catch (\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro: " . $ex->getMessage());
        }
    }

    public function uploadCustomers()
    {
        try {

            $customersToSync = $this->getEntityManager()->getRepository('Model\Entity\Customer')->findBy(array('sync' => false));
            if (count($customersToSync) == 0)
                return true;

            $sqlCustomer = "SELECT fco, sr_recno FROM " . self::SCHEME . ".GeCad ORDER BY fco DESC LIMIT 1";
            $resultCustomer = $this->query($sqlCustomer, array(), false);
            if (
                isset($resultCustomer[0]) == false || isset($resultCustomer[0]['fco']) == false || empty($resultCustomer[0]['fco']) ||
                isset($resultCustomer[0]['sr_recno']) == false || empty($resultCustomer[0]['sr_recno'])
            )
                return false;

            $newCode = str_pad((int)$resultCustomer[0]['fco'], strlen(trim($resultCustomer[0]['fco'])), '0', STR_PAD_LEFT);
            $newRecno = (int)$resultCustomer[0]['sr_recno'];

            $sqlQuery = array();

            foreach ($customersToSync as $key => $customer) {

                $newCode = str_pad((int)$newCode + 1, strlen(trim($newCode)), '0', STR_PAD_LEFT);
                $newRecno++;

                $sqlQuery[] = "INSERT INTO " . self::SCHEME . ".gecad
                                (
                                    fco, fgr, ffj, frs, fno, fregativo, fve, fve2, fen, fe2, fce, fcci, fci, fuf, ffo_ob, ff2_ob, ffx_ob, fcg, fie, frg, finscrinss, fob, fcf, fpd, fdfinanc, fprazo, fbanco, fem, fcb, ficmssipi, ftippgto, fcondpag, fareaatua, frota, ftransport, flista, ftabpreco, fmulta, fdiasantv, fdiasapv, fsubtrib, fatcustosg, fpredmarg, fdatacad, fsetor, fagrupatit, femitebloq, fantvencto, fatividade, fconv, exporta, falthora, ftabsubtri, fdatanasc, fpreposto, ffoto, fidgecnae, fpalavra, flograd, fnumero, sr_recno, fdeinssrur, ftcfu, fcodsufr, fdiasmov, fdtavsmov, favsemmov, fincdata, finchora, fincusu, faltusu, fsitnfse, ffo, ff2, ffx, ftcis, fcredicms, fcompl, fidbairro
                                ) VALUES(
                                   '" . $newCode . "',
                                   '', 
                                   '" . strtoupper(substr($customer->getCustomerType(), 1, 1)) . "', 
                                   '" . ($customer->getCompanyName() != null ? $customer->getCompanyName() : '') . "', 
                                   '" . ($customer->getName() != null ? $customer->getName() : '') . "', 
                                   'S', 
                                   '', 
                                   '', 
                                   '" . ($customer->getAddress() != null ? $customer->getAddress() : '') . "" . ($customer->getAddressNumber() != null ? ", " . $customer->getAddressNumber() : '') . "', 
                                   '" . ($customer->getNeighbourhood() != null ? $customer->getNeighbourhood() : '') . "', 
                                   '" . ($customer->getZip() != null ? $customer->getZip() : '') . "', 
                                   '', 
                                   '" . ($customer->getCity() != null ? $customer->getCity() : '') . "', 
                                   '" . ($customer->getState() != null ? $customer->getState() : '') . "', 
                                   '', 
                                   '',  
                                   '', 
                                   '" . ($customer->getDocumentNumber() != null ? $customer->getDocumentNumber() : '') . "', 
                                   '" . ($customer->getSecondaryDocumentNumber() != null ? $customer->getSecondaryDocumentNumber() : '') . "', 
                                   '" . ($customer->getSecondaryDocumentNumber() != null ? $customer->getSecondaryDocumentNumber() : '') . "', 
                                   '', 
                                   '', 
                                   'A', 
                                   0.0000, 
                                   0.0000, 
                                   0, 
                                   '', 
                                   '', 
                                   'S', 
                                   'N', 
                                   'O', 
                                   '', 
                                   '', 
                                   '', 
                                   '', 
                                   '', 
                                   '', 
                                   0.0000, 
                                   0, 
                                   0, 
                                   'S', 
                                   '', 
                                   0.0000, 
                                   TO_DATE('" . ($customer->getCreatedFormat('Y-m-d')) . "', 'YYYY-MM-DD'), 
                                   '', 
                                   '', 
                                   'S', 
                                   0, 
                                   '00000', 
                                   '', 
                                   TO_DATE('" . (date('Y-m-d')) . "','YYYY-MM-DD'), 
                                   '" . date('H:i') . "', 
                                   '', 
                                   NULL, 
                                   '', 
                                   '', 
                                   '', 
                                   '', 
                                   '" . ($customer->getAddress() != null ? $customer->getAddress() : '') . "', 
                                   '" . ($customer->getAddressNumber() != null ? $customer->getAddressNumber() : '') . "', 
                                   " . $newRecno . ", 
                                   '', 
                                   '', 
                                   '', 
                                   0, 
                                   NULL, 
                                   '', 
                                   TO_DATE('" . (date('Y-m-d')) . "','YYYY-MM-DD'), 
                                   '" . date('H:i') . "', 
                                   'CONEX', 
                                   'CONEX',
                                   '', 
                                   '" . ($customer->getPhonePrimary() != null ? $customer->getPhonePrimary() : '') . "', 
                                   '" . ($customer->getPhoneSecondary() != null ? $customer->getPhoneSecondary() : '') . "', 
                                   '', 
                                   '', 
                                   '', 
                                   '', 
                                   '000000000'
                                );";

                $customer->setCode($newCode);
                $customer->setSync(true);
                $customer->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($customer);

            }

            $result = $this->queryTransaction($sqlQuery);
            if ($result !== true)
                throw new Exception('Não foi possível sincronizar os clientes novos com o banco de dados!');
            else
                $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $e->getMessage());
        }
    }

    public function uploadOrders()
    {
        try {

            $ordersToSync = $this->getEntityManager()->getRepository('Model\Entity\Order')->findBy(array('sync' => false));
            if (count($ordersToSync) == 0)
                return true;

            $sqlQuery = array();

            //$idOrderDb = 0;

            foreach ($ordersToSync as $key => $order) {

                $orderItens = $order->getOrderProducts();
                if (count($orderItens) > 0) {

                    try {

                        if (
                            is_object($order->getCustomer()) === false || $order->getCustomer()->getCode() == '' ||
                            is_object($order->getUser()) === false || $order->getUser()->getCode() == ''
                        )
                            continue;

                        $sql = "INSERT INTO " . self::SCHEME . ".unipedc (
                                                frotina,
                                                fchave,
                                                fclifor,
                                                fpedido,
                                                fdataped,
                                                fcondpgto,
                                                ftipomovto,
                                                ftipopedel,
                                                fvendedor,
                                                ffilial,
                                                fobs,
                                                fstatus,
                                                fvalortot,
                                                exporta,
                                                falthora,
                                                faltusu,
                                                fincusu,
                                                fincdata,
                                                finchora
                                            ) VALUES (
                                                'SALESTOO',
                                                '" . $order->getId() . "',
                                                '" . (is_object($order->getCustomer()) ? $order->getCustomer()->getCode() : '') . "',
                                                '" . $order->getId() . "',
                                                TO_DATE('" . (date('Y-m-d')) . "','YYYY-MM-DD'),
                                                '" . (is_object($order->getPaymentCondition()) ? $order->getPaymentCondition()->getCode() : '') . "',
                                                'S',
                                                '001',
                                                '" . (is_object($order->getUser()) ? $order->getUser()->getCode() : '') . "',
                                                '000',
                                                '" . $order->getInfo() . "',
                                                '1',
                                                " . $order->getTotal() . ",
                                                CURRENT_DATE,
                                                CURRENT_TIME::CHAR(8),
                                                'UNPEDEL',
                                                'UNPEDEL',
                                                CURRENT_DATE,
                                                CURRENT_TIME::CHAR(5)                               
                                            )";

                        //$idOrderDb = $this->queryTransaction($sql, true);

                        if ($this->queryTransaction($sql)) {
                            //$qtdItens = 0;
                            foreach ($orderItens as $item) {

                                if (
                                    is_object($item->getProduct()) === false
                                    || $item->getProduct()->getCode() == ''
                                )
                                    continue;

                                $sqlQuery[] = "INSERT INTO " . self::SCHEME . ".unipedi (
                                            frotina,
                                            fchave,
                                            fproduto,
                                            fsequencia,
                                            ftipoitem,
                                            fqtde,
                                            fvlrunit,
                                            fvlrtotal,
                                            fvdescnorm,
                                            fvdescprom
                                        ) VALUES (
                                            'SALESTOO',
                                            '" . $order->getId() . "',
                                            '" . (is_object($item->getProduct()) ? $item->getProduct()->getCode() : '') . "',
                                            '',
                                            'N',
                                            " . $item->getAmount() . ",
                                            " . $item->getPrice() . ",
                                            " . $item->getTotal() . ",
                                            " . ($item->getDiscount() > 0 ? round($item->getDiscount() / $item->getAmount(), 2) : 0) . ",
                                            " . ($item->getDiscount() > 0 ? (round($item->getDiscount() / $item->getTotal(), 2) * 100) : 0) . "
                                        )";

                                $item->setSync(true);
                                $item->setSyncDatetime(new DateTimeBr());
                                $this->getEntityManager()->persist($item);
                            }

                            $this->queryTransaction($sqlQuery);

                            $sqlQuery = array();
                        }

                    } catch (\Exception $e) {
                        continue;
                    }

                    $order->setSync(true);
                    $order->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($order);
                }
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $e->getMessage());
        }
    }

    //--------------------------------------------//

    public function downloadAction()
    {
        try {
            $this->connect();

            $data = array();

            $this->codeUsed = array();

            $this->setLog('sync:download:unimake', 'start');

            $data['users'] = $this->syncUsers();
            $data['customer'] = $this->syncCustomers();
            $data['paymentCondition'] = $this->syncPaymentCondition();
            $data['unit'] = $this->syncUnits();
            $data['group'] = $this->syncGroups();
            $data['product'] = $this->syncProducts();
            $data['financialPending'] = $this->syncFinancialPending();
            $data['priceList'] = $this->syncPriceList();

            //$data['represented'] = $this->syncRepresented(); //(-)(-)()()
            //$data['customerUser'] = $this->syncCustomerUser(); //(OK)()()() DISABLED

            //--------- INACTIVE ITENS ------------//
            if (count($this->codeUsed) > 0) {
                foreach ($this->codeUsed as $entityName => $codesUsed) {
                    if (count($this->entities[$entityName]) > 0) {
                        foreach ($this->entities[$entityName] as $itemEntity) {

                            if (method_exists($itemEntity, 'getCode') === false)
                                break;

                            if (
                                in_array($itemEntity->getCode(), $codesUsed) == false
                                && ($entityName != 'User' || $itemEntity->getId() > 1)
                            ) {
                                $itemEntity->setActive(false);
                                $this->getEntityManager()->persist($itemEntity);
                            }

                        }
                    }
                }
                $this->getEntityManager()->flush();
            }
            //--------- INACTIVE ITENS ------------//

            $this->setLog('sync:download:unimake', serialize($data));
            $this->setLog('sync:download:unimake', 'end');

            return $this->createResponse($data);
        } catch (\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function syncUsers()
    {
        try {

            $sql = "SELECT fco,
                           fpe,
                           fno,
                           fnu,
                           ftipo,
                           fdescmax,
                           fem
                    FROM " . self::SCHEME . ".favend
                    WHERE fco IS NOT NULL AND fco != '' AND fno IS NOT NULL";

            $result = $this->query($sql);

            if (is_array($result) === false || count($result) == 0)
                return false;

            $this->codeUsed['User'] = array();

            foreach ($result as $vendedor) {

                if (
                    isset($vendedor['fco']) === false || empty($vendedor['fco'])
                    || isset($vendedor['fno']) === false || empty($vendedor['fno'])
                )
                    continue;

                $entity = $this->getEntityRelated('User', $vendedor['fco']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['User'][] = trim($vendedor['fco']);

                $entity->setCode(trim($vendedor['fco']));
                $entity->setName(trim($vendedor['fno']));
                $entity->setDiscountMaximum(isset($vendedor['fdescmax']) && floatval($vendedor['fdescmax']) > 0 ? floatval($vendedor['fdescmax']) : 0.00);
                //--UNIQUE--//
                $entity->setEmail(isset($vendedor['fem']) && strstr($vendedor['fem'], "@") !== false ? trim($vendedor['fem']) : trim($vendedor['fco']) . '@' . trim($vendedor['fco']) . '.com');
                $entity->setUsername((int)($vendedor['fco']) > 0 ? (int)($vendedor['fco']) : trim($vendedor['fco']));
                //--UNIQUE--//
                $entity->setPassword(empty($vendedor['fco']) === false ? trim($vendedor['fco']) : trim($vendedor['fco']));
                $entity->setActive(true);
                $entity->setAdmin(false);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncCustomers()
    {
        try {

            $sqlComp = "";

            $sql = "SELECT  fco,
                            fve,
                            frs,
                            fno,
                            ffo_ob,
                            fcg,
                            fie,
                            fce,
                            frg,
                            fen,
                            fe2,
                            flograd,
                            fnumero,
                            fcompl,
                            fuf,
                            fci,
                            ffo,
                            ff2,
                            fem,
                            fregativo,
                            ffj,
                            fob,
                            fno,
                            O.fsituacao AS status
                      FROM " . self::SCHEME . ".GeCad
                      LEFT JOIN " . self::SCHEME . ".GeCadO O ON O.fCliente = GeCad.fCo
                      WHERE fco IS NOT NULL AND fco != '' AND fno IS NOT NULL
                      " . $sqlComp;

            $result = $this->query($sql, array(), false);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum cliente foi encontrado!');

            $this->codeUsed['Customer'] = array();

            foreach ($result as $cliente) {

                $cliente['fco'] = trim($cliente['fco']);

                $pj = isset($cliente['ffj']) && strtoupper(trim($cliente['ffj'])) == 'J' ? true : false;

                $entity = $this->getEntityRelated('Customer', $cliente['fco']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['Customer'][] = trim($cliente['fco']);

                $entity->populateFromSync(array(
                    'code' => $cliente['fco'],
                    'nome' => ($pj === true ? $cliente['fno'] : $cliente['fno']),
                    'nickname' => '',
                    'razaoSocial' => ($pj === true ? $cliente['frs'] : ''),
                    'contato' => '',//$cliente['DS_CONTATO'],
                    'documentoNacional' => trim($cliente['fcg']),
                    'documentoEstadual' => ($pj === true ? $cliente['fie'] : $cliente['frg']),
                    'email' => $cliente['fem'],
                    'cep' => $cliente['fce'],
                    'endereco' => $cliente['flograd'],
                    'numero' => $cliente['fnumero'],
                    'complemento' => '', //$cliente['DS_COMPLEMENTO'],
                    'bairro' => $cliente['fe2'],
                    'cidade' => $cliente['fci'],
                    'estado' => $cliente['fuf'],
                    'tipo' => ($pj === true ? 'pj' : 'pf'),
                    'telefonePrincipal' => $cliente['ffo'],
                    'telefoneSecundario' => $cliente['ff2'],
                    'info' => $cliente['fob'],
                    'active' => (in_array((int)($cliente['status']), array(1, 2, 3, 5, 7, 8, 9)) ? true : false),
                    'latitude' => '',
                    'longitude' => '',
                ));

                if (!$entity->getId()) {
                    $entity->setBlocked($cliente['status'] == 8 ? true : false);
                }

                if (isset($cliente['fve']) && empty($cliente['fve']) === false) {
                    try {
                        $vendedor = $this->getEntityRelated('User', trim($cliente['fve']));
                        if (is_object($vendedor) && $vendedor->getId() != 0)
                            $entity->setUser($vendedor);
                    } catch (\Exception $e) {
                        //Do nothing
                    }
                }

                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncRepresented()
    {
        try {

            /*
            $sqlComp = '';

            $sql = "SELECT *
                    FROM ".self::SCHEME.".GeEmpre
                    WHERE fco IS NOT NULL AND fco != '' AND fno IS NOT NULL
                    ".$sqlComp;

            $result = $this->query($sql, array(), false);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum cliente foi encontrado!');

            $this->codeUsed['RepresentedCompany'] = array();

            foreach ($result as $represented) {

                $entity = $this->getEntityRelated('RepresentedCompany', $represented['fco']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['RepresentedCompany'][] = trim($represented['fco']);

                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();
            */

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    //Disabled
    public function syncCustomerUser()
    {
        try {

            $sqlComp = '';

            $sql = "SELECT fce,
                           fco
                    FROM " . self::SCHEME . ".GeCad
                    WHERE fco IS NOT NULL AND fco != ''
                    " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhuma lista de preço foi encontrada!');

            $this->codeUsed['UserCustomer'] = array();

            foreach ($result as $relation) {

                print_r($relation);

                $this->codeUsed['UserCustomer'][] = trim($relation['fco']);

                /*
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
                */
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncPriceList()
    {
        try {

            $sqlComp = '';

            $sql = "SELECT P.flp,
                           P.fco,
                           P.fp1,
                           L.fde
                    FROM " . self::SCHEME . ".FAPRECO P
                    left join " . self::SCHEME . ".falista L on L.fco = P.flp
                    WHERE P.fco IS NOT NULL AND P.fco != ''
                    " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhuma lista de preço foi encontrada!');

            $this->codeUsed['PriceList'] = array();
            $this->codeUsed['PriceListProduct'] = array();

            $default = null;
            foreach ($result as $list) {

                try {
                    $priceList = $this->getEntityRelated('PriceList', trim($list['flp']));

                    $this->codeUsed['PriceList'][trim($list['flp'])] = trim($list['flp']);

                    $priceList->setCode(trim($list['flp']));
                    $priceList->setDescription(trim($list['fde']));
                    if ($default == null) {
                        $default = true;
                    } else {
                        $default = false;
                    }
                    $priceList->setIsDefault($default);
                    $priceList->setActive(true);
                    $priceList->setSync(true);
                    $priceList->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($priceList);
                } catch (Exception $e) {
                    $priceList = null;
                }

                try {
                    $product = $this->getEntityRelated('Product', trim($list['fco']));
                } catch (Exception $e) {
                    $product = null;
                }

                if (
                    is_object($priceList) === false ||
                    is_object($product) === false || $product->getId() == null
                )
                    continue;

                $code = trim($list['flp']) . trim($list['fco']);

                $entity = $this->getEntityRelated('PriceListProduct', $code);

                $this->codeUsed['PriceListProduct'][] = trim($code);

                $entity->setCode($code);
                $entity->setCodeProduct(trim($list['fco']));
                $entity->setPriceList($priceList);
                $entity->setProduct($product);
                $entity->setPrice(floatval($list['fp1']));
                $entity->setPriceMinimum(floatval($list['fp1']));
                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncFinancialPending()
    {
        try {

            $sqlComp = '';

            $sql = "SELECT fco,
                             fcv,
                             ffa,
                             fve,
                             fvd
                      FROM " . self::SCHEME . ".RPReceb
                      WHERE fquitado = false 
                            AND fco IS NOT NULL 
                            AND fco != ''
                            AND ffa IS NOT NULL 
                            AND fve IS NOT NULL
                            AND fvd IS NOT NULL
                    " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhuma pendência financeira foi encontrada!');

            $this->codeUsed['FinancialPending'] = array();

            foreach ($result as $pending) {

                try {
                    $customer = $this->getEntityRelated('Customer', strtoupper(trim($pending['fco'])), true);
                } catch (Exception $e) {
                    $customer = null;
                }

                if (is_object($customer) === false || $customer->getId() == null)
                    continue;

                $pending['ffa'] = trim($pending['ffa']);

                $entity = $this->getEntityRelated('FinancialPending', $pending['ffa']);

                $this->codeUsed['FinancialPending'][] = trim($pending['ffa']);

                $entity->setCode($pending['ffa']);
                $entity->setDescription($pending['ffa']);
                $entity->setDate(\DateTime::createFromFormat('Y-m-d', substr($pending['fve'], 0, 10))); //(substr(trim($pending['fve']),0,10)." 00:00");
                $entity->setTotal(floatval($pending['fvd']));
                $entity->setStatus(1);
                $entity->setCustomer($customer);
                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncPaymentCondition()
    {
        try {

            $sqlComp = '';

            $sql = "SELECT fde,
                           fregativo,
                           fco
                      FROM " . self::SCHEME . ".FaCondP
                      WHERE fco IS NOT NULL AND fco != ''
                      " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhuma condição de pagamento foi encontrada!');

            $this->codeUsed['PaymentCondition'] = array();

            foreach ($result as $condition) {

                $entity = $this->getEntityRelated('PaymentCondition', $condition['fco']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['PaymentCondition'][] = trim($condition['fco']);

                $entity->setCode(trim($condition['fco']));
                $entity->setDescription(trim($condition['fde']));
                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncUnits()
    {
        try {

            $sqlComp = '';

            $sql = " SELECT fdescricao,
                            fcodigo 
                      FROM " . self::SCHEME . ".EsProdUn
                      WHERE fcodigo IS NOT NULL AND fcodigo != '' AND fdescricao IS NOT NULL 
                      " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhuma unidade foi encontrada!');

            $this->codeUsed['Unit'] = array();

            foreach ($result as $unit) {

                $entity = $this->getEntityRelated('Unit', $unit['fcodigo']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['Unit'][] = trim($unit['fcodigo']);

                $entity->setId(strtoupper(trim($unit['fcodigo'])));
                $entity->setCode(trim($unit['fcodigo']));
                $entity->setDescription(trim($unit['fdescricao']));
                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncGroups()
    {
        try {

            $sqlComp = '';

            $sql = "  SELECT fde,
                             fco,
                             fgrade
                      FROM " . self::SCHEME . ".EsGrupo
                      WHERE fde IS NOT NULL AND fco IS NOT NULL AND fco != ''
                      " . $sqlComp;

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum grupo de produto foi encontrado!');

            $this->codeUsed['Group'] = array();

            foreach ($result as $group) {

                $entity = $this->getEntityRelated('Group', $group['fco']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['Group'][] = trim($group['fco']);

                $entity->setCode(trim($group['fco']));
                $entity->setDescription(trim($group['fde']));
                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function syncProducts()
    {
        try {

            $sqlComp = '';

            $sql = "SELECT fgr,
                           '' AS fcodgrnivel2,
                           '' AS fcodgrnivel3,
                           fun,
                           '' AS fimagem,
                           fde,
                           '' AS reference,
                           P.fp1,
                           '' AS codbarra,
                           EsProd.fRegAtivo AS fregativo,
                           EsProd.fComplemen AS fcomplemen,
                           EsProd.fCo AS fco,
                           0 AS prepromo,
                           0 AS prepromomin,
                           0 AS qtdemin
                  FROM " . self::SCHEME . ".esprod
                  LEFT JOIN " . self::SCHEME . ".FaPreco P ON P.fLP = 'L001' AND P.fCo = Esprod.fCo
                  WHERE EsProd.fco IS NOT NULL AND EsProd.fco != ''
                  " . $sqlComp;

            //U.fcustodig,
            //LEFT JOIN ".self::SCHEME.".EsProdU U ON U.fProduto = EsProd.fco

            $result = $this->query($sql, array(), true);

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum produto foi encontrado!');

            $this->codeUsed['Product'] = array();

            foreach ($result as $produto) {

                try {
                    $grupo = $this->getEntityRelated('Group', trim($produto['fgr']));
                } catch (Exception $e) {
                    $grupo = null;
                }

                try {
                    $unidade = $this->getEntityRelated('Unit', strtoupper(trim($produto['fun'])), true);
                } catch (Exception $e) {
                    $unidade = null;
                }

                $produto['fco'] = trim($produto['fco']);

                $entity = $this->getEntityRelated('Product', $produto['fco']);

                if (
                ($entity->getId() > 0 && $entity->getSync() === false)
                )
                    continue;

                $this->codeUsed['Product'][] = trim($produto['fco']);

                $entity->populateFromSync(array(
                    'code' => $produto['fco'],
                    'name' => $produto['fde'],
                    'reference' => $produto['reference'],
                    'description' => $produto['fde'],
                    'barcode' => '',//$produto[''],
                    'info' => '',//$produto['DS_OBS'],
                    'unit' => (is_object($unidade) && $unidade->getId() != null ? $unidade : null),
                    'groupPrimary' => (is_object($grupo) && $grupo->getId() != null ? $grupo : null),
                    //'groupSecondary' => $subgrupo,
                    //'cost' => floatval($produto['fcustodig']),
                    'price' => 0.00, //$produto['VL_VENDA'],
                    'priceMin' => 0.00, //$produto['VL_MINIMO_VENDA'],
                    'commission' => 0.00, //$produto['NR_PERCENTUAL_COMISSAO'],
                    'descriptionGrid' => '',
                    'amountMinimal' => 0.00, //$produto['VL_MINIMO_VENDA'],
                    'pricePromotional' => 0
                ));

                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    //--------------------------------------------//

    private function connect()
    {
        try {
            $this->dbcon = new \PDO("pgsql:host=" . self::DB_HOST . ";port=" . self::DB_PORT . ";dbname=" . self::DB_DBNAME, self::DB_USER, self::DB_PASSWORD);
            $this->dbcon->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        } catch (Exception $e) {
            throw new \Exception("Ocorreu um erro: " . $e->getMessage());
            //return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function queryTransaction($sqlQueries = array(), $returnId = false)
    {
        try {
            if (is_array($sqlQueries) === false && empty($sqlQueries) === false)
                $sqlQueries = array($sqlQueries);

            if (is_array($sqlQueries) === false || count($sqlQueries) === 0)
                return false;

            $this->dbcon->beginTransaction();

            foreach ($sqlQueries as $sqlQuery) {
                $ret = $this->dbcon->exec($sqlQuery);
            }

            $this->dbcon->commit();

            if ($returnId === true)
                return $this->dbcon->lastInsertId(); //$db->lastInsertId('yourIdColumn');
            else
                return true;

        } catch (Exception $e) {
            $this->dbcon->rollback();
            throw new \Exception("Ocorreu um erro: " . $e->getMessage());
            //return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function query($sql, $execList = array(), $hasImage = false)
    {
        try {
            $stmt = $this->dbcon->prepare($sql);
            $stmt->execute($execList); //IM_FOTO
            $return = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $return;
        } catch (Exception $e) {
            throw new \Exception("Ocorreu um erro: " . $e->getMessage());
            //return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function getEntityRelated($entityName, $syncCode, $compareIdColumn = false)
    {
        $entity = "Model\Entity\\" . $entityName;
        if (isset($this->entities[$entityName]) === false) {
            $this->entities[$entityName] = $this->getEntityManager()
                ->createQueryBuilder($entity)
                ->select('obj')
                ->from($entity, 'obj')
                ->getQuery()->getResult();
        }

        if (count($this->entities[$entityName]) > 0) {
            foreach ($this->entities[$entityName] as $item) {
                if (
                    ($compareIdColumn === true && $item->getId() == trim($syncCode))
                    ||
                    (method_exists($item, 'getCode') && trim($item->getCode()) == trim($syncCode))
                )
                    return $item;
            }
        }

        $newEntity = new $entity();
        $this->entities[$entityName][] = $newEntity;

        return $newEntity;
    }

    private function getLowercase($list)
    {
        $response = array();
        if (is_array($list) && count($list) > 0) {
            foreach ($list as $key => $val) {
                $response[trim(strtolower($key))] = $val;
            }
        }
        return $response;
    }

    //--------------------------------------------//
}

//---------------------INFO-----------------------//

/*
    Pazin, o Flávio passou essa conexão do cliente

    Conexão no-ip
    Porta: 5432

    conex.no-ip.biz
    user: conexcm
    Senha: 123mudar@

    pg-admin
    177.132.122.142
    user: salestool
    senha: 10203040506
*/

/*
    -- cria usuário

    -- REVOKE ALL PRIVILEGES ON DATABASE neosul FROM salestool;
    -- DROP ROLE salestool;
    CREATE ROLE salestool LOGIN
     NOSUPERUSER NOINHERIT NOCREATEDB NOCREATEROLE
     ENCRYPTED PASSWORD '18X012z001=';

    -- seta caminho
    SET SEARCH_PATH TO xemp_0001, xgeral;

    -- concede acesso para os esquemas
    GRANT USAGE  ON SCHEMA  xgeral    TO salestool;
    GRANT USAGE  ON SCHEMA  xemp_0001 TO salestool;

    -- concede acesso para as tabelas
    GRANT SELECT ON adci     TO salestool;
    GRANT SELECT ON essaldo  TO salestool;
    GRANT SELECT ON gecad    TO salestool;
    GRANT SELECT ON gecado   TO salestool;
    GRANT SELECT ON gecid    TO salestool;
    GRANT SELECT ON favend   TO salestool;
    GRANT SELECT ON esprod   TO salestool;
    GRANT SELECT ON esproda  TO salestool;
    GRANT SELECT ON esprodo  TO salestool;
    GRANT SELECT ON esprode  TO salestool;
    GRANT SELECT ON esgrupo  TO salestool;
    GRANT SELECT ON fapreco  TO salestool;
    GRANT SELECT ON rpreceb  TO salestool;
    GRANT SELECT ON bcchpd   TO salestool;
    GRANT SELECT ON fadesc   TO salestool;
    GRANT SELECT ON gecaddes TO salestool;
    GRANT SELECT ON esesti   TO salestool;
    GRANT SELECT ON essubtri TO salestool;
    GRANT SELECT ON esestc   TO salestool;
    GRANT SELECT,INSERT ON unipedc  TO salestool;
    GRANT SELECT,INSERT ON unipedi  TO salestool;
    GRANT SELECT,INSERT ON unipedp  TO salestool;
*/
//---------------------INFO-----------------------//
