<?php

namespace API\Controller\Custom\Makito;

use API\Controller\AbstractApiActionController;

class DataController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {

        $this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        return $this->config;
    }

    /*
    {
      "id": 21,
      "code": null,
      "reference": null,
      "type": "p",
      "orderDate": {
        "date": "2016-09-22 09:36:00.000000",
        "timezone_type": 3,
        "timezone": "America/Sao_Paulo"
      },
      "expectedDelivery": null,
      "appDatetimeToSync": null,
      "appSync": null,
      "appSyncDatetime": null,
      "subtotal": "80.00",
      "discount": "0.00",
      "discountPercent1": null,
      "discountPercent2": null,
      "discountPercent3": null,
      "discountPercent4": null,
      "discountPercent5": null,
      "total": "80.00",
      "commission": "0.00",
      "status": 3,
      "info": "",
      "longitude": "-52.37628230",
      "latitude": "-24.04233210",
      "active": true,
      "created": {
        "date": "2016-09-22 09:32:05.000000",
        "timezone_type": 3,
        "timezone": "America/Sao_Paulo"
      },
      "updated": {
        "date": "2016-09-22 15:50:19.000000",
        "timezone_type": 3,
        "timezone": "America/Sao_Paulo"
      },
      "sync": false,
      "syncDatetime": null,
      "orderProducts": [
        {
          "commission": "0.00",
          "id": 30,
          "code": null,
          "referenceProduct": null,
          "codeProduct": null,
          "amount": "4.00",
          "amountRound": "4",
          "amountDevolution": null,
          "amountDevolutionRound": "0",
          "amountDevolutionInvoice": null,
          "amountDevolutionInvoiceRound": "0",
          "price": "20.00",
          "priceCurrency": "20,00",
          "priceCurrencyBRL": "R$ 20,00",
          "subtotal": "80.00",
          "subtotalCurrency": "80,00",
          "subtotalCurrencyBRL": "R$ 80,00",
          "discount": "0.00",
          "discountCurrency": "0,00",
          "discountCurrencyBRL": "R$ 0,00",
          "discountPercent1": null,
          "discountPercent2": null,
          "discountPercent3": null,
          "discountPercent4": null,
          "discountPercent5": null,
          "total": "80.00",
          "totalCurrency": "80,00",
          "totalCurrencyBRL": "R$ 80,00",
          "obs": "",
          "active": true,
          "created": {
            "date": "2016-09-22 09:32:05.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "updated": null,
          "sync": false,
          "syncDatetime": null,
          "createdFormat": "22/09/2016 09:32",
          "updatedFormat": "",
          "createdDatetimeStr": "22/09/2016 09:32",
          "updatedDatetimeStr": ""
        }
      ],
      "device": null,
      "representedCompany": null,
      "paymentMethod": null,
      "orderType": null,
      "orderClassification": null,
      "orderCustomerType": null,
      "_embedded": {
        "user": {
          "id": "1",
          "code": null,
          "name": "Administrador",
          "email": "admin@localhost",
          "username": "admin",
          "password": "$2y$10$PZo2IwogZwlrf4jazV3S3.Q1/AlNO.uJlS1ZFFR.aC0IqrHDBgCEW",
          "admin": true,
          "trackLocation": false,
          "tokenPassword": null,
          "sellerId": null,
          "discountMaximum": null,
          "image": null,
          "authorizationCode": null,
          "refreshToken": null,
          "active": true,
          "created": {
            "date": "2015-08-27 19:53:50.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "updated": {
            "date": "2016-09-22 17:31:03.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "sync": null,
          "syncDatetime": null,
          "client": {},
          "accessToken": {},
          "locations": {},
          "representedCompanies": {},
          "userPriceLists": {},
          "userCustomers": {},
          "_links": {
            "self": {
              "href": "http://localhost/api/v1/user/1"
            }
          }
        },
        "customer": {
          "id": 21,
          "code": "2",
          "name": "Fabiano Tunes",
          "nickname": null,
          "companyName": null,
          "contact": null,
          "documentNumber": "066.447.889-12",
          "secondaryDocumentNumber": null,
          "zip": "87309-087",
          "address": "Rua Doutor Carlos Boenig",
          "addressNumber": "685",
          "neighbourhood": "Jardim Francisco Ferreira Albuquerque",
          "addressComplement": null,
          "state": "PR",
          "city": "Campo Mourão",
          "phonePrimary": null,
          "phoneSecondary": null,
          "website": null,
          "email": "fabianotumes@hotmail.com",
          "longitude": "0.00000000",
          "latitude": "0.00000000",
          "blocked": null,
          "customerType": "pf",
          "info": null,
          "lastOrderDate": {
            "date": "2016-09-23 09:37:00.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "discount": null,
          "active": true,
          "created": {
            "date": "2016-09-05 17:48:40.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "updated": {
            "date": "2016-09-23 09:37:56.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "sync": false,
          "syncDatetime": null,
          "orders": {},
          "representedCompanies": {},
          "user": null,
          "userCustomers": {},
          "_links": {
            "self": {
              "href": "http://localhost/api/v1/customer/21"
            }
          }
        },
        "warehouse": {
          "id": 1,
          "code": null,
          "description": "Padrão",
          "main": true,
          "active": true,
          "created": {
            "date": "2015-08-27 19:53:50.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "updated": {
            "date": "2016-09-05 17:36:52.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "sync": null,
          "syncDatetime": null,
          "orderProducts": {},
          "productWarehouses": {},
          "productWarehouseVariants": {},
          "warehouseTransactionRelatedByIdWarehouseFroms": {},
          "warehouseTransactionRelatedByIdWarehouseTos": {},
          "_links": {
            "self": {
              "href": "http://localhost/api/v1/warehouse/1"
            }
          }
        },
        "paymentCondition": {
          "id": 5,
          "code": "1",
          "description": "Makito A vista",
          "active": true,
          "created": {
            "date": "2016-09-20 13:58:17.000000",
            "timezone_type": 3,
            "timezone": "America/Sao_Paulo"
          },
          "updated": null,
          "sync": false,
          "syncDatetime": null,
          "_links": {
            "self": {
              "href": "http://localhost/api/v1/payment-condition/5"
            }
          }
        }
      },
      "_links": {
        "self": {
          "href": "http://localhost/api/v1/order/21"
        }
      }
    }
    */

    public function orderAction(){

        try {

            $this->setConfig();

            $user = $this->getUser();
            if (is_object($user) === false) {
                throw new Exception('Usuário não encontrado!');
            }

            $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\Order');

            $query->select('obj')
                ->from('Model\Entity\Order','obj')
                ->orderBy('obj.id', 'ASC');
                //->andWhere('obj.user = :userId')
                //->setParameter('userId', $user->getId());


            $orderId = $this->getEvent()->getRouteMatch()->getParam('id');
            if (empty($orderId) === false) {
                $query->andWhere('obj.id = :orderId')
                    ->setParameter('orderId', $orderId);
            }

            //filter[0][field]=status&filter[0][type]=eq&filter[0][value]=1
            $filters = $this->params()->fromQuery('filter', null);
            if ($filters !== null && is_array($filters) && count($filters) > 0) {
                $filterList = array(
                    'eq' => '=',
                    'neq' => '<>',
                    'lt' => '<',
                    'lte' => '<=',
                    'gt' => '>',
                    'gte' => '>=',
                    'isnull' => 'IS NULL',
                    'isnotnull' => 'IS NOT NULL',
                    'in' => 'IN',
                    'notin' => 'NOT IN',
                    'like' => 'LIKE',
                );
                foreach ($filters as $filter) {
                    $query->andWhere('obj.'.trim($filter['field']).' '.(isset($filter['type']) && isset($filterList[trim($filter['type'])]) ? $filterList[trim($filter['type'])] : '=').' '.(isset($filter['value']) ? trim($filter['value']) : ''));
                }
            }


            $results = $query->getQuery()->getResult(); //->setMaxResults(1)

            $retorno = array();
            if (count($results) > 0) {
                $counter = 0;
                foreach ($results as $ent) {
                    $order = array(
                        'id' => $ent->getId(),
                        'code' => $ent->getCode(),
                        'reference' => $ent->getReference(),
                        'type' => $ent->getType(),
                        'orderDate' => $ent->getOrderDate(), //->format('d/m/Y H:i'),
                        'expectedDelivery' => $ent->getExpectedDelivery(),
                        'subtotal' => (float)$ent->getSubtotal(),
                        'discount' => (float)$ent->getDiscount(),
                        'discountPercent1' => (float)$ent->getDiscountPercent1(),
                        'discountPercent2' => (float)$ent->getDiscountPercent2(),
                        'discountPercent3' => (float)$ent->getDiscountPercent3(),
                        'discountPercent4' => (float)$ent->getDiscountPercent4(),
                        'discountPercent5' => (float)$ent->getDiscountPercent5(),
                        'total' => (float)$ent->getTotal(),
                        'commission' => (float)$ent->getCommission(),
                        'status' => $ent->getStatus(),
                        'info' => $ent->getInfo(),
                        'longitude' => $ent->getLongitude(),
                        'latitude' => $ent->getLatitude(),
                        'active' => $ent->getActive(),
                        'created' => $ent->getCreated(),
                        'updated' => $ent->getUpdated(),
                        'sync' => $ent->getSync(),
                        'orderProducts' => array(),
                        'device' => '',
                        '_embedded' => array(
                            'user' => array(
                                'id' => (int)$user->getId(),
                                'code' => $user->getCode(),
                                'name' => $user->getName()
                            ),
                            'customer' => array(
                                'id' => (is_object($ent->getCustomer())?$ent->getCustomer()->getId():null),
                                'code' => (is_object($ent->getCustomer())?$ent->getCustomer()->getCode():null),
                                'name' => (is_object($ent->getCustomer())?$ent->getCustomer()->getName():null),
                                'city' => (is_object($ent->getCustomer())?$ent->getCustomer()->getCity():null),
                                'state' => (is_object($ent->getCustomer())?$ent->getCustomer()->getState():null)
                            ),
                            'warehouse' => array(
                                'id' => (is_object($ent->getWarehouse())?$ent->getWarehouse()->getId():null),
                                'code' => (is_object($ent->getWarehouse())?$ent->getWarehouse()->getCode():null),
                                'description' => (is_object($ent->getWarehouse())?$ent->getWarehouse()->getDescription():null)
                            ),
                            'paymentCondition' => array(
                                'id' => (is_object($ent->getPaymentCondition())?$ent->getPaymentCondition()->getId():null),
                                'code' => (is_object($ent->getPaymentCondition())?$ent->getPaymentCondition()->getCode():null),
                                'description' => (is_object($ent->getPaymentCondition())?$ent->getPaymentCondition()->getDescription():null)
                            ),
                            'paymentMethod' => array(
                                'id' => (is_object($ent->getPaymentMethod())?$ent->getPaymentMethod()->getId():null),
                                'code' => (is_object($ent->getPaymentMethod())?$ent->getPaymentMethod()->getCode():null),
                                'description' => (is_object($ent->getPaymentMethod())?$ent->getPaymentMethod()->getDescription():null)
                            ),
                            'orderClassification' => array(
                                'id' => (is_object($ent->getOrderClassification())?$ent->getOrderClassification()->getId():null),
                                'code' => (is_object($ent->getOrderClassification())?$ent->getOrderClassification()->getCode():null),
                                'description' => (is_object($ent->getOrderClassification())?$ent->getOrderClassification()->getDescription():null)
                            ),
                            'orderType' => array(
                                'id' => (is_object($ent->getOrderType())?$ent->getOrderType()->getId():null),
                                'code' => (is_object($ent->getOrderType())?$ent->getOrderType()->getCode():null),
                                'description' => (is_object($ent->getOrderType())?$ent->getOrderType()->getDescription():null)
                            ),
                            'representedCompany' => array(
                                'id' => (is_object($ent->getRepresentedCompany())?$ent->getRepresentedCompany()->getId():null),
                                'code' => (is_object($ent->getRepresentedCompany())?$ent->getRepresentedCompany()->getCode():null),
                                'name' => (is_object($ent->getRepresentedCompany())?$ent->getRepresentedCompany()->getCompanyName():null)
                            ),
                            'orderCustomerType' => array(
                                'id' => (is_object($ent->getOrderCustomerType())?$ent->getOrderCustomerType()->getId():null),
                                'code' => (is_object($ent->getOrderCustomerType())?$ent->getOrderCustomerType()->getCode():null),
                                'description' => (is_object($ent->getOrderCustomerType())?$ent->getOrderCustomerType()->getDescription():null)
                            ),
                        ),
                    );
                    $retorno[$counter] = $order;
                    $itens = $ent->getOrderProducts();
                    if (count($itens) > 0) {
                        $counterItem = 0;
                        foreach($itens as $item){
                            if (is_object($item->getProduct())) {
                                $retorno[$counter]['orderProducts'][$counterItem] = array(
                                    'id' => $item->getId(),
                                    'code' => $item->getCode(),
                                    'codeProduct' => $item->getCodeProduct(),
                                    'reference' => $item->getReferenceProduct(),
                                    'product' => array(
                                        'id' => (is_object($item->getProduct())?$item->getProduct()->getId():null),
                                        'code' => (is_object($item->getProduct())?$item->getProduct()->getCode():null),
                                        'name' => (is_object($item->getProduct())?$item->getProduct()->getName():null),
                                    ),
                                    'warehouse' => array(
                                        'id' => (is_object($item->getWarehouse())?$item->getWarehouse()->getId():null),
                                        'code' => (is_object($item->getWarehouse())?$item->getWarehouse()->getCode():null),
                                        'description' => (is_object($item->getWarehouse())?$item->getWarehouse()->getDescription():null),
                                    ),
                                    'amount' => (int)$item->getAmount(),
                                    'price' => (float)$item->getPrice(),
                                    'subtotal' => (float)$item->getSubtotal(),
                                    'discount' => (float)$item->getDiscount(),
                                    'total' => (float)$item->getTotal(),
                                    'obs' => $item->getObs(),
                                    'commission' => (float)$item->getCommission(),
                                    'orderProductVariants' => array()
                                );

                                $variantItens = $item->getOrderProductVariants();
                                if (count($variantItens) > 0) {
                                    $counterVariantItem = 0;
                                    foreach($variantItens as $variantItem){
                                        if (is_object($item->getProduct())) {
                                            $retorno[$counter]['orderProducts'][$counterItem]['orderProductVariants'][$counterVariantItem] = array(
                                                'id' => $variantItem->getId(),
                                                'code' => $variantItem->getCode(),
                                                'size' => (is_object($variantItem->getSize())?array(
                                                    'id' => $variantItem->getSize()->getId(),
                                                    'code' => $variantItem->getSize()->getCode(),
                                                    'description' => $variantItem->getSize()->getDescription(),
                                                ):null),
                                                'color' => (is_object($variantItem->getColor())?array(
                                                    'id' => $variantItem->getColor()->getId(),
                                                    'code' => $variantItem->getColor()->getCode(),
                                                    'description' => $variantItem->getColor()->getDescription(),
                                                ):null),
                                                'amount' => (int)$variantItem->getAmount()
                                            );
                                            $counterVariantItem++;
                                        }
                                    }
                                }


                            }
                            $counterItem++;
                        }
                    }
                    $counter++;
                }
            }

            return $this->createResponse($this->replaceUselessValues($retorno));

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

    }

    /**
     * Helper to replace useless values
     * @param $array
     */
    private function replaceUselessValues($array){

        $func = function (&$array, $func) {
            foreach ($array as $k => $v) {
                if (strstr($k, '__') !== false) {
                    unset($array[$k]);
                    continue;
                }
                if (is_array($v)) {
                    if (isset($v['date']))
                        $array[$k] = $v['date'];
                    else
                        $array[$k] = $func($v, $func);
                }
            }
            return $array;
        };

        $func($array, $func);

        return $array;

    }

}
