<?php

namespace API\Controller\Custom\Atual;

use API\Controller\AbstractApiActionController;
use Commons\Util\DateTimeBr;
use Doctrine\Entity;
use Rhumsaa\Uuid\Console\Exception;

class SyncController extends AbstractApiActionController
{
    //Auth Basic CONEX:C0N3X
    const URL_API_PRODUCT_GROUP_SECTION = "/secao";
    const URL_API_PRODUCT_GROUP_GROUP = "/grupo";
    const URL_API_PRODUCT_GROUP_SUBGROUP = "/subgrupo";
    const URL_API_PRODUCT = "/produtos"; // /paginado/{page}/{pageSize}
    const URL_API_PRODUCT_IMAGE = "/produtos/{cod_produto}/{cod_ref}/imagem";
    const URL_API_PRICE_LIST = "/listapreco"; /* /{cod_vendedor} */  // /paginado/{page}/{pageSize}
    const URL_API_USERS = "/vendedor"; /* /{cod_vendedor} */
    const URL_API_CUSTOMER = "/clientes"; // /paginado/{page}/{pageSize}
    const URL_API_POST_CUSTOMER = "/clientes";
    const URL_API_UNIT_AMOUNT = "/consulta/und";
    const URL_API_TYPE_MOVIMENT = "/tipomovimentacao";
    const URL_API_PAYMENT_METHOD = "/metodocobranca";
    const URL_API_PAYMENT_CONDITION = "/condicaopagamento";
    const URL_API_FINANCIAL_PENDING = "/pendencias"; // /paginado/{codeCustomer}/{page}/{pageSize}
    const URL_API_WAREHOUSE = "/produtos/{cod_produto}/{cod_ref}/estoque?cod_vendedor={cod_vendedor}";
    const URL_API_ORDER = "/pedido"; // /paginado/{page}/{pageSize}
    const URL_API_POST_ORDER = "/pedido";
    const URL_API_REPORT = "/{entity}/{cod_cadastro}/pedidos?cod_vendedor={cod_vendedor}&data_inical={data_inicial}&data_final={data_final}";

    const PAGINATION_URI = "/paginado/{page}/{pageSize}";
    const PAGINATION_URI_PENDING = "/paginado/{codeCustomer}/{page}/{pageSize}";

    public function indexAction()
    {
       //Do nothing
       die('Sync Atual');
    }

    public function uploadAction()
    {
        try{
            $data = array();

            $this->setLog('sync:upload:atual', 'start');

            $data['customer'] = $this->uploadCustomers();
            $data['order'] = $this->uploadOrders();

            $this->setLog('sync:upload:atual', serialize($data));
            $this->setLog('sync:upload:atual', 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    private function uploadCustomers()
    {
        try {

            $config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());

            $itemsToSync = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Customer')
                ->select('obj')
                ->from('Model\Entity\Customer','obj')
                ->where('obj.sync = 0')
                ->getQuery()->getResult();

            $listItensById = array();

            foreach ($itemsLocal as $itemLocal) {
                try {
                    $codeUser = '';
                    $userCustomers = $itemLocal->getUserCustomers();
                    if (count($userCustomers) > 0) {
                        foreach ($userCustomers as $userCustomer) {
                            if (is_object($userCustomer->getUser()) && $userCustomer->getUser()->getCode() != '') {
                                $codeUser = $userCustomer->getUser()->getCode();
                                break;
                            }
                        }
                    }

                    if (
                        $itemLocal->getDocumentNumber() !== null && $itemLocal->getDocumentNumber() != '' &&
                        $itemLocal->getCustomerType() !== null && $itemLocal->getCustomerType() != ''
                    ) {

                        $listItensById[$itemLocal->getId()] = $itemLocal;

                        $tipoPessoa = ucfirst(substr($itemLocal->getCustomerType(), 1, 1));

                        //$itemLocal = new \Model\Entity\Customer();

                        $objSend = array(
                            "id" => $itemLocal->getId(),
                            "nome_cadastro" => $this->removeAccent(substr(($tipoPessoa == 'F' ? $itemLocal->getName() : $itemLocal->getCompanyName()), 0, 49)),
                            "apelido" =>  $this->removeAccent(substr($itemLocal->getName(), 0, 29)),
                            "tipo_fj" => $this->removeAccent($tipoPessoa),
                            "cpf_cnpj" => ($itemLocal->getDocumentNumber() != '' ? preg_replace("/\D/","",$itemLocal->getDocumentNumber()) : ''),
                            "rg_ie" => ($tipoPessoa == 'F' ? preg_replace("/\D/","",$itemLocal->getSecondaryDocumentNumber()) : preg_replace("/\D/","",$itemLocal->getSecondaryDocumentNumber())),
                            "cidade" => $this->removeAccent(substr($itemLocal->getCity(), 0, 59)),
                            "uf" => $this->removeAccent(substr($itemLocal->getState(), 0, 2)),
                            "cep" => ($itemLocal->getZip() != '' ? preg_replace("/\D/","",$itemLocal->getZip()) : ''),
                            "endereco" => $this->removeAccent(substr($itemLocal->getAddress(), 0, 69)),
                            "bairro" => $this->removeAccent(substr($itemLocal->getNeighbourhood(), 0, 29)),
                            "numero" => preg_replace("/\D/","",$itemLocal->getAddressNumber()),
                            "fone" => ($itemLocal->getPhonePrimary() == '' || $itemLocal->getPhonePrimary() == null ? '' : preg_replace("/\D/","",$itemLocal->getPhonePrimary())),
                            "fone_2" => ($itemLocal->getPhoneSecondary() == '' || $itemLocal->getPhoneSecondary() == null ? '' : preg_replace("/\D/","",$itemLocal->getPhoneSecondary())),
                            "email" => ($itemLocal->getEmail() != null && $itemLocal->getEmail() != '' ? $itemLocal->getEmail() : '' ),
                            "cod_vendedor" => $codeUser,
                            "tipo_cadastro" => "C",
                            "cod_situacao" => "A"
                        );

                        if (is_object($config) && $config->getEnablePriceListCustomerFunctionality()) {
                            $objSend["cod_lista_preco"] = (is_object($itemLocal->getPriceList()) && $itemLocal->getPriceList()->getCode() ? $itemLocal->getPriceList()->getCode() : null);
                        }

                        $itemsToSync[] = $objSend;
                    }
                } catch (\Exception $e) {
                    continue;
                }
            }

            if (count($itemsToSync) > 0) {
                foreach ($itemsToSync as $itemToPost) {
                    try {
                        $currentId = $itemToPost['id'];
                        unset($itemToPost['id']);

                        $post = $this->post(self::URL_API_POST_CUSTOMER, $itemToPost);

                        echo "<br />==============================POST CUSTOMER==========================<br />";
                        echo json_encode($itemToPost);
                        echo "<br /><br />------ WEBSERVER ARRAY ------<br />";
                        print_r($post);
                        echo "<br /><br />------ WEBSERVER JSON ------<br />";
                        echo json_encode($post);
                        echo "<br />==============================POST CUSTOMER==========================<br />";

                        if (is_array($post) === false || isset($post['cod_cadastro']) === false || empty($post['cod_cadastro']))
                            throw new \Exception('O campo cliente:cod_cadastro não foi retornado: '.serialize($post));

                        if (isset($listItensById[$currentId]) && is_object($listItensById[$currentId])) {
                            $listItensById[$currentId]->setCode(trim($post['cod_cadastro']));
                            $listItensById[$currentId]->setSync(true);
                            $listItensById[$currentId]->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($listItensById[$currentId]);
                            $this->getEntityManager()->flush();
                        }
                    } catch (\Exception $e) {
                        continue;
                    }
                }
            }

            return true;

        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    private function uploadOrders()
    {
        try {

            $config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());

            $itemsToSync = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Order')
                ->select('obj')
                ->from('Model\Entity\Order','obj')
                ->where('obj.sync = 0')
                ->getQuery()->getResult();

            $listItensById = array();

            foreach ($itemsLocal as $itemLocal) {
                try {
                    if (
                        is_object($itemLocal->getUser()) && $itemLocal->getUser()->getCode() != null && $itemLocal->getUser()->getCode() != '' &&
                        is_object($itemLocal->getCustomer()) && $itemLocal->getCustomer()->getCode() != null && $itemLocal->getCustomer()->getCode() != '' &&
                        is_object($itemLocal->getOrderType()) && $itemLocal->getOrderType()->getCode() != null && $itemLocal->getOrderType()->getCode() != '' && $itemLocal->getOrderType()->getCode() > 0
                    ) {

                        $listItensById[$itemLocal->getId()] = $itemLocal;

                        $itensOrder = array();
                        $itens = $itemLocal->getOrderProducts();
                        if (count($itens) > 0) {
                            foreach($itens as $item){
                                if (
                                    is_object($item->getProduct()) && $item->getProduct()->getCode() != null && $item->getProduct()->getCode() != '' &&
                                    is_object($item->getProduct()->getUnit()) && $item->getProduct()->getUnit()->getCode() != null && $item->getProduct()->getUnit()->getCode() != ''
                                ) {

                                    $fxValores = array();
                                    $fxAmountSum = 0;
                                    if (
                                        is_object($config) && 
                                        $config->getEnableOrderProductDivisionFunctionality() &&
                                        $item->getProduct()->getUseValueWeight()
                                    ) {
                                        $variants = $item->getOrderProductVariants();
                                        if (count($variants) > 0) {
                                            foreach ($variants as $variant) {
                                                $fxValores[] = array(
                                                    "faixa_ini" => (float)$variant->getValueEnd(),
                                                    "faixa_fim" => (float)$variant->getValueIni(),
                                                    "valor_unitario" => (float)$variant->getPrice()
                                                );
                                                $fxAmountSum = $fxAmountSum + ((float)$variant->getValueEnd() * (float)$variant->getValueIni());
                                            }
                                        }
                                    }

                                    $objSend = array(
                                        'cod_produto' => $item->getProduct()->getCode(),
                                        'cod_ref' => 0,
                                        'qtde' => $item->getAmount(),
                                        'valor_unitario' => (float)$item->getPrice(),
                                        'valor_desconto' => (float)$item->getDiscount(),
                                        'valor_liquido' => (float)$item->getTotal(),
                                        'cod_unidade' => (is_object($item->getProduct()) && is_object($item->getProduct()->getUnit()) ? $item->getProduct()->getUnit()->getCode() : '')
                                    );      

                                    if (count($fxValores) > 0) {
                                        $objSend['fxValores'] = $fxValores;
                                    }

                                    if ($item->getAmountUnit() != null && $item->getAmountUnit() > 0 && $item->getAmountUnitCode() != null) {
                                        $objSend['fxValores'] = array();
                                        $objSend['cod_unidade'] = $item->getAmountUnitCode();
                                        $objSend['valor_unitario'] = floatval(number_format( ((float)$item->getPrice() * (float)$item->getAmountUnit()), 2, '.', ''));
                                        $objSend['valor_liquido']  = floatval(number_format( (((float)$item->getPrice() * (float)$item->getAmountUnit()) - (float)$objSend['valor_desconto']), 2, '.', ''));
                                    }

                                    $itensOrder[] = $objSend;
                                }
                            }
                        }

                        $itemsToSync[] = array(
                            "cliente" => array(
                                "cod_cadastro" => (is_object($itemLocal->getCustomer()) ? $itemLocal->getCustomer()->getCode() : ''),
                            ),

                            "perc_desconto1" => ($itemLocal->getDiscountPercent1() !== null ? $itemLocal->getDiscountPercent1() : ''),
                            "perc_desconto2" => ($itemLocal->getDiscountPercent2() !== null ? $itemLocal->getDiscountPercent2() : ''),
                            "perc_desconto3" => ($itemLocal->getDiscountPercent3() !== null ? $itemLocal->getDiscountPercent3() : ''),
                            "perc_desconto4" => ($itemLocal->getDiscountPercent4() !== null ? $itemLocal->getDiscountPercent4() : ''),
                            "perc_desconto5" => ($itemLocal->getDiscountPercent5() !== null ? $itemLocal->getDiscountPercent5() : ''),
                            "valor_total" => $itemLocal->getSubtotal(),
                            "valor_liquido" => $itemLocal->getTotal(),
                            "valor_desconto" => $itemLocal->getDiscount(),

                            "classificacao" => (is_object($itemLocal->getOrderClassification()) ? $itemLocal->getOrderClassification()->getCode() : '' ),
                            "tipo_cliente" => (is_object($itemLocal->getOrderCustomerType()) ? $itemLocal->getOrderCustomerType()->getCode() : '' ),
                            "codicao_pagamento" => (is_object($itemLocal->getPaymentCondition()) ? $itemLocal->getPaymentCondition()->getCode() : '' ),
                            "metodo_cobranca" => (is_object($itemLocal->getPaymentMethod()) ? $itemLocal->getPaymentMethod()->getCode() : '' ),
                            "tipo_mv" => (is_object($itemLocal->getOrderType()) && $itemLocal->getOrderType()->getCode() != '' && $itemLocal->getOrderType()->getCode() != 'NULL' ? $itemLocal->getOrderType()->getCode() : ''),

                            "observacao" => $this->removeAccent($itemLocal->getInfo()),
                            "id" => $itemLocal->getId(),
                            "cod_vendedor" => $itemLocal->getUser()->getCode(),
                            "data_pedido" => $itemLocal->getOrderDate()->format('Y-m-d'),
                            "itens" => $itensOrder
                        );
                    }
                } catch (\Exception $e) {
                    continue;
                }
            }

            if (count($itemsToSync) > 0) {
                foreach ($itemsToSync as $itemToPost) {
                    try {
                        $currentId = $itemToPost['id'];

                        $post = $this->post(self::URL_API_POST_ORDER, $itemToPost);

                        echo "<br />================================POST ORDER===========================<br />";
                        echo json_encode($itemToPost);
                        echo "<br /><br />------ WEBSERVER ARRAY ------<br />";
                        print_r($post);
                        echo "<br /><br />------ WEBSERVER JSON ------<br />";
                        echo json_encode($post);                        
                        echo "<br />================================POST ORDER===========================<br />";

                        if (is_array($post) === false || isset($post['chave_fato']) === false || empty($post['chave_fato']))
                            throw new \Exception('O campo pedido:numero não foi retornado: '.serialize($post));

                        if (isset($listItensById[$currentId]) && is_object($listItensById[$currentId])) {
                            $listItensById[$currentId]->setCode(trim($post['chave_fato']));
                            $listItensById[$currentId]->setSync(true);
                            $listItensById[$currentId]->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($listItensById[$currentId]);
                            $this->getEntityManager()->flush();
                        }
                    } catch (\Exception $e) {
                        continue;
                    }
                }
            }

            return true;

        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    private function checkEnableDownload($string)
    {
        $datetime = new \DateTime();
        //$datetime->sub(new \DateInterval('P'.$this->config->getOrderSyncTime().'D'));
        $datetime->setTime(3, 0, 0);
        $datetime->setTimezone(new \DateTimeZone('America/Sao_Paulo'));

        $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\Log');
        $query->select('obj')
            ->from('Model\Entity\Log','obj')
            ->andWhere('obj.code = :str')
            ->andWhere('obj.created IS NOT NULL')
            ->andWhere('obj.created >= :datetime')
            ->setParameter('str', $string)
            ->setParameter('datetime', $datetime);

        $results = $query->getQuery()->setMaxResults(2)->getResult(); //->setMaxResults(1)

        return count($results) > 0 ? false : true;
    }

    public function downloadAction()
    {
        try{
            $str = 'sync:download:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['group'] = $this->syncGroups(); //(OK)
            $data['product'] = $this->syncProducts(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download2Action()
    {
        try{
            $str = 'sync:download2:atual';
            //if ($this->checkEnableDownload($str) === false) {
            //    $this->setLog($str, 'disable');
            //    throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            //}

            $data = array();

            $this->setLog($str, 'start');

            $data['productImages'] = $this->syncProductsImage(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download3Action()
    {
        try{
            $str = 'sync:download3:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['priceList'] = $this->syncPriceList(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download4Action()
    {
        try{
            $str = 'sync:download4:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['orderType'] = $this->syncOrderType(); //(OK)
            $data['paymentMethod'] = $this->syncPaymentMethod(); //(OK)
            $data['paymentCodition'] = $this->syncPaymentCodition(); //(OK)
            $data['unitAmount'] = $this->syncUnitAmount(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download5Action()
    {
        try{
            $str = 'sync:download5:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['users'] = $this->syncUsers(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download6Action()
    {
        try{
            $str = 'sync:download6:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['customer'] = $this->syncCustomers(); //(OK)

            $this->setLog($str, serialize($data));

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function download7Action()
    {
        try{
            $str = 'sync:download7:atual';
            if ($this->checkEnableDownload($str) === false) {
                $this->setLog($str, 'disable');
                throw new \Exception("A sincronizacao ja foi realizada anteriormente.");
            }

            $data = array();

            $this->setLog($str, 'start');

            $data['financialPending'] = $this->syncFinancialPending(); //(OK)

            $this->setLog($str, serialize($data));
            $this->setLog($str, 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    private function syncGroups()
    {
        try {

            $listServices = array(
                'secao'    => self::URL_API_PRODUCT_GROUP_SECTION,
                'grupo'    => self::URL_API_PRODUCT_GROUP_GROUP,
                'subgrupo' => self::URL_API_PRODUCT_GROUP_SUBGROUP
            );

            foreach ($listServices as $level => $serviceUrl) {

                $apiReturn = $this->get($serviceUrl);

                if (is_array($apiReturn) === false || count($apiReturn) == 0)
                    throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

                $codeUsed = array();

                //-------- Entity Local ---------//
                $itemsLocalList = array();
                $itemsLocal = $this->getEntityManager()
                    ->createQueryBuilder('Model\Entity\Group')
                    ->select('obj')
                    ->from('Model\Entity\Group','obj')
                    ->where('obj.level = :level')
                    ->setParameter('level', $level)
                    ->getQuery()->getResult();
                foreach ($itemsLocal as $itemLocal) {
                    if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                        $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
                }
                $codeUsed['Group'] = array();
                //-------- Entity Local ---------//

                $counter = 0;
                $batchSize = 20;
                $batchList = array();
                foreach ($apiReturn as $itemAPI) {

                    if (isset($itemAPI['cod_'.$level]) === false || empty($itemAPI['cod_'.$level]))
                        continue;

                    if (isset($itemsLocalList[trim($itemAPI['cod_'.$level])])) {
                        if (is_object($itemsLocalList[trim($itemAPI['cod_'.$level])]) === true)
                            $localItemCheck = $itemsLocalList[trim($itemAPI['cod_' . $level])];
                        else
                            continue;
                    } else {
                        $localItemCheck = new \Model\Entity\Group();
                    }

                    $codeUsed['Group'][] = trim($itemAPI['cod_'.$level]);

                    $descriptionKey = $level;
                    $descriptionItem = isset($itemAPI['desc_'.$descriptionKey]) && empty($itemAPI['desc_'.$descriptionKey]) === false ? trim($itemAPI['desc_'.$descriptionKey]) : '';

                    if (
                        $localItemCheck->getDescription() != $descriptionItem ||
                        $localItemCheck->getLevel()       != $level
                        //$localItemCheck->getCode()        != trim($itemAPI['cod_'.$level])
                        //$localItemCheck->getImage()       != trim($itemAPI['imagem'])
                    ) {
                        //$descriptionKey =  $level == 'grupo' ? ucfirst($level) : $level ; //Corrigido
                        $localItemCheck->setDescription($descriptionItem);
                        $localItemCheck->setLevel($level);
                        $localItemCheck->setCode(trim($itemAPI['cod_'.$level]));
                        $localItemCheck->setActive(true);
                        $localItemCheck->setBlocked(false);
                        $localItemCheck->setSync(true);
                        $localItemCheck->setSyncDatetime(new DateTimeBr());

                        if (isset($itemAPI['imagem']) && empty($itemAPI['imagem']) === false)
                            $localItemCheck->setImage(trim($itemAPI['imagem']));

                        $this->getEntityManager()->persist($localItemCheck);
                        $counter++;
                    }

                    //$itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
                    $itemsLocalList[$localItemCheck->getCode()] = true;
                    $batchList[] = $localItemCheck;
                    if ($counter > 0 && ($counter % $batchSize) === 0) {
                        $this->getEntityManager()->flush();
                        if (count($batchList) > 0) {
                            foreach ($batchList as $batchItem) {
                                if (is_object($batchItem)) {
                                    $this->getEntityManager()->detach($batchItem);
                                    unset($batchItem);
                                }
                            }
                            $batchList = null;
                            $batchList = array();
                        }
                    }

                }

                if (count($itemsLocalList) > 0 && is_array($codeUsed['Group']) && count($codeUsed['Group']) > 0) {
                    foreach ($itemsLocalList as $code => $itemLocal) {
                        if (in_array($code, $codeUsed['Group']) == false && is_object($itemLocal)) {
                            $itemLocal->setActive(false);
                            $this->getEntityManager()->persist($itemLocal);
                        }
                    }
                }

                $itemsLocalList = null;

            }

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            return true;

        } catch(\Exception $ex) {
            $this->getEntityManager()->clear();
            return $ex->getMessage(); //false;
        }
    }

    private function syncProducts()
    {
        try {

            $apiReturn = $this->get(self::URL_API_PRODUCT);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Product')
                ->select('obj')
                ->from('Model\Entity\Product','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['Product'] = array();
            //-------- Entity Local ---------//

            //-------- Entity Related ---------//
            $relatedListGroup = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\Group')
                  ->select('obj')
                  ->from('Model\Entity\Group','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    if (
                        $entityItem->getLevel() != null && $entityItem->getLevel() != '' &&
                        $entityItem->getCode() != null && $entityItem->getCode() != ''
                    )
                        $relatedListGroup[trim($entityItem->getLevel())][trim($entityItem->getCode())] = $entityItem;
                }
            }
            //-------- Entity Related ---------//

            //-------- Entity Related ---------//
            $relatedListUnit = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\Unit')
                  ->select('obj')
                  ->from('Model\Entity\Unit','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    if (
                        $entityItem->getCode() != null && $entityItem->getCode() != ''
                    )
                        $relatedListUnit[trim($entityItem->getCode())] = $entityItem;
                }
            }
            //-------- Entity Related ---------//

            $counter = 0;
            $batchSize = 20;
            $batchList = array();
            foreach ($apiReturn as $itemAPI) {

                if (isset($itemAPI['cod_produto']) === false || empty($itemAPI['cod_produto']))
                    continue;

                if (isset($itemsLocalList[trim($itemAPI['cod_produto'])])) {
                    if (is_object($itemsLocalList[trim($itemAPI['cod_produto'])]) === true)
                        $localItemCheck = $itemsLocalList[trim($itemAPI['cod_produto'])];
                    else
                        continue;
                } else {
                    $localItemCheck = new \Model\Entity\Product();
                }

                $codeUsed['Product'][] = trim($itemAPI['cod_produto']);

                $localItemCheck->setCode(trim($itemAPI['cod_produto']));
                $localItemCheck->setName(isset($itemAPI['desc_produto']) && empty($itemAPI['desc_produto']) === false ? trim($itemAPI['desc_produto']) : '');
                $localItemCheck->setDescriptionGrid(isset($itemAPI['desc_grade']) && empty($itemAPI['desc_grade']) === false ? trim($itemAPI['desc_grade']) : '');
                $localItemCheck->setActive(isset($itemAPI['status']) && strtoupper(trim($itemAPI['status'])) == 'A' ? true : false);
                $localItemCheck->setAmountMinimal((double)(isset($itemAPI['qtde_minima']) && empty($itemAPI['qtde_minima']) === false ? trim($itemAPI['qtde_minima']) : '0,00'));

                //$localItemCheck->setReference(isset($itemAPI['cod_ref']) && empty($itemAPI['cod_ref']) === false ? trim($itemAPI['cod_ref']) : '');

                if (isset($itemAPI['cod_Prodfabricante']))
                    $localItemCheck->setReference(isset($itemAPI['cod_Prodfabricante']) && empty($itemAPI['cod_Prodfabricante']) === false ? trim($itemAPI['cod_Prodfabricante']) : '');
                else
                    $localItemCheck->setReference(isset($itemAPI['cod_ref']) && empty($itemAPI['cod_ref']) === false ? trim($itemAPI['cod_ref']) : '');

                if (isset($itemAPI['rotulo']))
                    $localItemCheck->setDescription(isset($itemAPI['rotulo']) && empty($itemAPI['rotulo']) === false ? trim($itemAPI['rotulo']) : '');

                if (isset($itemAPI['ean']))
                    $localItemCheck->setBarcode(trim($itemAPI['ean']));

                //STOCK
                if (
                    isset($itemAPI['stock']) &&
                    empty($itemAPI['stock']) === false
                ) {
                    $localItemCheck->setStock($itemAPI['stock']);
                    $updateCustomer = true;
                }


                if (isset($itemAPI['cod_unidade_pri']))
                    $localItemCheck->setCodeUnitPrimary(trim($itemAPI['cod_unidade_pri']));

                //cod_unidade_pri
                if (isset($itemAPI['cod_unidade_pri']) && empty($itemAPI['cod_unidade_pri']) === false) {
                    $itemToRelated = null;
                    if (isset($relatedListUnit[trim($itemAPI['cod_unidade_pri'])]) === true && is_object($relatedListUnit[trim($itemAPI['cod_unidade_pri'])]) === true) {
                        $itemToRelated = $relatedListUnit[trim($itemAPI['cod_unidade_pri'])];
                    } else {
                        $itemToRelated = new \Model\Entity\Unit();
                        $itemToRelated->setId(trim($itemAPI['cod_unidade_pri']));
                        $itemToRelated->setDescription(trim($itemAPI['cod_unidade_pri']));
                        $itemToRelated->setCode(trim($itemAPI['cod_unidade_pri']));
                        $itemToRelated->setActive(true);
                        $itemToRelated->setSync(true);
                        $itemToRelated->setSyncDatetime(new DateTimeBr());

                        $this->getEntityManager()->persist($itemToRelated);
                    }

                    $relatedListUnit[trim($itemAPI['cod_unidade_pri'])] = $itemToRelated;

                    $localItemCheck->setUnit($itemToRelated);
                }

                //cod_secao
                if (isset($itemAPI['cod_secao']) && empty($itemAPI['cod_secao']) === false && isset($relatedListGroup['secao'][trim($itemAPI['cod_secao'])]) === true && is_object($relatedListGroup['secao'][trim($itemAPI['cod_secao'])]) === true) {
                    $itemToRelated = $relatedListGroup['secao'][trim($itemAPI['cod_secao'])];
                    $localItemCheck->setGroupRelatedByIdGroupPrimary($itemToRelated);
                }

                //cod_grupo
                if (isset($itemAPI['cod_grupo']) && empty($itemAPI['cod_grupo']) === false && isset($relatedListGroup['grupo'][trim($itemAPI['cod_grupo'])]) === true && is_object($relatedListGroup['grupo'][trim($itemAPI['cod_grupo'])]) === true) {
                    $itemToRelated = $relatedListGroup['grupo'][trim($itemAPI['cod_grupo'])];
                    $localItemCheck->setGroupRelatedByIdGroupSecondary($itemToRelated);
                }

                //cod_subgrupo
                if (isset($itemAPI['cod_subgrupo']) && empty($itemAPI['cod_subgrupo']) === false && isset($relatedListGroup['subgrupo'][trim($itemAPI['cod_subgrupo'])]) === true && is_object($relatedListGroup['subgrupo'][trim($itemAPI['cod_subgrupo'])]) === true) {
                    $itemToRelated = $relatedListGroup['subgrupo'][trim($itemAPI['cod_subgrupo'])];
                    $localItemCheck->setGroupRelatedByIdGroupTertiary($itemToRelated);
                }

                //classifica_valorPorPeso
                if (isset($itemAPI['classifica_valorPorPeso']) && empty($itemAPI['classifica_valorPorPeso']) === false) {
                    $localItemCheck->setUseValueWeight((trim($itemAPI['classifica_valorPorPeso']) == 'S' ? true : false));
                } else {
                    $localItemCheck->setUseValueWeight(false);
                }

                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                //$itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
                $itemsLocalList[$localItemCheck->getCode()] = true;
                $batchList[] = $localItemCheck;
                $counter++;
                if ($counter > 0 && ($counter % $batchSize) === 0) {
                    $this->getEntityManager()->flush();
                    if (count($batchList) > 0) {
                        foreach ($batchList as $batchItem) {
                            $this->getEntityManager()->detach($batchItem);
                            unset($batchItem);
                        }
                        $batchList = null;
                        $batchList = array();
                    }

                    //sleep(1);
                    usleep(250000);// para processamento por 1/2 segundo
                }

            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['Product']) && count($codeUsed['Product']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['Product']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            return true;

        } catch(\Exception $ex) {
            $this->getEntityManager()->clear();
            return $ex->getMessage(); //false;
        }
    }

    private function syncProductsImage() {
        try {

            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Product')
                ->select('obj')
                ->from('Model\Entity\Product', 'obj')
                ->andWhere('obj.active = 1')
                ->getQuery()->getResult();

            if (count($itemsLocal) == 0)
                return true;

            $counter = 0;
            $batchSize = 40;
            $batchList = array();

            //-----------------------------//
            if (count($itemsLocal) > 240) {
                $pageTotal = ceil(count($itemsLocal) / 24);
                $page = date('H');
                $keyInit = $page * $pageTotal;
                $keyEnd = ($keyInit + $pageTotal) - 1;
            } else {
                $keyInit = 0;
                $keyEnd = 240;
            }
            //-----------------------------//

            foreach ($itemsLocal as $key => $itemLocal) {

                if ($key < $keyInit || $key > $keyEnd)
                    continue;

                try {

                    if ($itemLocal->getCode() == null || trim($itemLocal->getCode()) == '') // || ($itemLocal->getImage() != null && trim($itemLocal->getImage()) != '')
                        continue;

                    $ref = "0"; //($itemLocal->getReference() == null || $itemLocal->getReference() == '' ? '0' : $itemLocal->getReference());
                    $url = str_replace(array("{cod_produto}","{cod_ref}"), array(trim($itemLocal->getCode()),$ref), self::URL_API_PRODUCT_IMAGE);

                    $imageCode = $this->get($url, false, 5);

                    if (strstr($imageCode, 'message') !== false)
                        continue;

                    $imageCode = str_replace('"', '', $imageCode);

                    $itemLocal->setFileResource($imageCode, true);

                    $this->getEntityManager()->persist($itemLocal);

                    $batchList[] = $itemLocal;
                    $counter++;
                    if ($counter > 0 && ($counter % $batchSize) === 0) {
                        $this->getEntityManager()->flush();
                        if (count($batchList) > 0) {
                            foreach ($batchList as $batchItem) {
                                $this->getEntityManager()->detach($batchItem);
                                unset($batchItem);
                            }
                            $batchList = null;
                            $batchList = array();
                        }
                        $this->setLog('syncproductsimage', 'batch-'.$counter);

                        //sleep(1);
                        usleep(250000);// para processamento por 1/2 segundo
                    }

                } catch (\Exception $e) {
                    continue;
                }

            }

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            return true;

        } catch (\Exception $e) {
            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();
            return $e->getMessage();
        }
    }

    private function syncPriceList()
    {
        try {

            $this->setLog('syncpricelist', 'step1');

            $apiReturn = $this->get(self::URL_API_PRICE_LIST);

            $this->setLog('syncpricelist', 'step2');

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\PriceList')
                ->select('obj')
                ->from('Model\Entity\PriceList','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['PriceList'] = array();
            //-------- Entity Local ---------//

            //-------- Entity Related ---------//
            $relatedList = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\Product')
                  ->select('obj')
                  ->from('Model\Entity\Product','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    if ($entityItem->getCode() != '')
                        $relatedList[trim($entityItem->getCode())] = $entityItem;
                }
            }
            //-------- Entity Related ---------//

            //-------- Sub Entity Local ---------//
            $localItemCheckSubItens = array();
            $subEntitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\PriceListProduct')
                  ->select('obj')
                  ->from('Model\Entity\PriceListProduct','obj')
                  ->getQuery()->getResult();
            if (count($subEntitiesToRelate) > 0) {
                foreach ($subEntitiesToRelate as $subEntityItem) {
                    if (is_object($subEntityItem->getPriceList()) && $subEntityItem->getPriceList()->getCode() != '' && is_object($subEntityItem->getProduct()) && $subEntityItem->getProduct()->getCode() != '')
                        $localItemCheckSubItens[trim($subEntityItem->getPriceList()->getCode())][trim($subEntityItem->getProduct()->getCode())] = $subEntityItem;
                }
            }
            $codeUsed['PriceListProduct'] = array();
            //-------- Sub Entity Local ---------//

            $this->setLog('syncpricelist', 'step3');

            $bashCount = 0;

            foreach ($apiReturn as $itemAPI) {

                if (isset($itemAPI['cod_lista']) === false || empty($itemAPI['cod_lista']))
                    continue;

                $localItemCheck = null;

                $itemAPI['cod_lista'] = trim($itemAPI['cod_lista']);

                if (isset($itemsLocalList[$itemAPI['cod_lista']]) && is_object($itemsLocalList[$itemAPI['cod_lista']]) === true) {
                    $localItemCheck = $itemsLocalList[$itemAPI['cod_lista']];
                } else {
                    $localItemCheck = new \Model\Entity\PriceList();
                }

                $descriptionItem = isset($itemAPI['desc_lista']) && empty($itemAPI['desc_lista']) === false ? trim($itemAPI['desc_lista']) : '';
                if (
                    $localItemCheck->getDescription() != $descriptionItem
                ) {
                    $localItemCheck->setDescription($descriptionItem);
                    $localItemCheck->setCode(trim($itemAPI['cod_lista']));
                    $localItemCheck->setActive(true);
                    $localItemCheck->setSync(true);
                    $localItemCheck->setSyncDatetime(new DateTimeBr());
                }

                $localItemCheck->setActive(true);
                $this->getEntityManager()->persist($localItemCheck);

                $codeUsed['PriceList'][] = trim($itemAPI['cod_lista']);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;

                if (isset($itemAPI['itens']) && count($itemAPI['itens']) > 0) {
                    $counter = 0;
                    $batchSize = 60;
                    $batchList = array();
                    foreach ($itemAPI['itens'] as $item) {

                        if (isset($item['cod_produto']) === false || isset($item['preco']) === false || isset($relatedList[trim($item['cod_produto'])]) === false || is_object($relatedList[trim($item['cod_produto'])]) === false)
                            continue;

                        $item['cod_produto'] = trim($item['cod_produto']);

                        $subItem = null;
                        if (isset($localItemCheckSubItens[$itemAPI['cod_lista']][$item['cod_produto']])) {
                            if (is_object($localItemCheckSubItens[$itemAPI['cod_lista']][$item['cod_produto']]))
                                $subItem = $localItemCheckSubItens[$itemAPI['cod_lista']][$item['cod_produto']];
                            else
                                continue;
                        } else {
                            $subItem = new \Model\Entity\PriceListProduct();
                        }

                        $codeUsed['PriceListProduct'][$itemAPI['cod_lista']][$item['cod_produto']] = true;

                        $priceItem = round((isset($item['preco']) && is_null($item['preco']) === false ? floatval(trim($item['preco'])) : 0), 2);
                        $priceMinItem = round((isset($item['preco_minimo']) && is_null($item['preco_minimo']) === false && floatval(trim($item['preco_minimo'])) > 0 ? floatval(trim($item['preco_minimo'])) : 0.01), 2);

                        if (round($subItem->getPrice(), 2) != $priceItem || round($subItem->getPriceMinimum(), 2) != $priceMinItem) { //Test5

                            $subItem->setPriceChangeDate(new DateTimeBr());

                            //$subItem->setCode();
                            //$subItem->setReferenceProduct();
                            $subItem->setCodeProduct($item['cod_produto']);
                            $subItem->setPriceList($localItemCheck);
                            $subItem->setProduct($relatedList[$item['cod_produto']]);
                            $subItem->setActive(true);
                            $subItem->setSync(true);
                            $subItem->setSyncDatetime(new DateTimeBr());

                            $subItem->setPrice($priceItem);
                            $subItem->setPriceMinimum($priceMinItem);

                            $this->getEntityManager()->persist($subItem);

                            $batchList[] = $subItem;
                            $counter++;
                        }

                        $localItemCheckSubItens[$itemAPI['cod_lista']][$item['cod_produto']] = true;

                        if ($counter > 0 && ($counter % $batchSize) === 0) {

                            $bashCount++;

                            $this->setLog('syncpricelist', 'step4-'.$bashCount);

                            $this->getEntityManager()->flush();
                            if (count($batchList) > 0) {
                                foreach ($batchList as $batchItem) {
                                    $this->getEntityManager()->detach($batchItem);
                                    unset($batchItem);
                                }
                                $batchList = null;
                                $batchList = array();
                            }

                            //sleep(1);
                            usleep(550000);// para processamento por 1/2 segundo
                        }
                    }
                }
            }

            $this->setLog('syncpricelist', 'step5');

            if (count($itemsLocalList) > 0 && is_array($codeUsed['PriceList']) && count($codeUsed['PriceList']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['PriceList']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            if (count($localItemCheckSubItens) > 0 && is_array($codeUsed['PriceListProduct']) && count($codeUsed['PriceListProduct']) > 0) {
                foreach ($localItemCheckSubItens as $codeList => $itemLocalList) {
                    if (count($itemLocalList) > 0) {
                        foreach ($itemLocalList as $codeProduct => $itemLocalProduct) {
                            if (isset($codeUsed['PriceListProduct'][$codeList][$codeProduct]) === false) {
                                $itemLocalProduct->setActive(false);
                                $this->getEntityManager()->persist($itemLocalProduct);
                            }
                        }
                    }
                }
            }

            $localItemCheckSubItens = null;

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            $this->setLog('syncpricelist', 'step6');

            return true;

        } catch(\Exception $ex) {

            $this->setLog('syncpricelist', 'step7');

            $this->getEntityManager()->clear();
            return $ex->getMessage();
        }
    }

    private function syncUsers()
    {
        try {

            $apiReturn = $this->get(self::URL_API_USERS);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\User')
                ->select('obj')
                ->from('Model\Entity\User','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['User'] = array();
            //-------- Entity Local ---------//

            //-------- Entity Related ---------//
            $relatedListPriceList = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\PriceList')
                  ->select('obj')
                  ->from('Model\Entity\PriceList','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    if ($entityItem->getCode() != '')
                        $relatedListPriceList[trim($entityItem->getCode())] = $entityItem;
                }
            }
            //-------- Entity Related ---------//

            //-------- Entity Related ---------//
            $relatedListOrderType = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\OrderType')
                  ->select('obj')
                  ->from('Model\Entity\OrderType','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    //if ($entityItem->getCode() != '')
                        $relatedListOrderType[trim($entityItem->getId())] = $entityItem;
                }
            }
            //-------- Entity Related ---------//

            //-------- Sub Entity Local ---------//
            $localItemCheckSubItens = array();
            $subEntitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\UserPriceList')
                  ->select('obj')
                  ->from('Model\Entity\UserPriceList','obj')
                  ->getQuery()->getResult();
            if (count($subEntitiesToRelate) > 0) {
                foreach ($subEntitiesToRelate as $subEntityItem) {
                    if (
                      is_object($subEntityItem->getPriceList()) && $subEntityItem->getPriceList()->getCode() != ''
                      && is_object($subEntityItem->getUser()) && $subEntityItem->getUser()->getCode() != ''
                      && is_object($subEntityItem->getOrderType()) && $subEntityItem->getOrderType()->getCode() != ''
                    )
                        $localItemCheckSubItens[trim($subEntityItem->getPriceList()->getCode())]
                                               [trim($subEntityItem->getUser()->getCode())]
                                               [trim($subEntityItem->getOrderType()->getId())] = $subEntityItem;
                }
            }
            //-------- Sub Entity Local ---------//

            foreach ($apiReturn as $itemAPI) {

                if (isset($itemAPI['cod_vendedor']) === false || empty($itemAPI['cod_vendedor']))
                    continue;

                $itemAPI['cod_vendedor'] = trim($itemAPI['cod_vendedor']);

                if (isset($itemsLocalList[$itemAPI['cod_vendedor']]) && is_object($itemsLocalList[$itemAPI['cod_vendedor']]) === true) {
                    $localItemCheck = $itemsLocalList[$itemAPI['cod_vendedor']];
                } else {
                    $localItemCheck = new \Model\Entity\User();
                }

                $codeUsed['User'][] = trim($itemAPI['cod_vendedor']);

                $localItemCheck->setName(isset($itemAPI['nome_vendedor']) && empty($itemAPI['nome_vendedor']) === false ? trim($itemAPI['nome_vendedor']) : '');
                $localItemCheck->setCode($itemAPI['cod_vendedor']);
                $localItemCheck->setDiscountMaximum((double)(isset($itemAPI['perc_desconto']) && empty($itemAPI['perc_desconto']) === false ? trim($itemAPI['perc_desconto']) : '0,00'));
                $localItemCheck->setActive(isset($itemAPI['status']) && strtoupper(trim($itemAPI['status'])) == 'A' ? true : false);

                if (isset($itemAPI['login']) && empty($itemAPI['login']) === false)
                    $localItemCheck->setUsername(trim($itemAPI['login']));
                else if ((int)$localItemCheck->getId() <= 0)
                    $localItemCheck->setUsername($itemAPI['cod_vendedor']);

                if (isset($itemAPI['senha']) && empty($itemAPI['senha']) === false)
                    $localItemCheck->setPassword($itemAPI['senha']);
                else if ((int)$localItemCheck->getId() <= 0)
                    $localItemCheck->setPassword($itemAPI['cod_vendedor']);

                $localItemCheck->setActive(true);
                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;

                //$counter = 0;
                //$batchSize = 40;
                //$batchList = array();
                $lists = array(
                  '2' => "cod_lista_pedido",
                  '1' => "cod_lista_orcamento",
                  '3' => "cod_lista_brinde",
                  '4' => "cod_lista_amostra",
                  '5' => "cod_lista_expositor",
                  '6' => "cod_lista_troca",
                  '7' => "cod_lista_promocao"
                );
                foreach ($lists as $idOrderType => $listKey) {
                    if (
                      isset($itemAPI[$listKey]) && trim($itemAPI[$listKey]) != ''
                      && isset($relatedListPriceList[trim($itemAPI[$listKey])]) && is_object($relatedListPriceList[trim($itemAPI[$listKey])])
                      && isset($relatedListOrderType[$idOrderType]) && is_object($relatedListOrderType[$idOrderType])
                    ) {

                        if (isset($localItemCheckSubItens[$itemAPI[$listKey]][trim($localItemCheck->getCode())][trim($idOrderType)])) {
                            if (is_object($localItemCheckSubItens[$itemAPI[$listKey]][trim($localItemCheck->getCode())][trim($idOrderType)]))
                                $subItem = $localItemCheckSubItens[$itemAPI[$listKey]][trim($localItemCheck->getCode())][trim($idOrderType)];
                            else
                                continue;
                        } else {
                            $subItem = new \Model\Entity\UserPriceList();
                        }

                        //$subItem->setCode();
                        $subItem->setUser($localItemCheck);
                        $subItem->setPriceList($relatedListPriceList[trim($itemAPI[$listKey])]);
                        $subItem->setOrderType($relatedListOrderType[$idOrderType]);
                        $subItem->setActive(true);
                        $subItem->setSync(true);
                        $subItem->setSyncDatetime(new DateTimeBr());

                        $this->getEntityManager()->persist($subItem);

                        //$localItemCheckSubItens[$itemAPI[$listKey]][trim($localItemCheck->getCode())][trim($idOrderType)] = $subItem;
                        $localItemCheckSubItens[$itemAPI[$listKey]][trim($localItemCheck->getCode())][trim($idOrderType)] = true;
                        /*
                        $batchList[] = $subItem;
                        $counter++;
                        if ($counter > 0 && ($counter % $batchSize) === 0) {
                            $this->getEntityManager()->flush();
                            if (count($batchList) > 0) {
                                foreach ($batchList as $batchItem) {
                                    $this->getEntityManager()->detach($batchItem);
                                    unset($batchItem);
                                }
                                $batchList = null;
                                $batchList = array();
                            }
                        }
                        */
                    }
                }

            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['User']) && count($codeUsed['User']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['User']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            return true;

        } catch(\Exception $ex) {
            $this->getEntityManager()->clear();
            return $ex->getMessage();
        }
    }

    private function syncCustomers()
    {
        try {

            $apiReturn = $this->get(self::URL_API_CUSTOMER);

            $this->setLog('sync:customers:atual', 'after api');

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Customer')
                ->select('obj')
                ->from('Model\Entity\Customer','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['Customer'] = array();
            //-------- Entity Local ---------//

            //-------- Entity Related ---------//
            $relatedListUser = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\User')
                  //->select('obj')
                  ->select(array('obj.id', 'obj.code'))
                  ->from('Model\Entity\User','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    //if ($entityItem->getCode() != '')
                    if (
                        isset($entityItem['id']) && empty($entityItem['id']) === false &&
                        isset($entityItem['code']) && empty($entityItem['code']) === false
                    )
                        $relatedListUser[trim($entityItem['code'])] = $entityItem['id'];
                }
            }
            //-------- Entity Related ---------//

            //-------- Entity Related ---------//
            $relatedListPriceList = array();
            $entitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\PriceList')
                  ->select('obj')
                  ->from('Model\Entity\PriceList','obj')
                  ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $itemLocal) {
                    if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                        $relatedListPriceList[trim($itemLocal->getCode())] = $itemLocal;
                }
            }
            //-------- Entity Related ---------//

            //-------- Sub Entity Local ---------//
            $localItemCheckSubItens = array();
            $subEntitiesToRelate = $this->getEntityManager()
                  ->createQueryBuilder('Model\Entity\UserCustomer')
                  //->select('obj')
                  ->select(array('obj.id','cus.code AS codeCustomer','usr.code AS codeUser','obj.active'))
                  ->from('Model\Entity\UserCustomer','obj')
                  ->innerJoin('obj.customer','cus')
                  ->innerJoin('obj.user','usr')
                  ->getQuery()->getResult();
            if (count($subEntitiesToRelate) > 0) {
                foreach ($subEntitiesToRelate as $subEntityItem) {
                    /*
                    if (
                      is_object($subEntityItem->getCustomer()) && $subEntityItem->getCustomer()->getCode() != ''
                      && is_object($subEntityItem->getUser()) && $subEntityItem->getUser()->getCode() != ''
                    )
                        $localItemCheckSubItens[trim($subEntityItem->getCustomer()->getCode())]
                                               [trim($subEntityItem->getUser()->getCode())] = $subEntityItem;
                   */
                    if (
                        isset($subEntityItem['id']) && empty($subEntityItem['id']) === false &&
                        isset($subEntityItem['codeCustomer']) && empty($subEntityItem['codeCustomer']) === false &&
                        isset($subEntityItem['codeUser']) && empty($subEntityItem['codeUser']) === false
                    )
                        $localItemCheckSubItens[trim($subEntityItem['codeCustomer'])]
                                               [trim($subEntityItem['codeUser'])] = $subEntityItem;
                }
            }
            $codeUsed['UserCustomer'] = array();
            //-------- Sub Entity Local ---------//

            $this->setLog('sync:customers:atual', 'after db');
            $logCounter = 0;

            $counter = 0;
            $batchSize = 30;
            $batchList = array();
            foreach ($apiReturn as $itemAPI) {
                if (isset($itemAPI['cod_cadastro']) === false || empty($itemAPI['cod_cadastro']))
                    continue;

                $itemAPI['cod_cadastro'] = trim($itemAPI['cod_cadastro']);

                $itemAPI['cod_vendedor'] = isset($itemAPI['cod_vendedor']) ? trim($itemAPI['cod_vendedor']) : '' ;

                $objPriceList = null;
                if (isset($itemAPI['cod_lista_preco']) && !empty($itemAPI['cod_lista_preco']) && isset($relatedListPriceList[trim($itemAPI['cod_lista_preco'])])) {
                    $objPriceList = $relatedListPriceList[trim($itemAPI['cod_lista_preco'])];
                }                

                $updateCustomer = false;
                if (isset($itemsLocalList[$itemAPI['cod_cadastro']])) {
                    if (is_object($itemsLocalList[$itemAPI['cod_cadastro']]) === true)
                        $localItemCheck = $itemsLocalList[$itemAPI['cod_cadastro']];
                    else
                        continue;
                } else {
                    $localItemCheck = new \Model\Entity\Customer();

                    $localItemCheck->setName(isset($itemAPI['apelido']) && empty($itemAPI['apelido']) === false ? trim($itemAPI['apelido']) : '');
                    $localItemCheck->setCompanyName(isset($itemAPI['nome_cadastro']) && empty($itemAPI['nome_cadastro']) === false ? trim($itemAPI['nome_cadastro']) : '');
                    $localItemCheck->setCode(trim($itemAPI['cod_cadastro']));
                    //$localItemCheck->setNickname(isset($itemAPI['apelido']) && empty($itemAPI['apelido']) === false ? trim($itemAPI['apelido']) : '');
                    $localItemCheck->setCustomerType(isset($itemAPI['tipo_fj']) && strtolower($itemAPI['tipo_fj']) == 'j' ? 'pj' : 'pf');
                    $localItemCheck->setDocumentNumber(isset($itemAPI['cpf_cnpj']) && empty($itemAPI['cpf_cnpj']) === false ? trim($itemAPI['cpf_cnpj']) : '');
                    $localItemCheck->setSecondaryDocumentNumber(isset($itemAPI['rg_ie']) && empty($itemAPI['rg_ie']) === false ? trim($itemAPI['rg_ie']) : '');
                    $localItemCheck->setCity(isset($itemAPI['cidade']) && empty($itemAPI['cidade']) === false ? trim($itemAPI['cidade']) : '');
                    $localItemCheck->setState(isset($itemAPI['uf']) && empty($itemAPI['uf']) === false ? trim($itemAPI['uf']) : '');
                    $localItemCheck->setZip(isset($itemAPI['cep']) && empty($itemAPI['cep']) === false ? trim($itemAPI['cep']) : '');
                    $localItemCheck->setAddress(isset($itemAPI['endereco']) && empty($itemAPI['endereco']) === false ? trim($itemAPI['endereco']) : '');
                    $localItemCheck->setNeighbourhood(isset($itemAPI['bairro']) && empty($itemAPI['bairro']) === false ? trim($itemAPI['bairro']) : '');
                    $localItemCheck->setAddressNumber(isset($itemAPI['numero']) && empty($itemAPI['numero']) === false ? trim($itemAPI['numero']) : '');
                    $localItemCheck->setPhonePrimary(isset($itemAPI['fone']) && empty($itemAPI['fone']) === false ? trim($itemAPI['fone']) : '');
                    $localItemCheck->setActive(isset($itemAPI['cod_situacao']) && trim($itemAPI['cod_situacao']) == 'I' ? false : true);
                    $localItemCheck->setBlocked(isset($itemAPI['cod_situacao']) && trim($itemAPI['cod_situacao']) == 'B' ? true : false);
                    $localItemCheck->setSync(true);
                    $localItemCheck->setSyncDatetime(new DateTimeBr());
                    $localItemCheck->setPriceList($objPriceList);
                    $localItemCheck->setRamoAtividade($objRamoAtividade);

                    $updateCustomer = true;
                }

                //CUSTOMER PRICE LIST
                if (
                    is_object($objPriceList) && 
                    (
                        $updateCustomer === false || 
                        $localItemCheck->setPriceList() == null || 
                        (is_object($localItemCheck->setPriceList()) && $objPriceList->getId() != $localItemCheck->setPriceList()->getId())
                    )
                ) {
                    $localItemCheck->setPriceList($objPriceList);
                    $updateCustomer = true;
                }

                //LAST ORDER DATE
                if (
                    isset($itemAPI['data_ultima_compra']) &&
                    empty($itemAPI['data_ultima_compra']) === false &&
                    preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1]).*$/", trim($itemAPI['data_ultima_compra']))
                ) {

                    $auxDate = \Commons\Util\DateTimeBr::createFromFormat("Y-m-d", substr(trim($itemAPI['data_ultima_compra']), 0, 10));

                    if (
                        is_object($localItemCheck->getLastOrderDate()) === false ||
                        $localItemCheck->getLastOrderDate()->format("Ymd") != $auxDate->format("Ymd")
                    ) {
                        $localItemCheck->setLastOrderDate($auxDate); //2014-02-12T00:00:00
                        $updateCustomer = true;
                    }
                }

                //EMAIL
                if (
                    isset($itemAPI['email']) &&
                    empty($itemAPI['email']) === false &&
                    (
                        $localItemCheck->getEmail() == null ||
                        $localItemCheck->getEmail() == '' ||
                        $localItemCheck->getEmail() != trim($itemAPI['email'])
                    )
                ) {
                    $localItemCheck->setEmail(trim($itemAPI['email']));
                    $updateCustomer = true;
                }

                //PHONE
                if (
                    isset($itemAPI['fone']) &&
                    empty($itemAPI['fone']) === false &&
                    (
                        $localItemCheck->getPhonePrimary() == null ||
                        $localItemCheck->getPhonePrimary() == '' ||
                        preg_replace("/\D/","",$localItemCheck->getPhonePrimary()) != preg_replace("/\D/","",$itemAPI['fone'])
                    )
                ) {
                    $localItemCheck->setPhonePrimary(trim($itemAPI['fone']));
                    $updateCustomer = true;
                }

                //PHONE 2
                if (
                    isset($itemAPI['fone_2']) &&
                    empty($itemAPI['fone_2']) === false &&
                    (
                        $localItemCheck->getPhoneSecondary() == null ||
                        $localItemCheck->getPhoneSecondary() == '' ||
                        preg_replace("/\D/","",$localItemCheck->getPhoneSecondary()) != preg_replace("/\D/","",$itemAPI['fone_2'])
                    )
                ) {
                    $localItemCheck->setPhoneSecondary(trim($itemAPI['fone_2']));
                    $updateCustomer = true;
                }


                //RAMO ATIVIDADE
                if (
                    isset($itemAPI['ramo_atividade']) &&
                    empty($itemAPI['ramo_atividade']) === false
                ) {
                    $localItemCheck->setRamoAtividade($itemAPI['ramo_atividade']);
                    $updateCustomer = true;
                }


                //SITUATION
                if (
                    isset($itemAPI['cod_situacao']) &&
                    empty($itemAPI['cod_situacao']) === false &&
                    (
                        (trim($itemAPI['cod_situacao']) == 'I' && $localItemCheck->getActive()) ||
                        (trim($itemAPI['cod_situacao']) == 'A' && !$localItemCheck->getActive()) ||
                        (trim($itemAPI['cod_situacao']) == 'B' && !$localItemCheck->getBlocked())
                    )
                ) {
                    $localItemCheck->setActive(isset($itemAPI['cod_situacao']) && trim($itemAPI['cod_situacao']) == 'I' ? false : true);
                    $localItemCheck->setBlocked(isset($itemAPI['cod_situacao']) && trim($itemAPI['cod_situacao']) == 'B' ? true : false);
                    $updateCustomer = true;
                }

                if ($updateCustomer === true) {
                    $this->getEntityManager()->persist($localItemCheck);
                    $batchList[] = $localItemCheck;
                }

                $codeUsed['Customer'][] = trim($itemAPI['cod_cadastro']);

                if (
                    isset($itemAPI['cod_vendedor'])  && empty($itemAPI['cod_vendedor']) === false
                    && isset($relatedListUser[$itemAPI['cod_vendedor']]) && $relatedListUser[$itemAPI['cod_vendedor']] > 0
                ) {

                    if (
                        isset($localItemCheckSubItens[$localItemCheck->getCode()])
                        && isset($localItemCheckSubItens[$localItemCheck->getCode()][$itemAPI['cod_vendedor']])
                    ) {
                        if (isset($localItemCheckSubItens[$localItemCheck->getCode()][$itemAPI['cod_vendedor']]))
                            $subItem = $localItemCheckSubItens[$localItemCheck->getCode()][$itemAPI['cod_vendedor']];
                        else
                            continue;
                    } else {

                        $relatedUserEntity = $this->getEntityManager()->getRepository('Model\\Entity\\User')->find($relatedListUser[$itemAPI['cod_vendedor']]);
                        if (is_object($relatedUserEntity) === false)
                            continue;

                        $subItem = new \Model\Entity\UserCustomer();

                        //$subItem->setCode();
                        $subItem->setCustomer($localItemCheck);
                        $subItem->setUser($relatedUserEntity);
                        $subItem->setActive(true);
                        $subItem->setSync(true);
                        $subItem->setSyncDatetime(new DateTimeBr());

                        $this->getEntityManager()->persist($subItem);

                        $batchList[] = $subItem;
                    }

                    $codeUsed['UserCustomer'][$localItemCheck->getCode()][$itemAPI['cod_vendedor']] = true;

                    $localItemCheckSubItens[$localItemCheck->getCode()][$itemAPI['cod_vendedor']] = true;

                } else {
                    //Do nothing
                }               

                $itemsLocalList[$localItemCheck->getCode()] = true;
                $counter++;

                if ($counter > 0 && ($counter % $batchSize) === 0) {
                    $this->getEntityManager()->flush();
                    if (count($batchList) > 0) {
                        foreach ($batchList as $batchItem) {
                            $this->getEntityManager()->detach($batchItem);
                            unset($batchItem);
                        }
                        $batchList = null;
                        $batchList = array();
                    }

                    $logCounter++;
                    $this->setLog('sync:customers:atual', 'after batch - '.$logCounter);

                    //sleep(1);
                    //usleep(100000);// para processamento por 1/2 segundo
                    //usleep(500000);// para processamento por 1/2 segundo
                }
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['Customer']) && count($codeUsed['Customer']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['Customer']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            if (count($localItemCheckSubItens) > 0 && is_array($codeUsed['UserCustomer']) && count($codeUsed['UserCustomer']) > 0) {
                foreach ($localItemCheckSubItens as $codeCustomer => $usersList) {
                    if (count($usersList) > 0) {
                        foreach ($usersList as $codeUser => $itemLocalProduct) {
                            if (isset($codeUsed['UserCustomer'][$codeCustomer][$codeUser]) === false) {
                                $itemLocalProduct = $this->getEntityManager()->getRepository('Model\\Entity\\UserCustomer')->find($itemLocalProduct['id']);
                                if (is_object($itemLocalProduct) === false)
                                    continue;
                                $itemLocalProduct->setActive(false);
                                $this->getEntityManager()->persist($itemLocalProduct);
                            }
                        }
                    }
                }
            }

            $localItemCheckSubItens = null;

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            return true;

        } catch(\Exception $ex) {
            $this->getEntityManager()->clear();
            return $ex->getMessage();
        }
    }

    private function syncFinancialPending()
    {
        try {

            $this->setLog('syncFinancialPending', 'start');

            $apiReturn = $this->get(self::URL_API_FINANCIAL_PENDING);

            $this->setLog('syncFinancialPending', 'data');

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\FinancialPending')
                ->select('obj')
                ->from('Model\Entity\FinancialPending','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['FinancialPending'] = array();
            //-------- Entity Local ---------//

            //-------- Entity Related ---------//
            $relatedListCustomer = array();
            $entitiesToRelate = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Customer')
                //->select('obj')
                ->select(array('obj.id','obj.code'))
                ->from('Model\Entity\Customer','obj')
                ->andWhere('obj.active = 1')
                ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    //if ($entityItem->getCode() != '')
                        //$relatedListCustomer[trim($entityItem->getCode())] = $entityItem['id'];
                    if (
                        isset($entityItem['id']) && empty($entityItem['id']) === false &&
                        isset($entityItem['code']) && empty($entityItem['code']) === false
                    )
                        $relatedListCustomer[trim($entityItem['code'])] = trim($entityItem['id']);
                }
            }
            //-------- Entity Related ---------//

            //-------- Entity Related ---------//
            $relatedListUser = array();
            $entitiesToRelate = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\User')
                //->select('obj')
                ->select(array('obj.id','obj.code'))
                ->from('Model\Entity\User','obj')
                ->getQuery()->getResult();
            if (count($entitiesToRelate) > 0) {
                foreach ($entitiesToRelate as $entityItem) {
                    //if ($entityItem->getCode() != '')
                    //    $relatedListUser[trim($entityItem->getCode())] = $entityItem;
                    if (
                        isset($entityItem['id']) && empty($entityItem['id']) === false &&
                        isset($entityItem['code']) && empty($entityItem['code']) === false
                    )
                        $relatedListUser[trim($entityItem['code'])] = trim($entityItem['id']);
                }
            }
            //-------- Entity Related ---------//

            $this->setLog('syncFinancialPending', 'database');

            $counter = 0;
            $batchSize = 20;
            $batchList = array();
            foreach ($apiReturn as $itemAPI) {

                if (
                    isset($itemAPI['chave_Fato']) === false || empty($itemAPI['chave_Fato'])
                    || isset($itemAPI['cod_cliente']) === false || empty($itemAPI['cod_cliente'])
                    || isset($itemAPI['valor_titulo']) === false || empty($itemAPI['valor_titulo'])
                    || isset($relatedListCustomer[trim($itemAPI['cod_cliente'])]) === false //|| is_object($relatedListCustomer[trim($itemAPI['cod_cliente'])]) === false
                )
                    continue;

                $itemAPI['chave_fato'] = trim($itemAPI['chave_Fato']);
                $itemAPI['cod_vendedor'] = isset($itemAPI['cod_vendedor']) && empty($itemAPI['cod_vendedor']) === false ? trim($itemAPI['cod_vendedor']) : '';

                if (isset($itemsLocalList[$itemAPI['chave_fato']])) {
                    if (is_object($itemsLocalList[$itemAPI['chave_fato']]) === true)
                        $localItemCheck = $itemsLocalList[$itemAPI['chave_fato']];
                    else
                        continue;
                } else {
                    $localItemCheck = new \Model\Entity\FinancialPending();
                }

                $codeUsed['FinancialPending'][] = trim($itemAPI['chave_fato']);

                $auxCustomerId = $relatedListCustomer[trim($itemAPI['cod_cliente'])];
                $auxUserId = empty($itemAPI['cod_vendedor']) === false && isset($relatedListUser[$itemAPI['cod_vendedor']]) ? $relatedListUser[$itemAPI['cod_vendedor']] : null ; //&& is_object($relatedListUser[$itemAPI['cod_vendedor']])
                $auxDate = isset($itemAPI['data_vencto_util']) && empty($itemAPI['data_vencto_util']) === false ?
                    \Commons\Util\DateTimeBr::createFromFormat("Y-m-d", substr(trim($itemAPI['data_vencto_util']), 0, 10)) :
                    \Commons\Util\DateTimeBr::createFromFormat("Y-m-d", date('Y-m-d'));
                $auxTotal = isset($itemAPI['valor_titulo']) && empty($itemAPI['valor_titulo']) === false ? floatval(trim($itemAPI['valor_titulo'])) : 0 ;
                $auxStatus = isset($itemAPI['status_titulo']) && $itemAPI['status_titulo'] == 'A' ? 1 : 0 ;

                if (
                    $localItemCheck->getTotal() == null || $localItemCheck->getTotal() != $auxTotal ||
                    $localItemCheck->getStatus() == null || $localItemCheck->getStatus() != $auxStatus ||
                    (
                        $localItemCheck->getCustomer() == null ||
                        is_object($localItemCheck->getCustomer()) === false ||
                        $localItemCheck->getCustomer()->getId() != $auxCustomerId
                    ) ||
                    (
                        $localItemCheck->getDate() == null ||
                        is_object($localItemCheck->getDate()) === false ||
                        $localItemCheck->getDate()->format("Ymd") != $auxDate->format("Ymd")
                    )
                ) { //Fazer verificacao

                    $auxCustomer = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($auxCustomerId);
                    if (is_object($auxCustomer) === false)
                        continue;

                    $localItemCheck->setCode(trim($itemAPI['chave_fato']));
                    $localItemCheck->setCustomer($auxCustomer);

                    $auxUser = empty($auxUserId) === false ?
                        $this->getEntityManager()->getRepository('Model\Entity\User')->find($auxUserId)
                        : null ;
                    if (is_object($auxUser) == true)
                        $localItemCheck->setUser($auxUser);

                    $localItemCheck->setDescription(isset($itemAPI['chave_fato']) && empty($itemAPI['chave_fato']) === false ? trim($itemAPI['chave_fato']) : '');
                    $localItemCheck->setDate($auxDate);

                    $localItemCheck->setTotal($auxTotal);
                    $localItemCheck->setStatus($auxStatus);

                    $localItemCheck->setActive(true);
                    $localItemCheck->setSync(true);
                    $localItemCheck->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($localItemCheck);

                    $batchList[] = $localItemCheck;
                    $counter++;
                }

                //$itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
                $itemsLocalList[$localItemCheck->getCode()] = true;
                if ($counter > 0 && ($counter % $batchSize) === 0) {
                    $this->getEntityManager()->flush();
                    if (count($batchList) > 0) {
                        foreach ($batchList as $batchItem) {
                            $this->getEntityManager()->detach($batchItem);
                            unset($batchItem);
                        }
                        $batchList = null;
                        $batchList = array();
                    }

                    //$this->setLog('syncFinancialPending', 'step-'.$counter);

                    //sleep(1);
                    //usleep(250000);// para processamento por 1/2 segundo
                }
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['FinancialPending']) && count($codeUsed['FinancialPending']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (is_object($itemLocal) && in_array($code, $codeUsed['FinancialPending']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();
            $this->getEntityManager()->clear();

            $this->setLog('syncFinancialPending', 'end');

            return true;

        } catch(\Exception $ex) {
            $this->getEntityManager()->clear();
            return $ex->getMessage();
        }
    }

    private function syncOrderType()
    {
        try {

            $apiReturn = $this->get(self::URL_API_TYPE_MOVIMENT);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\OrderType')
                ->select('obj')
                ->from('Model\Entity\OrderType','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['OrderType'] = array();
            //-------- Entity Local ---------//

            foreach (array(
                         "cod_tmv_orcamento",
                         "cod_tmv_pedido",
                         "cod_tmv_brinde",
                         "cod_tmv_troca",
                         "cod_tmv_amostra",
                         "cod_tmv_expositor"
                     ) as $itemAPI) {
                if (isset($apiReturn[0]) === false || isset($apiReturn[0][$itemAPI]) === false)
                    continue;

                $field = $apiReturn[0][$itemAPI] == '' ? 'NULL' : $apiReturn[0][$itemAPI] ;

                if (isset($itemsLocalList[trim($field)]) && is_object($itemsLocalList[trim($field)]) === true)
                    $localItemCheck = $itemsLocalList[trim($field)];
                else
                    $localItemCheck = new \Model\Entity\OrderType();

                $codeUsed['OrderType'][] = trim($field);

                //$localItemCheck->setDescription(isset($itemAPI['desc_'.$descriptionKey]) && empty($itemAPI['desc_'.$descriptionKey]) === false ? trim($itemAPI['desc_'.$descriptionKey]) : '');
                $localItemCheck->setCode(trim($field));
                $localItemCheck->setActive(true);
                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['OrderType']) && count($codeUsed['OrderType']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['OrderType']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();

            return true;

        } catch(\Exception $ex) {
            return $ex->getMessage();
        }
    }

    private function syncPaymentMethod()
    {
        try {

            $apiReturn = $this->get(self::URL_API_PAYMENT_METHOD);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\PaymentMethod')
                ->select('obj')
                ->from('Model\Entity\PaymentMethod','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['PaymentMethod'] = array();
            //-------- Entity Local ---------//

            foreach ($apiReturn as $itemAPI) {
                if (
                    isset($itemAPI['cod_metodo']) === false || isset($itemAPI['descricao']) === false ||
                    empty($itemAPI['cod_metodo']) || empty($itemAPI['descricao'])
                )
                    continue;

                $field = trim($itemAPI['cod_metodo']);

                if (isset($itemsLocalList[trim($field)]) && is_object($itemsLocalList[trim($field)]) === true)
                    $localItemCheck = $itemsLocalList[trim($field)];
                else
                    $localItemCheck = new \Model\Entity\PaymentMethod();

                $codeUsed['PaymentMethod'][] = trim($field);

                $localItemCheck->setDescription(trim($itemAPI['descricao']));
                $localItemCheck->setCode($field);
                $localItemCheck->setActive(true);
                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['PaymentMethod']) && count($codeUsed['PaymentMethod']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['PaymentMethod']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();

            return true;

        } catch(\Exception $ex) {
            return $ex->getMessage();
        }
    }

    private function syncPaymentCodition()
    {
        try {

            $apiReturn = $this->get(self::URL_API_PAYMENT_CONDITION);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\PaymentCondition')
                ->select('obj')
                ->from('Model\Entity\PaymentCondition','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['PaymentCondition'] = array();
            //-------- Entity Local ---------//

            foreach ($apiReturn as $itemAPI) {
                if (
                    isset($itemAPI['cod_condicao']) === false || isset($itemAPI['descricao']) === false ||
                    empty($itemAPI['cod_condicao']) || empty($itemAPI['descricao'])
                )
                    continue;

                $field = trim($itemAPI['cod_condicao']);

                if (isset($itemsLocalList[trim($field)]) && is_object($itemsLocalList[trim($field)]) === true)
                    $localItemCheck = $itemsLocalList[trim($field)];
                else
                    $localItemCheck = new \Model\Entity\PaymentCondition();

                $codeUsed['PaymentCondition'][] = trim($itemAPI['cod_condicao']);

                $localItemCheck->setDescription(trim($itemAPI['descricao']));
                $localItemCheck->setCode($field);
                $localItemCheck->setActive(true);
                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['PaymentCondition']) && count($codeUsed['PaymentCondition']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['PaymentCondition']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();

            return true;

        } catch(\Exception $ex) {
            return $ex->getMessage();
        }
    }

    private function syncUnitAmount()
    {
        try {

            $apiReturn = $this->get(self::URL_API_UNIT_AMOUNT);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception('Nao foi possivel sincronizar dados com o webservice ou nada foi retornado.');

            $codeUsed = array();

            //-------- Entity Local ---------//
            $itemsLocalList = array();
            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\UnitAmount')
                ->select('obj')
                ->from('Model\Entity\UnitAmount','obj')
                ->getQuery()->getResult();
            foreach ($itemsLocal as $itemLocal) {
                if ($itemLocal->getCode() !== null && trim($itemLocal->getCode()) != '')
                    $itemsLocalList[trim($itemLocal->getCode())] = $itemLocal;
            }
            $codeUsed['UnitAmount'] = array();
            //-------- Entity Local ---------//

            foreach ($apiReturn as $itemAPI) {
                if (
                    isset($itemAPI['cod_unidade']) === false || isset($itemAPI['desc_unidade']) === false ||
                    empty($itemAPI['cod_unidade']) || empty($itemAPI['desc_unidade'])
                )
                    continue;

                $field = trim($itemAPI['cod_unidade']);

                if (isset($itemsLocalList[trim($field)]) && is_object($itemsLocalList[trim($field)]) === true)
                    $localItemCheck = $itemsLocalList[trim($field)];
                else
                    $localItemCheck = new \Model\Entity\UnitAmount();

                $codeUsed['UnitAmount'][] = trim($itemAPI['cod_unidade']);

                $localItemCheck->setDescription(trim($itemAPI['desc_unidade']));
                $localItemCheck->setAmount((float)$itemAPI['qtde_embalagem']);
                $localItemCheck->setCode($field);
                $localItemCheck->setActive(true);
                $localItemCheck->setSync(true);
                $localItemCheck->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($localItemCheck);

                $itemsLocalList[$localItemCheck->getCode()] = $localItemCheck;
            }

            if (count($itemsLocalList) > 0 && is_array($codeUsed['UnitAmount']) && count($codeUsed['UnitAmount']) > 0) {
                foreach ($itemsLocalList as $code => $itemLocal) {
                    if (in_array($code, $codeUsed['UnitAmount']) == false) {
                        $itemLocal->setActive(false);
                        $this->getEntityManager()->persist($itemLocal);
                    }
                }
            }

            $itemsLocalList = null;

            $this->getEntityManager()->flush();

            return true;

        } catch(\Exception $ex) {
            return $ex->getMessage();
        }
    }

    private function syncOrders()
    {
        try {

            /*
            (id_user) Cliente – Objeto com o cadastro de cliente (Se for um cadastro novo, o código será nulo e então iremos cadastrar no sistema e devolver o objeto com o novo código, após a sincronização ou em uma sincronização futura).
            (order_product) Item – Objeto contendo
            {
                - (code_product) Cod_produto – String, 12 caracteres
                - (reference_product) Cod_ref – String, 4 caracteres
                - (amount) Qtde – Decimal, 20,8 (Qtde vendida, sendo 12 inteiros e 8 decimais)
                - (price) Valor_unitario – Decimal, 20,10 (Valor unitário, sendo 10 inteiros e 10 decimais)
                - (discount) Valor_desconto – Decimal, 15,2 (Valor total de desconto do item, sendo 13 inteiros e 2 decimais)
                - (total) Valor_Liquido – Decimal, 15, 2 (Valor liquido total do item, (valor_unitairo * qtde)-valor_desconto, sendo 13 inteiros e 2 decimais)
            }
            (obs) Observacao – String sem tamanho definido
            (discount_percent1) Perc_desconto1 – Decimal, 11,8 (Desconto em cascata 1, sendo 3 inteiros e 8 decimais)
            (discount_percent2) Perc_desconto2 – Decimal, 11,8 (Desconto em cascata 2, sendo 3 inteiros e 8 decimais)
            (discount_percent3) Perc_desconto3 – Decimal, 11,8 (Desconto em cascata 3, sendo 3 inteiros e 8 decimais)
            (discount_percent4) Perc_desconto4 – Decimal, 11,8 (Desconto em cascata 4, sendo 3 inteiros e 8 decimais)
            (discount_percent5) Perc_desconto5 – Decimal, 11,8 (Desconto em cascata 5, sendo 3 inteiros e 8 decimais)
            (subtotal) Valor_total – Decimal, 15,2 (Valor Bruto do pedido sem desconto, sendo 13 inteiros e 2 decimais)
            (discount) Valor_Desconto – Decimal, 15,2 (Valor de desconto total do pedido, sendo 13 inteiros e 2 decimais)
            (total) Valor_liqudo – Decimal, 15,2 (Valor liquido do pedido, Valor_bruto – valor_desconto, sendo 13 inteiros e 2 decimais)

            *********************************************************
            {
                "totalCount": 9813,
                "pageCount": 982,
                "page": 1,
                "pageSize": 10,
                "embedded": [
                    {
                        "cliente": {
                            "cod_cadastro": 12988,
                            "nome_cadastro": "SANTOS & MARRONI LTDA",
                            "apelido": "SANTOS & MARRO",
                            "tipo_fj": null,
                            "cpf_cnpj": "02357272000179",
                            "rg_ie": null,
                            "cidade": "CAMPO MOURAO",
                            "uf": null,
                            "cep": null,
                            "endereco": null,
                            "bairro": "CENTRO",
                            "numero": "560",
                            "fone": "04435234148",
                            "cod_vendedor": 361,
                            "tipo_cadastro": "C"
                        },
                        "itens": [
                            {
                                "cod_produto": "1620",
                                "cod_ref": "1620",
                                "qtde": 4,
                                "valor_unitario": 26.09,
                                "valor_desconto": 7.28,
                                "valor_liquido": 97.08,
                                "cod_unidade": "UN  "
                            },
                            ...
                        ],
                        "observacao": "BOLETO 30-60-90-120\r\n\r\n\r\n",
                        "perc_desconto1": 0,
                        "perc_desconto2": 0,
                        "perc_desconto3": 0,
                        "perc_desconto4": 0,
                        "perc_desconto5": 0,
                        "valor_total": 1774.52,
                        "valor_desconto": 125.77,
                        "valor_liquido": 1648.75,
                        "tipo_mv": 610,
                        "numero": "1",
                        "cod_vendedor": 237,
                        "data_pedido": "2013-03-23T00:00:00",
                        "id": "23",
                        "chave_Fato": "XXX448227",
                        "classificacao": "D",
                        "tipo_cliente": "S",
                        "codicao_pagamento": "V11",
                        "metodo_cobranca": ""
                    },
                ]
            }
            *********************************************************
            */

            /*
            $apiReturn = $this->get(self::URL_API_ORDER);

            if (is_array($apiReturn) === false || count($apiReturn) == 0)
                throw new \Exception;

            $itemsLocal = $this->getEntityManager()
                ->createQueryBuilder('Model\Entity\Product')
                ->select('obj')
                ->from('Model\Entity\Product','obj')
                ->getQuery()->getResult();

            foreach ($apiReturn as $itemAPI) {
                if (isset($itemAPI['cod_produto']) === false || empty($itemAPI['cod_produto']))
                    continue;

                $localItemCheck = null;
                foreach ($itemsLocal as $itemLocal) {
                    if ($itemLocal->getCode() && trim($itemLocal->getCode()) == trim($itemAPI['cod_produto'])) {
                        $localItemCheck = $itemLocal;
                        break;
                    }
                }

                if (is_object($localItemCheck) === false)
                    $localItemCheck = new \Model\Entity\Product();

                $localItemCheck->setReference(isset($itemAPI['cod_ref']) && empty($itemAPI['cod_ref']) === false ? trim($itemAPI['cod_ref']) : '');
                $localItemCheck->setName(isset($itemAPI['desc_produto']) && empty($itemAPI['desc_produto']) === false ? trim($itemAPI['desc_produto']) : '');
                $localItemCheck->setDescriptionGrid(isset($itemAPI['desc_grade']) && empty($itemAPI['desc_grade']) === false ? trim($itemAPI['desc_grade']) : '');

                //cod_unidade
                //$localItemCheck->setUnit();

                $localItemCheck->setPrice((double)(isset($itemAPI['preco']) && empty($itemAPI['preco']) === false ? trim($itemAPI['preco']) : '0,00'));
                $localItemCheck->setActive(isset($itemAPI['status']) && strtoupper(trim($itemAPI['status'])) == 'A' ? true : false);
                $localItemCheck->setAmountMinimal((double)(isset($itemAPI['qtde_minima']) && empty($itemAPI['qtde_minima']) === false ? trim($itemAPI['qtde_minima']) : '0,00'));
                $localItemCheck->setPriceMin((double)(isset($itemAPI['valor_minimo']) && empty($itemAPI['valor_minimo']) === false ? trim($itemAPI['valor_minimo']) : '0,00'));
                $localItemCheck->setPricePromotional((double)(isset($itemAPI['valor_promocao']) && empty($itemAPI['valor_promocao']) === false ? trim($itemAPI['valor_promocao']) : '0,00'));

                //cod_grupo
                //$localItemCheck->setGroupRelatedByIdGroupPrimary();

                $this->getEntityManager()->persist($localItemCheck);
            }

            $this->getEntityManager()->flush();
            */

            return true;

        } catch(\Exception $ex) {
            return false;
        }
    }

    private function getUrl() {
        $config = $this->getConfig();

        if (
            is_array($config)
            && isset($config['salestool'])
            && isset($config['salestool']['integration'])
            && isset($config['salestool']['integration']['config'])
            && isset($config['salestool']['integration']['config']['host'])
            && isset($config['salestool']['integration']['config']['port'])
        )
            return trim($config['salestool']['integration']['config']['host']).":".trim($config['salestool']['integration']['config']['port']);

        return false;
    }

    private function get($apiServiceUrl, $decode = true, $timeout = 180)
    {
        try {

            $URL_API = $this->getUrl();
            if (empty($URL_API))
                throw new \Exception('O host do webservice não foi definido.');

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $URL_API.$apiServiceUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Basic Q09ORVg6QzBOM1g=')); /*, 'Authorization: Basic '.$this->KEY_ID*/
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); //seconds (3min)

            $response = curl_exec($ch);
            curl_close($ch);

            if ($decode == true)
                $response = json_decode($response, true) ? $this->getLowercase(json_decode($response, true)) : false;

            return $response;
        } catch(\Exception $ex) {
            return false;
        }
    }

    private function post($apiServiceUrl, $fields)
    {
        try {

            $URL_API = $this->getUrl();
            if (empty($URL_API))
                throw new \Exception('O host do webservice não foi definido.');

            //print_r($fields);

            $fields = json_encode($fields);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $URL_API.$apiServiceUrl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Basic Q09ORVg6QzBOM1g=')); /*, 'Authorization: Basic '.$this->KEY_ID*/
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

            $response = curl_exec($ch);
            curl_close($ch);

            //var_dump(self::URL_API.$apiServiceUrl);
            //die(var_dump($response));

            if (strstr($response, 'cod_cadastro') !== false || strstr($response, 'id') !== false || strstr($response, 'chave_Fato') !== false)
                $response = json_decode($response, true) ? $this->getLowercase(json_decode($response, true)) : false;
            else
                //$response = strstr($response, '200 OK') !== false ? true : false;
                $response = empty($response) ? true : false;

            return $response;
        } catch(\Exception $ex) {
            return false;
        }
    }

    private function getLowercase($list)
    {
        $response = array();
        if (is_array($list) && count($list) > 0) {
            foreach ($list as $key => $val) {
                $response[trim(strtolower($key))] = $val;
            }
        }
        return $response;
    }

}
