<?php

namespace API\Controller\Custom\Alternativa;

use API\Controller\AbstractApiActionController;
use Rhumsaa\Uuid\Console\Exception;
use Zend\Mvc\MvcEvent;
use Commons\Util\DateTimeBr;
use Model\Entity\Order;

class SyncController extends AbstractApiActionController
{

    const DB_HOST = "179.184.11.96";
    const DB_PORT = "391";
    const DB_USER = "sa";
    const DB_PASSWORD = "2973";
    const DB_DBNAME = "ROGERIOA";
    const ID_STATUS_PULL_ORDER = "10";
    const ID_STATUS_REMOVE_ORDER = "5";
    const ID_STATUS_AFTER_UPDATE_ORDER = "8";

    private $entities;
    private $dbcon;

    private $codeUsed;

    public function indexAction()
    {
        return $this->createResponse(array(
            'result' => true
        ));
    }

    public function uploadAction()
    {
        try{
            $this->connect();

            $data = array();

            $this->setLog('sync:upload:alternativa', 'start');

            $data['order'] = $this->uploadOrders();

            $this->setLog('sync:upload:alternativa', serialize($data));
            $this->setLog('sync:upload:alternativa', 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function uploadOrders()
    {
        try {

            $ordersToSync = $this->getEntityManager()->getRepository('Model\Entity\Order')->findBy(array('sync' => false, 'appSync' => true));
            if (count($ordersToSync) == 0)
                return true;

            $sqlQuery = array();

            foreach ($ordersToSync as $key => $order) {

                $orderItens = $order->getOrderProducts();
                if (count($orderItens) > 0) {
                    $qtdItens = 0;
                    foreach ($orderItens as $item) {

                        /*
                        $qtdDevolution = (
                        $item->getAmountDevolution() ?
                            (int)$item->getAmountDevolution() + (
                            $item->getAmountDevolutionInvoice() ?
                                (int)$item->getAmountDevolutionInvoice()
                                : 0
                            )
                            : 0
                        );
                        */
                        $qtdDev1 = $item->getAmountDevolution() != null && $item->getAmountDevolution() > 0 ? (int)$item->getAmountDevolution() : 0 ;
                        $qtdDev2 = $item->getAmountDevolutionInvoice() != null && $item->getAmountDevolutionInvoice() > 0 ? (int)$item->getAmountDevolutionInvoice() : 0 ;
                        $qtdDevolution = $qtdDev1 + $qtdDev2;

                        $valueTotal = ($item->getAmount() - $qtdDevolution) * $item->getPrice();

                        $sqlQuery[] = " UPDATE [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS_ITENS]
                                        SET   NR_QUANTIDADE = (NR_QUANTIDADE - ".$qtdDevolution."),
                                              VL_TOTAL = ".($valueTotal ? $valueTotal : 0)."
                                        WHERE CD_PEDIDO = ".$item->getOrder()->getCode()."
                                              AND CD_MATERIAL = ".$item->getProduct()->getCode();

                        $qtdItens += $item->getAmount();
                    }

                    $sqlQuery[] = " UPDATE [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS]
                                    SET   CD_STATUS = ".self::ID_STATUS_AFTER_UPDATE_ORDER.",
                                          NR_ITENS = ".count($orderItens).",
                                          VL_PRODUTOS = ".($order->getTotal() ? $order->getTotal() : 0).",
                                          VL_TOTAL = ".($order->getTotal() ? $order->getTotal() : 0).",
                                          X_MOBILE = 1
                                    WHERE CD_PEDIDO = ".$order->getCode();

                    $order->setSync(true);
                    $order->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($order);
                }
            }

            try {
                $this->setLog('sync:upload:alternativa:orders_update', implode(";", $sqlQuery));
            } catch(Exception $e) {
                //Do nothing
            }

            $result = $this->queryTransaction($sqlQuery);
            if ($result !== true)
                throw new Exception('Não foi possível realizar o upload das informações!');

            $this->getEntityManager()->flush();

            return true;

        } catch(Exception $e) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $e->getMessage());
        }
    }

    public function downloadAction()
    {
        try{
            $this->connect();

            $data = array();

            $this->codeUsed = array();

            $this->setLog('sync:download:alternativa', 'start');

            $usedItens = $this->getOrdersRelations();

            //$data['users'] = $this->syncUsers();
            $data['customer'] = $this->syncCustomers($usedItens['cliente']);
            ////$data['financialPending'] = true;
            ////$data['group'] = true;
            $data['product'] = $this->syncProducts($usedItens['material']);
            $data['order'] = $this->syncOrders($usedItens['pedido']);

            //--------- INACTIVE ITENS ------------//
            $this->setLog('sync:download:alternativa:inactive', 'step 1');
            if (count($this->codeUsed) > 0) {
                foreach ($this->codeUsed as $entityName => $codesUsed) {
                    if (count($this->entities[$entityName]) > 0) {
                        foreach ($this->entities[$entityName] as $itemEntity) {

                            if (method_exists($itemEntity, 'getCode') === false)
                                break;

                            if (
                                $itemEntity->getActive() &&
                                (
                                    ($entityName != 'Order' && in_array($itemEntity->getCode(), $codesUsed) == false) ||
                                    //Inactive only orders not updated before and is not active on ERP
                                    ($entityName == 'Order' && in_array($itemEntity->getCode(), $codesUsed) == false && $itemEntity->getStatus() != \Model\Entity\Order::STATUS_UPDATED)
                                )
                            ) {
                                $this->setLog('sync:download:alternativa:inactive', 'step 2 - '.$entityName.' - '.$itemEntity->getId());
                                $itemEntity->setActive(false);
                                $this->getEntityManager()->persist($itemEntity);
                            }

                        }
                    }
                }
                $this->getEntityManager()->flush();
            }
            $this->setLog('sync:download:alternativa:inactive', 'step 3');
            //--------- INACTIVE ITENS ------------//

            $this->setLog('sync:download:alternativa', serialize($data));
            $this->setLog('sync:download:alternativa', 'end');

            return $this->createResponse($data);
        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function syncUsers()
    {
        try {

            $sql = "SELECT [CD_ENTIDADE]
                          ,[DS_ENTIDADE]
                          ,[DS_FANTASIA]
                          ,[DS_EMAIL]
                          ,[X_VENDEDOR]
                          ,[X_ATIVO]
                          ,[DS_LOGIN_PEDIDO_WEB]
                          ,[DS_SENHA_PEDIDO_WEB]
                    FROM [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES]
                    WHERE X_VENDEDOR = 1 AND X_ATIVO = 1 AND CD_ENTIDADE IS NOT NULL AND DS_ENTIDADE IS NOT NULL";

            $result = $this->query($sql);

            if (is_array($result) === false || count($result) == 0)
                return false;

            $this->codeUsed['User'] = array();

            foreach ($result as $vendedor) {

                $entity = $this->getEntityRelated('User', $vendedor['CD_ENTIDADE']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['User'][] = trim($vendedor['CD_ENTIDADE']);

                $entity->setCode(trim($vendedor['CD_ENTIDADE']));
                $entity->setName(trim($vendedor['DS_ENTIDADE']));
                //--UNIQUE--//
                $entity->setEmail(isset($vendedor['DS_EMAIL']) && strstr($vendedor['DS_EMAIL'], "@") !== false ? trim($vendedor['DS_EMAIL']) : $vendedor['CD_ENTIDADE']);
                $entity->setUsername(empty($vendedor['DS_LOGIN_PEDIDO_WEB']) === false ? trim($vendedor['DS_LOGIN_PEDIDO_WEB']) : trim($vendedor['CD_ENTIDADE']));
                //--UNIQUE--//
                $entity->setPassword(empty($vendedor['DS_SENHA_PEDIDO_WEB']) === false ? trim($vendedor['DS_SENHA_PEDIDO_WEB']) : trim($vendedor['CD_ENTIDADE']));
                $entity->setActive(true);
                $entity->setAdmin(false);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->getEntityManager()->flush();

            return true;

        }  catch(Exception $e)  {
            return $e->getMessage();
        }
    }

    public function syncCustomers($ids)
    {
        try {

            $this->setLog('sync:download:alternativa:customer', 'log 1');

            if (is_array($ids) === false || count($ids) == 0)
                throw new Exception('Nenhum id de cliente foi encontrado!');

            $sqlComp = ' AND E.CD_ENTIDADE IN ('.implode(",", $ids).') ';

            $sql = "SELECT E.CD_ENTIDADE
                          ,E.CD_CIDADE
                          ,C.DS_CIDADE
                          ,S.DS_ESTADO
                          ,E.DS_ENTIDADE
                          ,E.DS_FANTASIA
                          ,E.DS_ENDERECO
                          ,E.DS_BAIRRO
                          ,E.NR_CEP
                          ,E.NR_CAIXAPOSTAL
                          ,E.NR_NUMERO
                          ,E.DS_COMPLEMENTO
                          ,E.DS_EMAIL
                          ,E.DS_OBS
                          ,E.DS_SEXO
                          ,E.DT_ANIVERSARIO
                          ,E.NR_DDD
                          ,E.NR_TELEFONE
                          ,E.NR_CELULAR
                          ,E.NR_CPFCNPJ
                          ,E.NR_IE
                          ,E.NR_RG
                          ,E.X_CLIENTE
                          ,E.X_VENDEDOR
                          ,E.X_ATIVO
                          ,E.DS_CONTATO
                          ,E.CD_TIPO
                          ,E.CD_CLASSIFICACAO
                          ,E.CD_GRUPO
                          ,E.CD_CIDADE_ENTREGA
                          ,E.DS_ENDERECO_ENTREGA
                          ,E.DS_BAIRRO_ENTREGA
                          ,E.DS_LETRA_ENTREGA
                          ,E.NR_CEP_ENTREGA
                          ,E.NR_CAIXAPOSTAL_ENTREGA
                          ,E.NR_NUMERO_ENTREGA
                          ,E.DS_COMPLEMENTO_ENTREGA
                          ,E.DS_EMAIL_ORD_COMPRA
                          ,E.NR_DDD_FAX
                          ,E.NR_DDD_CELULAR
                          ,E.DS_CONTATO_FONE
                          ,E.DS_EMAIL_BOLETO
                          ,E.DS_EMAIL_PEDIDO
                          ,E.DS_EMAIL_ORCAMENTO
                          ,E.X_ATIVO
                    FROM [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES] E
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENDERECO_CIDADES] C ON C.CD_CIDADE = E.CD_CIDADE
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENDERECO_ESTADOS] S ON S.CD_ESTADO = C.CD_ESTADO
                    WHERE X_CLIENTE = 1
                          AND CD_ENTIDADE IS NOT NULL
                          AND DS_ENTIDADE IS NOT NULL
                          ".$sqlComp; //AND X_ATIVO = 1

            $result = $this->query($sql, array(), false);

            $this->setLog('sync:download:alternativa:customer', 'log 2');

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum cliente foi encontrado!');

            $this->codeUsed['Customer'] = array();

            foreach ($result as $cliente) {

                $pj = strlen(preg_replace('/\D/','',$cliente['NR_CPFCNPJ'])) > 0 ? true : false;

                $entity = $this->getEntityRelated('Customer', $cliente['CD_ENTIDADE']);

                if ($entity->getId() > 0 && $entity->getSync() === false)
                    continue;

                $this->codeUsed['Customer'][] = trim($cliente['CD_ENTIDADE']);

                $entity->populateFromSync(array(
                    'code' => trim($cliente['CD_ENTIDADE']),
                    'nome' => ($pj === true ? $cliente['DS_FANTASIA'] : $cliente['DS_ENTIDADE']),
                    'nickname' => '',
                    'razaoSocial' => ($pj === true ? $cliente['DS_ENTIDADE'] : ''),
                    'contato' => $cliente['DS_CONTATO'],
                    'documentoNacional' => $cliente['NR_CPFCNPJ'],
                    'documentoEstadual' => ($pj === true ? $cliente['NR_IE'] : $cliente['NR_RG']),
                    'email' => $cliente['DS_EMAIL'],
                    'cep' => $cliente['NR_CEP'],
                    'endereco' => $cliente['DS_ENDERECO'],
                    'numero' => $cliente['NR_NUMERO'],
                    'complemento' => $cliente['DS_COMPLEMENTO'],
                    'bairro' => $cliente['DS_BAIRRO'],
                    'cidade' => $cliente['DS_CIDADE'],
                    'estado' => $cliente['DS_ESTADO'],
                    'tipo' => ($pj === true ? 'pj' : 'pf'),
                    'telefonePrincipal' => $cliente['NR_DDD'].$cliente['NR_TELEFONE'],
                    'telefoneSecundario' => $cliente['NR_DDD'].$cliente['NR_CELULAR'],
                    'info' => $cliente['DS_OBS'],
                    'active' => $cliente['X_ATIVO'],
                    'latitude' => '',
                    'longitude' => '',
                ));

                if (!$entity->getId()) {
                    $entity->setBlocked(false);
                }

                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->setLog('sync:download:alternativa:customer', 'log 3');

            $this->getEntityManager()->flush();

            $this->setLog('sync:download:alternativa:customer', 'log 4');

            return true;

        }  catch(Exception $e)  {
            return $e->getMessage();
        }
    }

    public function syncProducts($ids)
    {
        try {

            $this->setLog('sync:download:alternativa:products', 'log 1');

            if (is_array($ids) === false || count($ids) == 0)
                throw new Exception('Nenhum id de produto foi encontrado!');

            $sqlComp = ' AND M.CD_MATERIAL IN ('.implode(",", $ids).') ';

            $sql = "SELECT M.CD_MATERIAL
                          ,M.IM_FOTO
                          ,M.CD_CODBARRA
                          ,M.CD_NCM
                          ,M.CD_IDENTIFICACAO
                          ,U.CD_UNIDADE
                          ,U.DS_UNIDADE
                          ,U.DS_ABREVIATURA
                          ,S.CD_SUBGRUPO
                          ,S.DS_SUBGRUPO
                          ,G.CD_GRUPO
                          ,G.DS_GRUPO
                          ,T.CD_TIPOITEM
                          ,T.DS_TIPOITEM
                          ,GE.CD_GENERO
                          ,GE.DS_GENERO
                          ,M.DS_MATERIAL
                          ,M.DS_MATERIAL_NF
                          ,M.NR_ESTOQUE_DISPONIVEL
                          ,M.NR_ESTOQUE_RESERVADO
                          ,M.VL_VENDA
                          ,M.VL_MINIMO_VENDA
                          ,M.NR_PERCENTUAL_COMISSAO
                          ,M.NR_INDICE
                          ,M.X_ATIVO
                          ,M.DS_OBS
                          ,M.VL_CUSTO_FINAL
                          ,M.X_INTEGRACAO_PEDIDO_WEB
                          ,M.CD_REFERENCIA
                          ,M.X_GERA_COMISSAO
                    FROM [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS] M
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS_UNIDADE]   U  ON U.CD_UNIDADE   = M.CD_UNIDADE
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS_SUBGRUPO]  S  ON S.CD_SUBGRUPO  = M.CD_SUBGRUPO
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS_GRUPO]     G  ON G.CD_GRUPO     = S.CD_GRUPO
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS_TIPO_ITEM] T  ON T.CD_TIPOITEM  = M.CD_TIPO_ITEM
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_MATERIAIS_GENERO]    GE ON GE.CD_GENERO   = M.CD_GENERO
                    WHERE M.X_ATIVO = 1
                          AND M.DS_MATERIAL IS NOT NULL
                          ".$sqlComp;

            $result = $this->query($sql, array(), true);

            $this->setLog('sync:download:alternativa:products', 'log 2');

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum produto foi encontrado!');

            $this->codeUsed['Product'] = array();
            $this->codeUsed['Group'] = array();
            $this->codeUsed['Unit'] = array();

            foreach ($result as $produto) {

                try {
                    $grupo = $this->getEntityRelated('Group', $produto['CD_GRUPO']);

                    $this->codeUsed['Group'][] = trim($produto['CD_GRUPO']);

                    $grupo->setCode(trim($produto['CD_GRUPO']));
                    $grupo->setDescription($produto['DS_GRUPO']);
                    $grupo->setActive(true);
                    $grupo->setSync(true);
                    $grupo->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($grupo);
                } catch (Exception $e) {
                    //Do nothing
                }

                try {
                    $subgrupo = $this->getEntityRelated('Group', $produto['CD_SUBGRUPO']);

                    $this->codeUsed['Group'][] = trim($produto['CD_SUBGRUPO']);

                    $subgrupo->setCode(trim($produto['CD_SUBGRUPO']));
                    $subgrupo->setDescription($produto['DS_SUBGRUPO']);
                    $subgrupo->setActive(true);
                    $subgrupo->setSync(true);
                    $subgrupo->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($subgrupo);
                } catch (Exception $e) {
                    //Do nothing
                }

                try {
                    $unidade = $this->getEntityRelated('Unit', strtolower($produto['DS_ABREVIATURA']), true);

                    $this->codeUsed['Unit'][] = trim(strtolower($produto['DS_ABREVIATURA']));

                    $unidade->setId(trim(strtolower($produto['DS_ABREVIATURA'])));
                    $unidade->setDescription($produto['DS_UNIDADE']);
                    $unidade->setActive(true);
                    $unidade->setSync(true);
                    $unidade->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($unidade);
                } catch (Exception $e) {
                    //Do nothing
                }

                $entity = $this->getEntityRelated('Product', $produto['CD_MATERIAL']);

                if (
                ($entity->getId() > 0 && $entity->getSync() === false)
                    //|| $entity->getId() > 0
                )
                    continue;

                $this->codeUsed['Product'][] = trim($produto['CD_MATERIAL']);

                $entity->populateFromSync(array(
                    'code' => trim($produto['CD_MATERIAL']),
                    'name' => $produto['DS_MATERIAL'],
                    'reference' => $produto['CD_IDENTIFICACAO'],
                    'description' => $produto['DS_MATERIAL_NF'],
                    'barcode' => $produto['CD_CODBARRA'],
                    'info' => $produto['DS_OBS'],
                    'unit' => $unidade,
                    'groupPrimary' => $grupo,
                    'groupSecondary' => $subgrupo,
                    'cost' => $produto['VL_CUSTO_FINAL'],
                    'price' => $produto['VL_VENDA'],
                    'priceMin' => $produto['VL_MINIMO_VENDA'],
                    'commission' => $produto['NR_PERCENTUAL_COMISSAO'],
                    'descriptionGrid' => '',
                    'amountMinimal' => $produto['VL_MINIMO_VENDA'],
                    'pricePromotional' => 0
                ));

                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());

                $this->getEntityManager()->persist($entity);
            }

            $this->setLog('sync:download:alternativa:products', 'log 3');

            $this->getEntityManager()->flush();

            $this->setLog('sync:download:alternativa:products', 'log 4');

            return true;

        }  catch(Exception $e)  {
            return $e->getMessage();
        }
    }

    public function syncOrders($ids)
    {
        try {

            $this->setLog('sync:download:alternativa:orders', 'log 1');

            if (is_array($ids) === false || count($ids) == 0)
                throw new Exception('Nenhum id de pedido foi encontrado!');

            $sqlComp = ' AND P.CD_PEDIDO IN ('.implode(",", $ids).') ';

            $sql = "SELECT P.CD_PEDIDO
                          ,P.CD_CARTEIRA
                          ,FC.DS_CARTEIRA
                          ,P.CD_FORMA_PAGAMENTO
                          ,FP.DS_FORMA_PAGAMENTO
                          ,P.CD_STATUS
                          ,S.DS_STATUS
                          ,S.CD_STATUS STATUS_GLOBAL
                          ,P.CD_VENDEDOR
                          ,VE.DS_ENTIDADE VENDEDOR_COMPLETO
                          ,VE.DS_FANTASIA VENDEDOR_NOME
                          ,P.DT_EMISSAO
                          ,CONVERT(VARCHAR(10),P.DT_ENTREGA,126) as DT_ENTREGA
                          ,P.DT_CADASTRO
                          ,P.DS_OBS
                          ,P.NR_ITENS
                          ,P.VL_TOTAL
                          ,P.CD_CLIENTE
                          ,CL.DS_ENTIDADE CLIENTE_COMPLETO
                          ,CL.DS_FANTASIA CLIENTE_NOME
                          ,P.VL_DESCONTO
                          ,P.CD_TRANSPORTADOR
                          ,P.NR_ORDEM_COMPRA
                          ,P.VL_PRODUTOS
                          ,P.NR_QUANTIDADE
                          ,P.VL_MATERIAIS
                          ,P.DS_VALIDADE
                          ,P.VL_DESCONTO_ITENS
                          ,P.DS_OBS_INTERNA
                          ,P.PR_DESCONTO
                          ,P.CD_ORCAMENTO
                          ,P.CD_TIPO_PEDIDO
                          ,TP.DS_TIPO_PEDIDO
                          ,P.CD_INTEGRACAO
                    FROM [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS] P
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_FINANCEIRO_CARTEIRA] FC 		    ON FC.CD_CARTEIRA = P.CD_CARTEIRA
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_FINANCEIRO_FORMAS_PAGAMENTO] FP  ON FP.CD_FORMA_PAGAMENTO = P.CD_FORMA_PAGAMENTO
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_TIPO_PEDIDO] TP 				    ON TP.CD_TIPO_PEDIDO = P.CD_TIPO_PEDIDO
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_STATUS_GLOBAL] S 				ON S.CD_STATUS = P.CD_STATUS
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES] CL 					ON CL.CD_ENTIDADE = P.CD_CLIENTE
                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES] VE 					ON VE.CD_ENTIDADE = P.CD_VENDEDOR
                    WHERE S.CD_STATUS = ".self::ID_STATUS_PULL_ORDER."
                          ".$sqlComp."
                    ORDER BY P.CD_PEDIDO DESC";

            //S.CD_STATUS = ".self::ID_STATUS_REMOVE_ORDER."

            //AND S.ID = ".self::ID_STATUS_PULL_ORDER."
            /*
            S.X_FINALIZACAO <> 1 AND S.X_PERDIDO <> 1
            */

            $result = $this->query($sql, array(), false);

            $this->setLog('sync:download:alternativa:orders', 'log 2');

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum pedido foi encontrado!');

            $this->codeUsed['Order'] = array();
            $this->codeUsed['OrderProduct'] = array();
            $this->codeUsed['PaymentMethod'] = array();
            $this->codeUsed['PaymentCondition'] = array();

            $listIdPedidos = array();
            foreach ($result as $pedido) {
                $listIdPedidos[$pedido['CD_PEDIDO']] = trim($pedido['CD_PEDIDO']);
            }

            $resultItens = $this->query("SELECT [CD_PEDIDO]
                                           ,[CD_ITEM]
                                           ,[CD_MATERIAL]
                                           ,[DS_MATERIAL]
                                           ,[DS_UNIDADE]
                                           ,[NR_QUANTIDADE]
                                           ,[VL_UNITARIO]
                                           ,[VL_TOTAL]
                                           ,[NR_PESO]
                                           ,[CD_ID]
                                           ,[PR_COMISSAO]
                                           ,[PR_DESCONTO]
                                           ,[VL_DESCONTO]
                                           ,[CD_VENDEDOR]
                                           ,CONVERT(VARCHAR(10),DT_ENTREGA,126) as DT_ENTREGA
                                           ,[DS_OBS]
                                           ,[VL_COMISSAO]
                                           ,[VL_DESCONTO_ITEM]
                                           ,[VL_FRETE]
                                           ,[VL_UNITARIO_MOEDA]
                                           ,[VL_TOTAL_MOEDA]
                                           ,[NR_QUANTIDADE_VOLUME]
                                           ,[NR_QUANTIDADE_FATURADA]
                                           ,[VL_UNITARIO_VENDA]
                                           ,[DS_MODELO]
                                           ,[VL_UNITARIO_LIQUIDO]
                                           ,[VL_TOTAL_LIQUIDO]
                                           ,[DS_DESCONTO_CASCATA]
                                           ,[DS_PEDIDO_COMPRA]
                                           ,[NR_ITEM_ORDEM_COMPRA]
                                    FROM [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS_ITENS] PI
                                    WHERE CD_PEDIDO IN (".implode(",", $listIdPedidos).")
                                    ORDER BY CD_PEDIDO DESC
                                  ", array(), false); //(5694)

            if (is_array($resultItens) === false || count($resultItens) == 0)
                throw new Exception('Nenhum item de pedido foi encontrado!');

            $this->setLog('sync:download:alternativa:orders', 'log 3');

            $listPedidosItens = array();
            foreach ($resultItens as $pedidoItem) {

                if (isset($listPedidosItens[$pedidoItem['CD_PEDIDO']]) === false)
                    $listPedidosItens[$pedidoItem['CD_PEDIDO']] = array();

                $listPedidosItens[$pedidoItem['CD_PEDIDO']][] = $pedidoItem;
            }

            try {
                //$user = $this->getUser();
                $warehouse = $this->getEntityManager()->find('Model\Entity\Warehouse', 1);
            } catch (Exception $e) {
                throw new Exception('Seu usuário não foi encontrado!');
            }

            $this->setLog('sync:download:alternativa:orders', 'log 4');

            $checkDuplicate = array();

            foreach ($result as $pedido) {

                //$this->setLog('sync:download:alternativa:orders', 'order 1 '.trim($pedido['CD_PEDIDO']));

                /* WILL ONLY INACTIVE EXISTENT
                if (isset($pedido['STATUS_GLOBAL']) && trim($pedido['STATUS_GLOBAL']) == self::ID_STATUS_REMOVE_ORDER) { //Remove Order

                    $entity = $this->getEntityRelated('Order', $pedido['CD_PEDIDO']);
                    if (is_object($entity) && $entity->getId() > 0)
                        $this->getEntityManager()->remove($entity);

                    continue;
                }
                */

                $customer = $this->getEntityRelated('Customer', $pedido['CD_CLIENTE']);
                if (is_object($customer) === false || $customer->getId() == null)
                    throw new Exception('O cliente Cód.:'.$pedido['CD_CLIENTE'].' não foi encontrado!');

                try {
                    $formaPagamento = $this->getEntityRelated('PaymentMethod', $pedido['CD_CARTEIRA']);

                    $this->codeUsed['PaymentMethod'][] = trim($pedido['CD_CARTEIRA']);

                    $formaPagamento->setCode(trim($pedido['CD_CARTEIRA']));
                    $formaPagamento->setDescription($pedido['DS_CARTEIRA']);
                    $formaPagamento->setActive(true);
                    $formaPagamento->setSync(true);
                    $formaPagamento->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($formaPagamento);
                } catch (Exception $e) {
                    throw new Exception('A forma de pagamento Cód.:'.$pedido['CD_CARTEIRA'].' não foi encontrada!');
                }

                try {
                    $condPagamento = $this->getEntityRelated('PaymentCondition', $pedido['CD_FORMA_PAGAMENTO']);

                    $this->codeUsed['PaymentCondition'][] = trim($pedido['CD_FORMA_PAGAMENTO']);

                    $condPagamento->setCode(trim($pedido['CD_FORMA_PAGAMENTO']));
                    $condPagamento->setDescription($pedido['DS_FORMA_PAGAMENTO']);
                    $condPagamento->setActive(true);
                    $condPagamento->setSync(true);
                    $condPagamento->setSyncDatetime(new DateTimeBr());
                    $this->getEntityManager()->persist($condPagamento);
                } catch (Exception $e) {
                    throw new Exception('A condição de pagamento Cód.:'.$pedido['CD_FORMA_PAGAMENTO'].' não foi encontrada!');
                }

                $pedido['CD_PEDIDO'] = trim($pedido['CD_PEDIDO']);

                $entity = $this->getEntityRelated('Order', $pedido['CD_PEDIDO'], false, $ids);

                if (
                    ($entity->getId() > 0 && $entity->getSync() === false)
                    || isset($listPedidosItens[$pedido['CD_PEDIDO']]) === false
                    || count($listPedidosItens[$pedido['CD_PEDIDO']]) == 0
                )
                    continue;

                //--------------------//

                $this->codeUsed['Order'][] = trim($pedido['CD_PEDIDO']);

                //$this->setLog('sync:download:alternativa:orders', 'order 2 '.trim($pedido['CD_PEDIDO']));

                $entity->setCode(trim($pedido['CD_PEDIDO']));
                $entity->setReference($pedido['NR_ORDEM_COMPRA']);
                $entity->setCustomer($customer);
                $entity->setWarehouse($warehouse);
                //$entity->setUser($user);
                $entity->setInfo($pedido['DS_OBS']);
                $entity->setType(Order::ATUALIZACAO);

                if (isset($pedido['DT_ENTREGA']) && preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", substr(trim($pedido['DT_ENTREGA']),0,10))) {
                    $entity->setOrderDate(\DateTime::createFromFormat('Y-m-d', substr($pedido['DT_ENTREGA'],0,10)));
                } else {
                    continue;
                }

                $entity->setDiscount($pedido['VL_DESCONTO']);
                $entity->setSubtotal(floatval($pedido['VL_TOTAL']) + floatval($pedido['VL_DESCONTO']));
                $entity->setTotal($pedido['VL_TOTAL']);
                //$entity->setLatitude(isset($pedido['latitude']) ? $pedido['latitude'] : '');
                //$entity->setLongitude(isset($pedido['longitude']) ? $pedido['longitude'] : '');

                $entity->setStatus(Order::STATUS_TO_UPDATE);

                // Forma de Pagamento
                $entity->setPaymentMethod($formaPagamento);

                // Condicao de Pagamento
                $entity->setPaymentCondition($condPagamento);

                $entity->setActive(true);
                $entity->setSync(true);
                $entity->setSyncDatetime(new DateTimeBr());
                $entity->setCommission(0);

                $this->getEntityManager()->persist($entity);

                //$this->setLog('sync:download:alternativa:orders', 'order 3 '.trim($pedido['CD_PEDIDO']));

                foreach ($listPedidosItens[$pedido['CD_PEDIDO']] as $item) {

                    $key = $pedido['CD_PEDIDO']." - ".trim($item['CD_MATERIAL']);
                    if (isset($checkDuplicate[$key]) === false)
                        $checkDuplicate[$key] = 1;
                    else
                        continue;

                    $product = $this->getEntityRelated('Product', $item['CD_MATERIAL']);
                    if (
                        $product->getId() == null
                        || $product->getId() <= 0
                    )
                        throw new Exception('O produto Cód.:'.$pedido['CD_MATERIAL'].' não foi encontrado!');

                    $orderProduct = $this->getEntityRelated('OrderProduct', $key, false, $ids);

                    $this->codeUsed['OrderProduct'][] = trim($key);

                    $orderProduct->setCode(trim($key));
                    $orderProduct->setOrder($entity);
                    $orderProduct->setWarehouse($warehouse);
                    $orderProduct->setProduct($product);
                    $orderProduct->setPrice($item['VL_UNITARIO']);
                    $orderProduct->setAmount($item['NR_QUANTIDADE']);
                    $orderProduct->setSubtotal(floatval($item['VL_TOTAL']) + floatval($item['VL_DESCONTO']));
                    $orderProduct->setDiscount($item['VL_DESCONTO']);
                    $orderProduct->setTotal($item['VL_TOTAL']);
                    $orderProduct->setObs($item['DS_OBS']);
                    $orderProduct->setActive(true);
                    $orderProduct->setSync(true);
                    $orderProduct->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($orderProduct);
                }

                //$this->setLog('sync:download:alternativa:orders', 'order 4 '.trim($pedido['CD_PEDIDO']));

                //--------------------//

            }

            $this->setLog('sync:download:alternativa:orders', 'log 5');

            $this->getEntityManager()->flush();

            $this->setLog('sync:download:alternativa:orders', 'log 6');

            return true;

        }  catch(Exception $e)  {
            return $e->getMessage();
        }
    }

    private function getOrdersRelations()
    {

        $dataToReturn = array(
            'pedido' => array(),
            'carteira' => array(),
            'formapagamento' => array(),
            'vendedor' => array(),
            'cliente' => array(),
            'tipopedido' => array(),
            'material' => array()
        );

        try {

            $result = $this->query("SELECT P.CD_PEDIDO
                                          ,P.CD_CARTEIRA
                                          ,P.CD_FORMA_PAGAMENTO
                                          ,P.CD_STATUS
                                          ,P.CD_VENDEDOR
                                          ,P.CD_CLIENTE
                                          ,P.CD_TRANSPORTADOR
                                          ,P.CD_ORCAMENTO
                                          ,P.CD_TIPO_PEDIDO
                                          ,P.CD_INTEGRACAO
                                    FROM [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS] P
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_FINANCEIRO_CARTEIRA] FC 		      ON FC.CD_CARTEIRA        = P.CD_CARTEIRA
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_FINANCEIRO_FORMAS_PAGAMENTO] FP  ON FP.CD_FORMA_PAGAMENTO = P.CD_FORMA_PAGAMENTO
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_TIPO_PEDIDO] TP 				          ON TP.CD_TIPO_PEDIDO     = P.CD_TIPO_PEDIDO
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_STATUS_GLOBAL] S 						    ON S.CD_STATUS           = P.CD_STATUS
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES] CL 					          ON CL.CD_ENTIDADE        = P.CD_CLIENTE
                                    LEFT JOIN [".self::DB_DBNAME."].[dbo].[TBL_ENTIDADES] VE 					          ON VE.CD_ENTIDADE        = P.CD_VENDEDOR
                                    WHERE S.CD_STATUS = ".self::ID_STATUS_PULL_ORDER."
                                    ORDER BY P.CD_PEDIDO DESC
                                  ", array(), false);
            //AND S.ID = ".self::ID_STATUS_PULL_ORDER."
            /*
            S.X_FINALIZACAO <> 1
            AND S.X_PERDIDO <> 1
            */

            if (is_array($result) === false || count($result) == 0)
                throw new Exception('Nenhum pedido foi encontrado!');

            $listIdPedidos = array();
            foreach ($result as $pedido) {
                $dataToReturn['pedido'][trim($pedido['CD_PEDIDO'])]                  = trim($pedido['CD_PEDIDO']);
                $dataToReturn['carteira'][trim($pedido['CD_CARTEIRA'])]              = trim($pedido['CD_CARTEIRA']);
                $dataToReturn['formapagamento'][trim($pedido['CD_FORMA_PAGAMENTO'])] = trim($pedido['CD_FORMA_PAGAMENTO']);
                $dataToReturn['vendedor'][trim($pedido['CD_VENDEDOR'])]              = trim($pedido['CD_VENDEDOR']);
                $dataToReturn['cliente'][trim($pedido['CD_CLIENTE'])]                = trim($pedido['CD_CLIENTE']);
                $dataToReturn['tipopedido'][trim($pedido['CD_TIPO_PEDIDO'])]         = trim($pedido['CD_TIPO_PEDIDO']);
            }

            $resultItens = $this->query("SELECT PI.CD_PEDIDO
                                               ,PI.CD_ITEM
                                               ,PI.CD_MATERIAL
                                               ,PI.CD_ID
                                               ,PI.CD_VENDEDOR
                                    FROM [".self::DB_DBNAME."].[dbo].[TBL_PEDIDOS_ITENS] PI
                                    WHERE CD_PEDIDO IN (".implode(",", $dataToReturn['pedido']).")
                                    ORDER BY CD_PEDIDO DESC
                                  ", array(), false); //(5694)

            if (is_array($resultItens) === false || count($resultItens) == 0)
                throw new Exception('Nenhum item de pedido foi encontrado!');

            $listPedidosItens = array();
            foreach ($resultItens as $pedidoItem) {
                $dataToReturn['material'][trim($pedidoItem['CD_MATERIAL'])] = trim($pedidoItem['CD_MATERIAL']);
            }

            return $dataToReturn;

        } catch (Exception $ex) {
            return $dataToReturn;
        }
    }

    private function connect()
    {
        try {

            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                $this->dbcon = new \PDO("sqlsrv:Server=".self::DB_HOST.",".self::DB_PORT.";Database=".self::DB_DBNAME, self::DB_USER, self::DB_PASSWORD);
            } else {
                putenv('ODBCSYSINI=/etc');
                putenv('ODBCINI=/etc/odbc.ini');
                $this->dbcon = new \PDO("dblib:host=".self::DB_HOST.":".self::DB_PORT.";dbname=".self::DB_DBNAME, self::DB_USER, self::DB_PASSWORD);
            }

            $this->dbcon->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        }  catch(Exception $e)  {
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function queryTransaction($sqlQueries = array())
    {
        try {
            if (is_array($sqlQueries) === false && empty($sqlQueries) === false)
                $sqlQueries = array($sqlQueries);

            if (is_array($sqlQueries) === false || count($sqlQueries) === 0)
                return false;

            $this->dbcon->beginTransaction();

            foreach ($sqlQueries as $sqlQuery) {
                $ret = $this->dbcon->exec($sqlQuery);
            }

            $this->dbcon->commit();

            return true;

        } catch(Exception $e) {
            $this->dbcon->rollback();
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function query($sql, $execList = array(), $hasImage = false)
    {
        try {
            $stmt = $this->dbcon->prepare($sql);
            $stmt->execute($execList); //IM_FOTO
            /*
            $image = null;
            $stmt->bindColumn(2, $image, \PDO::PARAM_LOB, 0, \PDO::SQLSRV_ENCODING_BINARY);
            var_dump($image);
            //$return = $stmt->fetch(PDO::FETCH_BOUND);
            $return = array();
            $stmt->execute();
            while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                var_dump($image);
                $return[] = $row;
            }
            */
            $return = $stmt->fetchAll(\PDO::FETCH_SERIALIZE);
            return $return;
        } catch(Exception $e) {
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function getEntityRelated($entityName, $syncCode, $compareIdColumn = false, $orCodes = array())
    {
        $entity = "Model\Entity\\".$entityName;
        if (isset($this->entities[$entityName]) === false) {

            $query = $this->getEntityManager()
                ->createQueryBuilder($entity)
                ->select('obj')
                ->from($entity,'obj');

            if ($entityName == 'Order') {
                /*
                $query->andWhere('obj.appSync != :appSync')
                      ->andWhere('obj.sync = :clientSync')
                      ->andWhere('obj.code IN ('.implode(',', $orCodes).')')
                      ->setParameter('appSync', 1)
                      ->setParameter('clientSync', 1);
                */
                $query->where($query->expr()->orX(
                    $query->expr()->andX(
                        $query->expr()->neq('obj.appSync', 1),
                        $query->expr()->eq('obj.sync', 1)
                    ),
                    $query->expr()->in('obj.code', $orCodes)
                ));
                //echo "==".$query->getQuery()->getSql()."==";
            }

            if ($entityName == 'OrderProduct') {
                /*
                $query->innerJoin('obj.order', 'ord')
                      ->andWhere('ord.appSync != :appSync')
                      ->andWhere('ord.sync = :clientSync')
                      ->andWhere('ord.code IN ('.implode(',', $orCodes).')')
                      ->setParameter('appSync', 1)
                      ->setParameter('clientSync', 1);
                */
                $query->innerJoin('obj.order', 'ord');
                $query->where($query->expr()->orX(
                    $query->expr()->andX(
                        $query->expr()->neq('ord.appSync', 1),
                        $query->expr()->eq('ord.sync', 1)
                    ),
                    $query->expr()->in('ord.code', $orCodes)
                ));
                //echo "==".$query->getQuery()->getSql()."==";
            }

            $this->entities[$entityName] = $query->getQuery()->getResult();
        }

        if (count($this->entities[$entityName]) > 0) {
            foreach ($this->entities[$entityName] as $item) {
                if (
                    ($compareIdColumn === true && $item->getId() == trim($syncCode))
                    ||
                    (method_exists($item, 'getCode') && trim($item->getCode()) == trim($syncCode))
                )
                    return $item;
            }
        }

        $newEntity = new $entity();
        $this->entities[$entityName][] = $newEntity;

        return $newEntity;
    }

    private function getLowercase($list)
    {
        $response = array();
        if (is_array($list) && count($list) > 0) {
            foreach ($list as $key => $val) {
                $response[trim(strtolower($key))] = $val;
            }
        }
        return $response;
    }
}