<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataController
 *
 * @author renatopeterman
 */

namespace API\Controller;

use Zend\XmlRpc\Value\Double;

class CashierController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {
        //$this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        //return $this->config;
    }

    /**
     * @api {post} /cashier/send Send
     * @apiName SendCashier
     * @apiGroup Cashier
     * @apiDescription Envia entradas e saidas de uma viagem
     *
     * @apiParam {String} dataCaixa Data da viagem (dd/mm/yyyy HH:ii)
     * @apiParam {String} descricao Descrição do caixa* 
     * @apiParam {Number} usuario ID do usuário
     * @apiParam {Number} totalEntrada Total de entradasda viagem
     * @apiParam {Number} totalSaida Total de saidasda viagem
     * @apiParam {Number} total Total da viagem
     * @apiParam {String} obs Observações da viagem
     * @apiParam {Number} longitude Longitude da sincronizacao da viagem
     * @apiParam {Number} latitude Observações da sincronizacao da viagem
     * @apiParam {Object[]} despesas Lista de entradas e saidas
     * @apiParam {String} despesas.tipo Tipo do item sendo e(entrada) ou (s)saída
	 * @apiParam {String} despesas.dataItem Data do item
     * @apiParam {String} despesas.descricao Descricao do item
     * @apiParam {Number} despesas.quantidade Quantidade do item
     * @apiParam {Number} despesas.preco Preço do item
     * @apiParam {Number} despesas.total Total do item
     * @apiParam {String} despesas.obs Observacoes do item
     * @apiParam {Number} despesas.longitude Longitude do item
     * @apiParam {Number} despesas.latitude Observações do item
     *
     * @apiHeaderExample {json} Content-Type:
     *     {
     *       "Content-Type": "Content-Type: application/json; charset=utf-8"
     *     }
     *
     * @apiSuccess {Boolean} success Indica se o registro foi inserido corretamente
     * @apiSuccess {Number} id ID da viagem inserida
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              "success": true,
     *              "id": 1
     *          }
     *      ]
     *
     * @apiErrorExample Error-Response:
     *      HTTP/1.1 404 Not Found
     *      {
     *          "error": true,
     *          "message": "NotFound"
     *      }
     *
     */
    public function sendAction(){

        try{

            //$this->setConfig();

            $content = $this->getRequest()->getContent();
            if(!$content){
                throw new \Exception("Conteúdo da requisição inválido");
            }

            //error_log($content, 3, ROOT_PATH."/logs/error.log");

            $json = json_decode($content, true);
            if(json_last_error() != 0){
                throw new \Exception("Erro ao decodificar dados (Json error " . json_last_error() . ")");
            }

            if(isset($json['usuario']) === false){
                throw new \Exception("Usuario invalido");
            }

            $user = $this->getEntityManager()->find('Model\Entity\User', $json['usuario']);
            if(!$user){
                $user = $this->getUser();
                if (is_object($user) === false)
                    throw new \Exception('Usuario não encontrado');
            }
            
            if(isset($json['despesas']) === false || count($json['despesas']) <= 0){
                
                throw new \Exception('Não há despesas na viagem');
            }
            
            $cashier = new \Model\Entity\Cashier();
            $cashier->setUser($user);
            $cashier->setCashierDate(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", $json['dataCaixa']));
            $cashier->setDescription($json['descricao']);
            $cashier->setTotalInput($json['totalEntrada']);
            $cashier->setTotalOutput($json['totalSaida']);
            $cashier->setTotal($json['total']);
            $cashier->setInfo($json['obs']);
            $cashier->setLatitude(isset($json['latitude']) ? $json['latitude'] : '');
            $cashier->setLongitude(isset($json['longitude']) ? $json['longitude'] : '');
            $cashier->setSync(false);
            $cashier->setActive(true);

            $this->getEntityManager()->persist($cashier);

            foreach($json['despesas'] as $item){

                try {

                    $op = new \Model\Entity\CashierExpense();
                    $op->setCashier($cashier);
                    $op->setType((isset($item['tipo']) ? trim($item['tipo']) : ""));
                    $op->setDescription($item['descricao']);
                    $op->setExpenseDate(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y", $item['dataItem'])); // H:i
                    $op->setAmount($item['quantidade']);
                    $op->setPrice($item['preco']);
                    $op->setTotal((Double)$item['total']);
                    $op->setObs($item['obs']);
                    $op->setLatitude(isset($json['latitude']) ? $json['latitude'] : '');
                    $op->setLongitude(isset($json['longitude']) ? $json['longitude'] : '');
                    $op->setSync(false);
                    $op->setActive(true);

                    $this->getEntityManager()->persist($op);

                }catch(\Exception $ex){
                    return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
                }

            }

            $this->getEntityManager()->flush();

            return $this->createResponse(array('success' => true, 'id' => $cashier->getId()));
            
        } catch(\Exception $ex) {
            //trigger_error($ex->getMessage());
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
        
        return $this->createNotFoundResponse();
        
    }
    
}

?>
