<?php

$configAPIs = array('Atual', 'XKey', 'Alternativa', 'Hiper', 'Unimake', 'Makito');

$config = array(

    'controllers' => array(
        'invokables' => array(
            'API\Controller\Data' => 'API\Controller\DataController',
            'API\Controller\Device' => 'API\Controller\DeviceController',
            'API\Controller\FinancialPending' => 'API\Controller\FinancialPendingController',
            'API\Controller\User' => 'API\Controller\UserController',
            'API\Controller\Order' => 'API\Controller\OrderController',
            'API\Controller\Customer' => 'API\Controller\CustomerController',
            'API\Controller\ServicesLocation' => 'API\Controller\ServicesLocationController',
            'API\Controller\Cashier' => 'API\Controller\CashierController'
        ),
    ),

    'router' => array(
        'routes' => array(

            'api-data' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/data[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Data',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-product-image' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/data[.:format]/product-image[/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Data',
                        'action' => 'product-image',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-catalog-file' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/data[.:format]/catalog-file[/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Data',
                        'action' => 'catalog-file',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-catalog-thumb' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/data[.:format]/catalog-thumb[/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Data',
                        'action' => 'catalog-thumb',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-device' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/device[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Device',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'financial-pending' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/financial-pending[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'FinancialPending',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-order' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/order[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Order',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-customer' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/customer[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Customer',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-user' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/user[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'User',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-services-location' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/services-location[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'ServicesLocation',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

            'api-cashier' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/api/cashier[.:format][/][:action][/][:id]',
                    'constraints' => array(
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'format' => '(xml|json)',
                    ),
                    'defaults' => array(
                        '__NAMESPACE__' => 'API\Controller',
                        'controller' => 'Cashier',
                        'action' => 'index',
                        'format' => 'json'
                    ),
                ),
            ),

        ),
    ),

    'view_manager' => array(
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'template_map' => array(
            'layout/print'  => __DIR__ . '/../view/layout/print.phtml',
        ),
        'template_path_stack' => array(
            __DIR__ . '/../view',
        ),
        'strategies' => array(
            'ViewJsonStrategy',
            'ViewFeedStrategy',
            'ViewXmlStrategy',
        ),
    ),


);

$controllersToInsert = array();
$routesToInsert = array();

foreach ($configAPIs as $itemCustomAPI) {

    $controllersToInsert['API\Controller\Custom\\'.trim($itemCustomAPI).'\\Sync']  = 'API\Controller\Custom\\'.trim($itemCustomAPI).'\\SyncController';
    $controllersToInsert['API\Controller\Custom\\'.trim($itemCustomAPI).'\\Data']  = 'API\Controller\Custom\\'.trim($itemCustomAPI).'\\DataController';

    $routesToInsert['api-custom-'.strtolower(trim($itemCustomAPI)).'-sync'] = array(
        'type'    => 'segment',
        'options' => array(
            'route'    => '/api/custom/'.strtolower(trim($itemCustomAPI)).'/sync[.:format][/][:action][/][:id]',
            'constraints' => array(
                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                'format' => '(xml|json)',
            ),
            'defaults' => array(
                '__NAMESPACE__' => 'API\Controller\Custom\\'.$itemCustomAPI,
                'controller' => 'Sync',
                'action' => 'index',
                'format' => 'json'
            ),
        ),
    );
    $routesToInsert['api-custom-'.strtolower(trim($itemCustomAPI)).'-data'] = array(
        'type'    => 'segment',
        'options' => array(
            'route'    => '/api/custom/'.strtolower(trim($itemCustomAPI)).'/data[.:format][/][:action][/][:id]',
            'constraints' => array(
                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                'format' => '(xml|json)',
            ),
            'defaults' => array(
                '__NAMESPACE__' => 'API\Controller\Custom\\'.$itemCustomAPI,
                'controller' => 'Data',
                'action' => 'index',
                'format' => 'json'
            ),
        ),
    );
}

$config['controllers']['invokables'] = array_merge($config['controllers']['invokables'], $controllersToInsert);

$config['router']['routes'] = array_merge($config['router']['routes'], $routesToInsert);

return $config;
