var gulp = require('gulp'),
    sass = require('gulp-ruby-sass'),
    autoprefixer = require('gulp-autoprefixer'),
    minifycss = require('gulp-minify-css'),
    jshint = require('gulp-jshint'),
    uglify = require('gulp-uglify'),
    imagemin = require('gulp-imagemin'),
    rename = require('gulp-rename'),
    concat = require('gulp-concat'),
    notify = require('gulp-notify'),
    cache = require('gulp-cache'),
    livereload = require('gulp-livereload'),
    uglifycss = require('gulp-uglifycss'),
    flatten = require('gulp-flatten'),
    del = require('del');

var files = {
    styles: [
        'public/assets/bootstrap/css/bootstrap.min.css',
        'public/assets/fancybox/source/jquery.fancybox.css',
        'public/assets/bootstrap-themes/bootstrap.yeti.css',
        'public/bower_components/font-awesome/css/font-awesome.min.css',
        'public/bower_components/angular-motion/dist/angular-motion.min.css',
        'public/assets/select2/select2.css',
        'public/assets/select2/select2.bootstrap.css',
        'public/assets/jquery-ui/theme/jquery-ui.min.css',
        'public/assets/typeahead/typeahead.css',
        'public/bower_components/jasny-bootstrap/dist/css/jasny-bootstrap.min.css',
        'public/assets/datatable/css/dataTables.bootstrap.css',
        'public/assets/datatable-tabletools/css/dataTables.tableTools.css',
        'public/bower_components/animate.css/animate.min.css',
        'public/bower_components/angular-busy/dist/angular-busy.min.css',
        'public/bower_components/angular-loading-bar/build/loading-bar.min.css',
        'public/bower_components/angular-inform/dist/angular-inform.min.css',
        'public/bower_components/ng-notifications-bar/dist/ngNotificationsBar.min.css',
        'public/bower_components/bootstrap-daterangepicker/daterangepicker-bs3.css',
        'public/bower_components/angular-ui-select/dist/select.min.css',
        'public/bower_components/angular-xeditable/dist/css/xeditable.css',
        //'public/bower_components/awesome-bootstrap-checkbox/awesome-bootstrap-checkbox.css',
        'public/bower_components/angular-bootstrap-datetimepicker/src/css/datetimepicker.css',
        'public/assets/commons/css/style.css'
    ],
    scripts: [
        'public/assets/jquery/jquery.min.js',
        'public/assets/spin/spin.min.js',
        'public/assets/spin/jquery.spin.js',
        'public/assets/conex/init.js',
        'public/assets/conex/validator.js',
        'public/assets/conex/spin.js',
        'public/assets/select2/select2.min.js',
        'public/assets/select2/select2_locale_pt-BR.js',
        'public/assets/fancybox/source/jquery.fancybox.js',
        'public/assets/jquery-mask/jquery.mask.min.js',
        'public/assets/jquery-validation/jquery.validation.min.js',
        'public/assets/jquery-validation/jquery.validation.theme.js',
        'public/assets/jquery-validation/jquery.validation.additional-methods.min.js',
        'public/assets/jquery-validation/jquery.validation.messages_pt_BR.js',
        'public/assets/jquery-ui/js/jquery.ui.datepicker-pt-BR.min.js',
        'public/assets/jquery-ui/js/jquery-ui.min.js',
        'public/assets/jquery-ui/js/jquery-ui-timepicker-addon.js',
        'public/assets/fix/fix.conflicts.js',
        'public/assets/bootstrap/js/bootstrap.min.js',
        'public/assets/tinymce/tinymce.min.js',
        'public/assets/typeahead/typeahead.js',
        'public/assets/datatable/js/jquery.dataTables.min.js',
        'public/assets/datatable/js/dataTables.bootstrap.js',
        'public/assets/datatable-tabletools/js/dataTables.tableTools.js',
        'public/assets/noty/packaged/jquery.noty.packaged.min.js',
        'public/assets/canvasjs/canvasjs.min.js',
        'public/assets/commons/js/init.application.js',
        'public/bower_components/jasny-bootstrap/dist/js/jasny-bootstrap.min.js',
        'public/bower_components/angular/angular.min.js',
        'public/bower_components/angular-animate/angular-animate.min.js',
        'public/bower_components/ngAnimate-animate.css/animate.js',
        'public/bower_components/ngFx/dist/ngFx.min.js',
        'public/bower_components/angular-datatables/dist/angular-datatables.min.js',
        'public/bower_components/angular-datatables/dist/plugins/bootstrap/angular-datatables.bootstrap.min.js',
        'public/bower_components/angular-resource/angular-resource.min.js',
        'public/bower_components/angular-strap/dist/angular-strap.min.js',
        'public/bower_components/angular-strap/dist/angular-strap.tpl.min.js',
        'public/bower_components/angular-busy/dist/angular-busy.min.js',
        'public/bower_components/angular-route/angular-route.min.js',
        'public/bower_components/angular-loading-bar/build/loading-bar.min.js',
        'public/bower_components/angular-ui-router/release/angular-ui-router.min.js',
        'public/bower_components/angular-ui-utils/ui-utils.min.js',
        'public/bower_components/angular-sanitize/angular-sanitize.min.js',
        'public/bower_components/angular-inform/dist/angular-inform.min.js',
        //'public/bower_components/ng-notifications-bar/dist/ngNotificationsBar.min.js',
        'public/bower_components/ng-flow/dist/ng-flow-standalone.min.js',
        'public/bower_components/bootbox/bootbox.js',
        'public/bower_components/ngBootbox/dist/ngBootbox.min.js',
        'public/bower_components/jquery-qrcode/jquery.qrcode.min.js',
        'public/bower_components/moment/moment.js',
        'public/bower_components/bootstrap-daterangepicker/daterangepicker.js',
        'public/bower_components/angular-daterangepicker/js/angular-daterangepicker.js',
        'public/bower_components/angular-i18n/angular-locale_pt-br.js',
        'public/bower_components/angular-ui-select/dist/select.min.js',
        'public/bower_components/a0-angular-storage/dist/angular-storage.min.js',
        'public/bower_components/angular-xeditable/dist/js/xeditable.min.js',
        'public/bower_components/angular-ui-sortable/sortable.min.js',
        'public/bower_components/angular-smart-table/dist/smart-table.min.js',
        'public/bower_components/lodash/lodash.min.js',
        'public/bower_components/angular-google-maps/dist/angular-google-maps.min.js',
        'public/bower_components/angular-bootstrap-show-errors/src/showErrors.min.js',
        'public/bower_components/angular-bootstrap-datetimepicker/src/js/datetimepicker.js',
        'public/bower_components/angular-bootstrap-datetimepicker/src/js/datetimepicker.templates.js',
        'public/bower_components/angular-input-masks/angular-input-masks-standalone.min.js',
        'public/bower_components/ng-file-upload/ng-file-upload.min.js',
        'public/bower_components/ng-file-upload/ng-file-upload-shim.min.js',
        'public/js/services.js',
        'public/js/app.js',
        'public/js/controller/payment-condition.ctrl.js',
        'public/js/controller/payment-method.ctrl.js',
        'public/js/controller/order.ctrl.js',
        'public/js/controller/product.ctrl.js',
        'public/js/controller/unit.ctrl.js',
        'public/js/controller/group.ctrl.js',
        'public/js/controller/profile.ctrl.js',
        'public/js/controller/warehouse-manager.ctrl.js',
        'public/js/controller/dashboard.ctrl.js',
        'public/js/controller/home.ctrl.js',
        'public/js/controller/catalog.ctrl.js',
        'public/js/controller/catalog.form.ctrl.js',
        'public/js/controller/oauth2-client.ctrl.js',
        'public/js/controller/customer.ctrl.js',
        'public/js/controller/device.ctrl.js',
        'public/js/controller/user.ctrl.js',
        'public/js/controller/order.form.ctrl.js',
        'public/js/controller/color.ctrl.js',
        'public/js/controller/size.ctrl.js',
		'public/js/controller/map.ctrl.js'
    ]
}

// Le Styles
gulp.task('styles', function() {
    return gulp.src(files.styles)
        .pipe(autoprefixer('last 2 version'))
        //.pipe(rename({suffix: '.min'}))
        .pipe(minifycss({ removeEmpty: true }))
        .pipe(concat('styles.min.css'))
        .pipe(gulp.dest('public/assets/dist/css'))
        .pipe(notify({ message: 'Styles task complete' }));
});

// Scripts
gulp.task('scripts', function() {
    return gulp.src(files.scripts)
        //.pipe(jshint('.jshintrc'))
        //.pipe(jshint.reporter('default'))
        //.pipe(gulp.dest('public/assets/dist/js'))
        //.pipe(rename({ suffix: '.min' }))
        .pipe(uglify())
        .pipe(concat('scripts.min.js'))
        .pipe(gulp.dest('public/assets/dist/js'))
        .pipe(notify({ message: 'Scripts task complete' }));
});

// Copy Fonts
gulp.task('copy-fonts', function() {
    gulp.src(['public/assets/**/*.{ttf,woff,woff2,eof,svg}', 'public/bower_components/**/*.{ttf,woff,woff2,eof,svg}'])
        .pipe(flatten())
        .pipe(gulp.dest('public/assets/dist/fonts'));
});

// Copy Images
gulp.task('copy-images', function() {
    gulp.src(
        [
            'public/assets/fancybox/source/**/*.{jpg,jpeg,png,gif}',
            'public/assets/select2/*.{jpg,jpeg,png,gif}'
        ]
    )
        .pipe(flatten())
        .pipe(gulp.dest('public/assets/dist/css'));
});

// Clean
gulp.task('clean', function(cb) {
    //del(['public/assets/dist/css', 'public/assets/dist/js', 'public/assets/dist/fonts'], cb)
    del(['public/assets/dist/css','public/assets/dist/js','public/assets/dist/fonts'], cb)
});

// Watch
//gulp.task('watch', function() {
//
//    // Watch .css files
//    gulp.watch([
//        'public/assets/**/*.css',
//        'public/bower_components/**/*.css'],
//        ['styles']
//    );
//
//    // Watch .js files
//    gulp.watch([
//        'public/assets/**/*.js',
//        'public/bower_components/**/*.js',
//        'public/js/**/*.js'],
//        ['scripts']
//    );
//
//    // Create LiveReload server
//    // livereload.listen();
//
//    // Watch any files in dist/, reload on change
//    // gulp.watch(['dist/**']).on('change', livereload.changed);
//
//});

// Default task
gulp.task('default', ['clean'], function() {
    //gulp.start('styles', 'scripts', 'images');
    gulp.start('styles', 'scripts', 'copy-images', 'copy-fonts');
});