<?php

return array(
    'zf-oauth2-doctrine' => array(
        'mutatetablenames' => array(
            'access_token_entity'       => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\AccessToken',
                'primary_table' => array('name' => 'oauth2_accesstoken')
            ),
            'authorization_code_entity' => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\AuthorizationCode',
                'primary_table' => array('name' => 'oauth2_authorizationcode')
            ),
            'client_entity'             => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\Client',
                'primary_table' => array('name' => 'oauth2_client')
            ),
            # Fix
            'jti_entity'                => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\Jti',
                'primary_table' => array('name' => 'oauth2_jti')
            ),
            # Fix
            'jwt_entity'                => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\Jwt',
                'primary_table' => array('name' => 'oauth2_jwt')
            ),
            # Fix
            'public_key_entity'         => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\PublicKey',
                'primary_table' => array('name' => 'oauth2_publickey')
            ),
            'refresh_token_entity'      => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\RefreshToken',
                'primary_table' => array('name' => 'oauth2_refreshtoken')
            ),
            'scope_entity'              => array(
                'entity' => 'ZF\OAuth2\Doctrine\Entity\Scope', # Fix
                'primary_table' => array('name' => 'oauth2_scope'),
                'associations'  => array(
                    'accessToken'       => array('joinTable' => array('name' => 'oauth2_accesstoken_to_scope')),
                    'authorizationCode' => array('joinTable' => array('name' => 'oauth2_authorizationcode_to_scope')),
                    'client'            => array('joinTable' => array('name' => 'oauth2_client_to_scope')),
                    'refreshToken'      => array('joinTable' => array('name' => 'oauth2_refreshtoken_to_scope')),
                )
            ),
        ),
    ),
);