<?php
/**
 * Global Configuration Override
 *
 * You can use this file for overriding configuration values from modules, etc.
 * You would place values in here that are agnostic to the environment and not
 * sensitive to security.
 *
 * @NOTE: In practice, this file will typically be INCLUDED in your source
 * control, so do not include passwords or other sensitive information in this
 * file.
 */

return array(

    'jms_serializer' => array(
        'naming_strategy' => 'identical',
        'handlers' => array(
            /*
            'datetime' => array(
                'default_format' => 'd/m/Y', # c = ISO8601
                'default_timezone' => "America/Sao_Paulo"
            ),
            */
            'subscribers' => array(
                'DateTimeLocaleHandler'
            ),
        ),
    ),

    'view_manager' => array(
        'display_exceptions' => true,
    ),

    'zf-hal' => array(
        'renderer' => array(
            'render_collections' => true,
            'render_embedded_entities' => true,
        ),
        'metadata_map' => array(
            'Model\\Entity\\Order' => array(
                'max_depth' => 2 // Max hydrator depth
            ),
        ),
    ),

    'router' => array(
        'routes' => array(
            'oauth' => array(
                'options' => array(
                    'route' => '/api/oauth',
                ),
            ),
        ),
    ),

);
